/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.core.thing.xml.internal;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.eclipse.smarthome.core.common.osgi.ServiceBinder;
import org.eclipse.smarthome.core.i18n.I18nProvider;
import org.eclipse.smarthome.core.thing.UID;
import org.eclipse.smarthome.core.thing.i18n.ThingTypeI18nUtil;
import org.eclipse.smarthome.core.thing.type.ChannelGroupType;
import org.eclipse.smarthome.core.thing.type.ChannelGroupTypeUID;
import org.eclipse.smarthome.core.thing.type.ChannelType;
import org.eclipse.smarthome.core.thing.type.ChannelTypeProvider;
import org.eclipse.smarthome.core.thing.type.ChannelTypeUID;
import org.eclipse.smarthome.core.types.StateDescription;
import org.eclipse.smarthome.core.types.StateOption;
import org.osgi.framework.Bundle;

public class XmlChannelTypeProvider
implements ChannelTypeProvider {
    private Map<Bundle, List<ChannelGroupType>> bundleChannelGroupTypesMap;
    private Map<Bundle, List<ChannelType>> bundleChannelTypesMap;
    private Map<LocalizedChannelTypeKey, ChannelGroupType> localizedChannelGroupTypeCache = new HashMap<LocalizedChannelTypeKey, ChannelGroupType>();
    private Map<LocalizedChannelTypeKey, ChannelType> localizedChannelTypeCache = new HashMap<LocalizedChannelTypeKey, ChannelType>();
    private ThingTypeI18nUtil thingTypeI18nUtil;

    public XmlChannelTypeProvider() {
        this.bundleChannelTypesMap = new HashMap<Bundle, List<ChannelType>>(10);
        this.bundleChannelGroupTypesMap = new HashMap<Bundle, List<ChannelGroupType>>(10);
    }

    public synchronized void addChannelGroupType(Bundle bundle, ChannelGroupType channelGroupType) {
        List<ChannelGroupType> channelGroupTypes;
        if (channelGroupType != null && (channelGroupTypes = this.acquireChannelGroupTypes(bundle)) != null) {
            channelGroupTypes.add(channelGroupType);
            this.removeCachedChannelGroupTypes(channelGroupType);
        }
    }

    public synchronized void addChannelType(Bundle bundle, ChannelType channelType) {
        List<ChannelType> channelTypes;
        if (channelType != null && (channelTypes = this.acquireChannelTypes(bundle)) != null) {
            channelTypes.add(channelType);
            this.removeCachedChannelTypes(channelType);
        }
    }

    public ChannelGroupType getChannelGroupType(ChannelGroupTypeUID channelGroupTypeUID, Locale locale) {
        Set<Map.Entry<Bundle, List<ChannelGroupType>>> channelGroupTypesList = this.bundleChannelGroupTypesMap.entrySet();
        if (channelGroupTypesList != null) {
            for (Map.Entry entry : channelGroupTypesList) {
                for (ChannelGroupType channelGroupType : (List)entry.getValue()) {
                    if (!channelGroupType.getUID().equals((Object)channelGroupTypeUID)) continue;
                    return this.createLocalizedChannelGroupType((Bundle)entry.getKey(), channelGroupType, locale);
                }
            }
        }
        return null;
    }

    public Collection<ChannelGroupType> getChannelGroupTypes(Locale locale) {
        ArrayList<ChannelGroupType> allChannelGroupTypes = new ArrayList<ChannelGroupType>(10);
        Set<Map.Entry<Bundle, List<ChannelGroupType>>> channelGroupTypesList = this.bundleChannelGroupTypesMap.entrySet();
        if (channelGroupTypesList != null) {
            for (Map.Entry entry : channelGroupTypesList) {
                for (ChannelGroupType channelGroupType : (List)entry.getValue()) {
                    ChannelGroupType localizedChannelType = this.createLocalizedChannelGroupType((Bundle)entry.getKey(), channelGroupType, locale);
                    allChannelGroupTypes.add(localizedChannelType);
                }
            }
        }
        return allChannelGroupTypes;
    }

    public ChannelType getChannelType(ChannelTypeUID channelTypeUID, Locale locale) {
        Set<Map.Entry<Bundle, List<ChannelType>>> channelTypesList = this.bundleChannelTypesMap.entrySet();
        if (channelTypesList != null) {
            for (Map.Entry entry : channelTypesList) {
                for (ChannelType channelType : (List)entry.getValue()) {
                    if (!channelType.getUID().equals((Object)channelTypeUID)) continue;
                    return this.createLocalizedChannelType((Bundle)entry.getKey(), channelType, locale);
                }
            }
        }
        return null;
    }

    public synchronized Collection<ChannelType> getChannelTypes(Locale locale) {
        ArrayList<ChannelType> allChannelTypes = new ArrayList<ChannelType>(10);
        Set<Map.Entry<Bundle, List<ChannelType>>> channelTypesList = this.bundleChannelTypesMap.entrySet();
        if (channelTypesList != null) {
            for (Map.Entry entry : channelTypesList) {
                for (ChannelType channelType : (List)entry.getValue()) {
                    ChannelType localizedChannelType = this.createLocalizedChannelType((Bundle)entry.getKey(), channelType, locale);
                    allChannelTypes.add(localizedChannelType);
                }
            }
        }
        return allChannelTypes;
    }

    public synchronized void removeAllChannelGroupTypes(Bundle bundle) {
        List<ChannelGroupType> channelGroupTypes;
        if (bundle != null && (channelGroupTypes = this.bundleChannelGroupTypesMap.get(bundle)) != null) {
            this.bundleChannelGroupTypesMap.remove(bundle);
            this.removeCachedChannelGroupTypes(channelGroupTypes);
        }
    }

    public synchronized void removeAllChannelTypes(Bundle bundle) {
        List<ChannelType> channelTypes;
        if (bundle != null && (channelTypes = this.bundleChannelTypesMap.get(bundle)) != null) {
            this.bundleChannelTypesMap.remove(bundle);
            this.removeCachedChannelTypes(channelTypes);
        }
    }

    @ServiceBinder.Bind
    public void setI18nProvider(I18nProvider i18nProvider) {
        this.thingTypeI18nUtil = new ThingTypeI18nUtil(i18nProvider);
    }

    @ServiceBinder.Unbind
    public void unsetI18nProvider(I18nProvider i18nProvider) {
        this.thingTypeI18nUtil = null;
    }

    private List<ChannelGroupType> acquireChannelGroupTypes(Bundle bundle) {
        if (bundle != null) {
            List<ChannelGroupType> channelGroupTypes = this.bundleChannelGroupTypesMap.get(bundle);
            if (channelGroupTypes == null) {
                channelGroupTypes = new ArrayList<ChannelGroupType>(10);
                this.bundleChannelGroupTypesMap.put(bundle, channelGroupTypes);
            }
            return channelGroupTypes;
        }
        return null;
    }

    private List<ChannelType> acquireChannelTypes(Bundle bundle) {
        if (bundle != null) {
            List<ChannelType> channelTypes = this.bundleChannelTypesMap.get(bundle);
            if (channelTypes == null) {
                channelTypes = new ArrayList<ChannelType>(10);
                this.bundleChannelTypesMap.put(bundle, channelTypes);
            }
            return channelTypes;
        }
        return null;
    }

    private ChannelGroupType createLocalizedChannelGroupType(Bundle bundle, ChannelGroupType channelGroupType, Locale locale) {
        LocalizedChannelTypeKey localizedChannelTypeKey = this.getLocalizedChannelTypeKey((UID)channelGroupType.getUID(), locale);
        ChannelGroupType cachedEntry = this.localizedChannelGroupTypeCache.get(localizedChannelTypeKey);
        if (cachedEntry != null) {
            return cachedEntry;
        }
        if (this.thingTypeI18nUtil != null) {
            ChannelGroupTypeUID channelGroupTypeUID = channelGroupType.getUID();
            String label = this.thingTypeI18nUtil.getChannelGroupLabel(bundle, channelGroupTypeUID, channelGroupType.getLabel(), locale);
            String description = this.thingTypeI18nUtil.getChannelGroupDescription(bundle, channelGroupTypeUID, channelGroupType.getDescription(), locale);
            ChannelGroupType localizedChannelType = new ChannelGroupType(channelGroupTypeUID, channelGroupType.isAdvanced(), label, description, channelGroupType.getChannelDefinitions());
            this.localizedChannelGroupTypeCache.put(localizedChannelTypeKey, localizedChannelType);
            return localizedChannelType;
        }
        return channelGroupType;
    }

    private StateDescription createLocalizedChannelState(Bundle bundle, ChannelType channelType, ChannelTypeUID channelTypeUID, Locale locale) {
        StateDescription state = channelType.getState();
        if (state != null) {
            String pattern = this.thingTypeI18nUtil.getChannelStatePattern(bundle, channelTypeUID, state.getPattern(), locale);
            ArrayList<StateOption> localizedOptions = new ArrayList<StateOption>();
            List options = state.getOptions();
            for (StateOption stateOption : options) {
                String optionLabel = this.thingTypeI18nUtil.getChannelStateOption(bundle, channelTypeUID, stateOption.getValue(), stateOption.getLabel(), locale);
                localizedOptions.add(new StateOption(stateOption.getValue(), optionLabel));
            }
            return new StateDescription(state.getMinimum(), state.getMaximum(), state.getStep(), pattern, state.isReadOnly(), localizedOptions);
        }
        return null;
    }

    private ChannelType createLocalizedChannelType(Bundle bundle, ChannelType channelType, Locale locale) {
        LocalizedChannelTypeKey localizedChannelTypeKey = this.getLocalizedChannelTypeKey((UID)channelType.getUID(), locale);
        ChannelType cachedEntry = this.localizedChannelTypeCache.get(localizedChannelTypeKey);
        if (cachedEntry != null) {
            return cachedEntry;
        }
        if (this.thingTypeI18nUtil != null) {
            ChannelTypeUID channelTypeUID = channelType.getUID();
            String label = this.thingTypeI18nUtil.getChannelLabel(bundle, channelTypeUID, channelType.getLabel(), locale);
            String description = this.thingTypeI18nUtil.getChannelDescription(bundle, channelTypeUID, channelType.getDescription(), locale);
            StateDescription state = this.createLocalizedChannelState(bundle, channelType, channelTypeUID, locale);
            ChannelType localizedChannelType = new ChannelType(channelTypeUID, channelType.isAdvanced(), channelType.getItemType(), label, description, channelType.getCategory(), channelType.getTags(), state, channelType.getConfigDescriptionURI());
            this.localizedChannelTypeCache.put(localizedChannelTypeKey, localizedChannelType);
            return localizedChannelType;
        }
        return channelType;
    }

    private LocalizedChannelTypeKey getLocalizedChannelTypeKey(UID uid, Locale locale) {
        String localeString = locale != null ? locale.toLanguageTag() : null;
        LocalizedChannelTypeKey localizedChannelTypeKey = new LocalizedChannelTypeKey(uid, locale != null ? localeString : null);
        return localizedChannelTypeKey;
    }

    private void removeCachedChannelGroupTypes(ChannelGroupType channelGroupType) {
        Iterator<Map.Entry<LocalizedChannelTypeKey, ChannelGroupType>> iterator = this.localizedChannelGroupTypeCache.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<LocalizedChannelTypeKey, ChannelGroupType> entry = iterator.next();
            if (!entry.getKey().uid.equals((Object)channelGroupType.getUID())) continue;
            iterator.remove();
        }
    }

    private void removeCachedChannelGroupTypes(List<ChannelGroupType> channelGroupTypes) {
        for (ChannelGroupType channelGroupType : channelGroupTypes) {
            this.removeCachedChannelGroupTypes(channelGroupType);
        }
    }

    private void removeCachedChannelTypes(ChannelType channelType) {
        Iterator<Map.Entry<LocalizedChannelTypeKey, ChannelType>> iterator = this.localizedChannelTypeCache.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<LocalizedChannelTypeKey, ChannelType> entry = iterator.next();
            if (!entry.getKey().uid.equals((Object)channelType.getUID())) continue;
            iterator.remove();
        }
    }

    private void removeCachedChannelTypes(List<ChannelType> channelTypes) {
        for (ChannelType channelType : channelTypes) {
            this.removeCachedChannelTypes(channelType);
        }
    }

    private class LocalizedChannelTypeKey {
        public String locale;
        public UID uid;

        public LocalizedChannelTypeKey(UID uid, String locale) {
            this.uid = uid;
            this.locale = locale;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            LocalizedChannelTypeKey other = (LocalizedChannelTypeKey)obj;
            if (!this.getOuterType().equals(other.getOuterType())) {
                return false;
            }
            if (this.locale == null ? other.locale != null : !this.locale.equals(other.locale)) {
                return false;
            }
            return !(this.uid == null ? other.uid != null : !this.uid.equals((Object)other.uid));
        }

        public int hashCode() {
            int result = 1;
            result = 31 * result + this.getOuterType().hashCode();
            result = 31 * result + (this.locale == null ? 0 : this.locale.hashCode());
            result = 31 * result + (this.uid == null ? 0 : this.uid.hashCode());
            return result;
        }

        private XmlChannelTypeProvider getOuterType() {
            return XmlChannelTypeProvider.this;
        }
    }
}

