/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.core.thing.xml.internal;

import com.thoughtworks.xstream.converters.ConversionException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.eclipse.smarthome.config.core.ConfigDescription;
import org.eclipse.smarthome.config.xml.XmlConfigDescriptionProvider;
import org.eclipse.smarthome.config.xml.osgi.XmlDocumentProvider;
import org.eclipse.smarthome.core.thing.type.ChannelType;
import org.eclipse.smarthome.core.thing.xml.internal.ChannelGroupTypeXmlResult;
import org.eclipse.smarthome.core.thing.xml.internal.ChannelTypeXmlResult;
import org.eclipse.smarthome.core.thing.xml.internal.ThingTypeXmlResult;
import org.eclipse.smarthome.core.thing.xml.internal.XmlChannelTypeProvider;
import org.eclipse.smarthome.core.thing.xml.internal.XmlThingTypeProvider;
import org.osgi.framework.Bundle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ThingTypeXmlProvider
implements XmlDocumentProvider<List<?>> {
    private Logger logger = LoggerFactory.getLogger(ThingTypeXmlProvider.class);
    private Bundle bundle;
    private XmlConfigDescriptionProvider configDescriptionProvider;
    private XmlThingTypeProvider thingTypeProvider;
    private List<ThingTypeXmlResult> thingTypeRefs;
    private List<ChannelGroupTypeXmlResult> channelGroupTypeRefs;
    private List<ChannelTypeXmlResult> channelTypeRefs;
    private XmlChannelTypeProvider channelTypeProvider;

    public ThingTypeXmlProvider(Bundle bundle, XmlConfigDescriptionProvider configDescriptionProvider, XmlThingTypeProvider thingTypeProvider, XmlChannelTypeProvider channelTypeProvider) throws IllegalArgumentException {
        if (bundle == null) {
            throw new IllegalArgumentException("The Bundle must not be null!");
        }
        if (configDescriptionProvider == null) {
            throw new IllegalArgumentException("The XmlConfigDescriptionProvider must not be null!");
        }
        if (thingTypeProvider == null) {
            throw new IllegalArgumentException("The XmlThingTypeProvider must not be null!");
        }
        this.bundle = bundle;
        this.configDescriptionProvider = configDescriptionProvider;
        this.thingTypeProvider = thingTypeProvider;
        this.channelTypeProvider = channelTypeProvider;
        this.thingTypeRefs = new ArrayList<ThingTypeXmlResult>(10);
        this.channelGroupTypeRefs = new ArrayList<ChannelGroupTypeXmlResult>(10);
        this.channelGroupTypeRefs = new ArrayList<ChannelGroupTypeXmlResult>(10);
        this.channelTypeRefs = new ArrayList<ChannelTypeXmlResult>(10);
    }

    public synchronized void addingObject(List<?> types) {
        if (types != null) {
            for (Object type : types) {
                Object typeResult;
                if (type instanceof ThingTypeXmlResult) {
                    typeResult = (ThingTypeXmlResult)type;
                    this.addConfigDescription(((ThingTypeXmlResult)typeResult).getConfigDescription());
                    this.thingTypeRefs.add((ThingTypeXmlResult)typeResult);
                    continue;
                }
                if (type instanceof ChannelGroupTypeXmlResult) {
                    typeResult = (ChannelGroupTypeXmlResult)type;
                    this.channelGroupTypeRefs.add((ChannelGroupTypeXmlResult)typeResult);
                    continue;
                }
                if (type instanceof ChannelTypeXmlResult) {
                    typeResult = (ChannelTypeXmlResult)type;
                    this.channelTypeRefs.add((ChannelTypeXmlResult)typeResult);
                    this.addConfigDescription(((ChannelTypeXmlResult)typeResult).getConfigDescription());
                    continue;
                }
                throw new ConversionException("Unknown data type for '" + type + "'!");
            }
        }
    }

    private void addConfigDescription(ConfigDescription configDescription) {
        if (configDescription != null) {
            try {
                this.configDescriptionProvider.addConfigDescription(this.bundle, configDescription);
            }
            catch (Exception ex) {
                this.logger.error("Could not register ConfigDescription!", (Throwable)ex);
            }
        }
    }

    public synchronized void addingFinished() {
        HashMap<String, ChannelType> channelTypes = new HashMap<String, ChannelType>(10);
        for (ChannelTypeXmlResult channelTypeXmlResult : this.channelTypeRefs) {
            ChannelType channelType = channelTypeXmlResult.toChannelType();
            channelTypes.put(channelType.getUID().getAsString(), channelType);
            this.channelTypeProvider.addChannelType(this.bundle, channelType);
        }
        for (ChannelGroupTypeXmlResult channelGroupTypeXmlResult : this.channelGroupTypeRefs) {
            this.channelTypeProvider.addChannelGroupType(this.bundle, channelGroupTypeXmlResult.toChannelGroupType(channelTypes));
        }
        for (ThingTypeXmlResult thingTypeXmlResult : this.thingTypeRefs) {
            this.thingTypeProvider.addThingType(this.bundle, thingTypeXmlResult.toThingType());
        }
        this.thingTypeRefs.clear();
        this.channelGroupTypeRefs.clear();
        this.channelTypeRefs.clear();
    }

    public synchronized void release() {
        this.thingTypeProvider.removeAllThingTypes(this.bundle);
        this.channelTypeProvider.removeAllChannelGroupTypes(this.bundle);
        this.channelTypeProvider.removeAllChannelTypes(this.bundle);
        this.configDescriptionProvider.removeAllConfigDescriptions(this.bundle);
    }
}

