/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.core.thing.xml.internal;

import com.thoughtworks.xstream.converters.ConversionException;
import com.thoughtworks.xstream.converters.UnmarshallingContext;
import com.thoughtworks.xstream.io.HierarchicalStreamReader;
import java.util.List;
import java.util.Map;
import org.eclipse.smarthome.config.xml.util.ConverterAttributeMapValidator;
import org.eclipse.smarthome.config.xml.util.NodeIterator;
import org.eclipse.smarthome.config.xml.util.NodeList;
import org.eclipse.smarthome.config.xml.util.NodeValue;
import org.eclipse.smarthome.core.thing.ThingTypeUID;
import org.eclipse.smarthome.core.thing.xml.internal.AbstractDescriptionTypeConverter;
import org.eclipse.smarthome.core.thing.xml.internal.ChannelXmlResult;
import org.eclipse.smarthome.core.thing.xml.internal.ThingTypeXmlResult;

public class ThingTypeConverter
extends AbstractDescriptionTypeConverter<ThingTypeXmlResult> {
    public ThingTypeConverter() {
        this(ThingTypeXmlResult.class, "thing-type");
    }

    protected ThingTypeConverter(Class clazz, String type) {
        super(clazz, type);
        this.attributeMapValidator = new ConverterAttributeMapValidator((String[][])new String[][]{{"id", "true"}, {"listed", "false"}});
    }

    protected List<String> readSupportedBridgeTypeUIDs(NodeIterator nodeIterator, UnmarshallingContext context) {
        Object nextNode = nodeIterator.next("supported-bridge-type-refs", false);
        if (nextNode != null) {
            String bindingID = (String)context.get((Object)"thing-descriptions.bindingId");
            String uidFormat = String.format("%s:%s", bindingID, "%s");
            return ((NodeList)nextNode).getAttributes("bridge-type-ref", "id", uidFormat);
        }
        return null;
    }

    protected List<ChannelXmlResult>[] getChannelTypeReferenceObjects(NodeIterator nodeIterator) throws ConversionException {
        List channelTypeReferences = null;
        List channelGroupTypeReferences = null;
        channelTypeReferences = nodeIterator.nextList("channels", false);
        if (channelTypeReferences == null) {
            channelGroupTypeReferences = nodeIterator.nextList("channel-groups", false);
        }
        return new List[]{channelTypeReferences, channelGroupTypeReferences};
    }

    protected List<NodeValue> getProperties(NodeIterator nodeIterator) {
        return nodeIterator.nextList("properties", false);
    }

    @Override
    protected ThingTypeXmlResult unmarshalType(HierarchicalStreamReader reader, UnmarshallingContext context, Map<String, String> attributes, NodeIterator nodeIterator) throws ConversionException {
        ThingTypeXmlResult thingTypeXmlResult = new ThingTypeXmlResult(new ThingTypeUID(super.getUID(attributes, context)), this.readSupportedBridgeTypeUIDs(nodeIterator, context), super.readLabel(nodeIterator), super.readDescription(nodeIterator), this.getListed(attributes), this.getChannelTypeReferenceObjects(nodeIterator), this.getProperties(nodeIterator), super.getConfigDescriptionObjects(nodeIterator));
        return thingTypeXmlResult;
    }

    protected boolean getListed(Map<String, String> attributes) {
        String listedFlag = attributes.get("listed");
        if (listedFlag != null) {
            return Boolean.parseBoolean(listedFlag);
        }
        return true;
    }
}

