/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.core.thing.xml.internal;

import com.thoughtworks.xstream.converters.ConversionException;
import com.thoughtworks.xstream.converters.UnmarshallingContext;
import com.thoughtworks.xstream.io.HierarchicalStreamReader;
import java.net.URI;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.smarthome.config.core.ConfigDescription;
import org.eclipse.smarthome.config.xml.util.ConverterAttributeMapValidator;
import org.eclipse.smarthome.config.xml.util.NodeIterator;
import org.eclipse.smarthome.config.xml.util.NodeValue;
import org.eclipse.smarthome.core.thing.type.ChannelType;
import org.eclipse.smarthome.core.thing.type.ChannelTypeUID;
import org.eclipse.smarthome.core.thing.xml.internal.AbstractDescriptionTypeConverter;
import org.eclipse.smarthome.core.thing.xml.internal.ChannelTypeXmlResult;
import org.eclipse.smarthome.core.thing.xml.internal.XmlHelper;
import org.eclipse.smarthome.core.types.StateDescription;

public class ChannelTypeConverter
extends AbstractDescriptionTypeConverter<ChannelTypeXmlResult> {
    public ChannelTypeConverter() {
        super(ChannelTypeXmlResult.class, "channel-type");
        this.attributeMapValidator = new ConverterAttributeMapValidator((String[][])new String[][]{{"id", "true"}, {"advanced", "false"}, {"system", "false"}});
    }

    private boolean readBoolean(Map<String, String> attributes, String attributeName, boolean defaultValue) {
        String advancedFlag = attributes.get(attributeName);
        if (advancedFlag != null) {
            return Boolean.parseBoolean(advancedFlag);
        }
        return defaultValue;
    }

    private String readItemType(NodeIterator nodeIterator) throws ConversionException {
        return (String)nodeIterator.nextValue("item-type", true);
    }

    private String readCategory(NodeIterator nodeIterator) throws ConversionException {
        return (String)nodeIterator.nextValue("category", false);
    }

    private Set<String> readTags(NodeIterator nodeIterator) throws ConversionException {
        HashSet<String> tags = null;
        List tagsNode = nodeIterator.nextList("tags", false);
        if (tagsNode != null) {
            tags = new HashSet<String>(tagsNode.size());
            for (Object tagNodeObject : tagsNode) {
                NodeValue tagNode = (NodeValue)tagNodeObject;
                if ("tag".equals(tagNode.getNodeName())) {
                    String tag = (String)tagNode.getValue();
                    if (tag == null) continue;
                    tags.add(tag);
                    continue;
                }
                throw new ConversionException("The 'tags' node must only contain 'tag' nodes!");
            }
        }
        return tags;
    }

    private StateDescription readStateDescription(NodeIterator nodeIterator) {
        Object nextNode = nodeIterator.next();
        if (nextNode != null) {
            if (nextNode instanceof StateDescription) {
                return (StateDescription)nextNode;
            }
            nodeIterator.revert();
        }
        return null;
    }

    @Override
    protected ChannelTypeXmlResult unmarshalType(HierarchicalStreamReader reader, UnmarshallingContext context, Map<String, String> attributes, NodeIterator nodeIterator) throws ConversionException {
        boolean advanced = this.readBoolean(attributes, "advanced", false);
        boolean system = this.readBoolean(attributes, "system", false);
        String uid = system ? XmlHelper.getSystemUID(super.getID(attributes)) : super.getUID(attributes, context);
        ChannelTypeUID channelTypeUID = new ChannelTypeUID(uid);
        String itemType = this.readItemType(nodeIterator);
        String label = super.readLabel(nodeIterator);
        String description = super.readDescription(nodeIterator);
        String category = this.readCategory(nodeIterator);
        Set<String> tags = this.readTags(nodeIterator);
        StateDescription stateDescription = this.readStateDescription(nodeIterator);
        Object[] configDescriptionObjects = super.getConfigDescriptionObjects(nodeIterator);
        ChannelType channelType = new ChannelType(channelTypeUID, advanced, itemType, label, description, category, tags, stateDescription, (URI)configDescriptionObjects[0]);
        ChannelTypeXmlResult channelTypeXmlResult = new ChannelTypeXmlResult(channelType, (ConfigDescription)configDescriptionObjects[1], system);
        return channelTypeXmlResult;
    }
}

