/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.core.extension.sample.internal;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.lang.RandomStringUtils;
import org.apache.commons.lang.StringUtils;
import org.eclipse.smarthome.core.extension.Extension;
import org.eclipse.smarthome.core.extension.ExtensionService;
import org.eclipse.smarthome.core.extension.ExtensionType;

public class SampleExtensionService
implements ExtensionService {
    List<ExtensionType> types = new ArrayList<ExtensionType>(3);
    Map<String, Extension> extensions = new HashMap<String, Extension>(30);

    protected void activate() {
        this.types.add(new ExtensionType("binding", "Bindings"));
        this.types.add(new ExtensionType("ui", "User Interfaces"));
        this.types.add(new ExtensionType("persistence", "Persistence Services"));
        for (ExtensionType type : this.types) {
            int i = 0;
            while (i < 10) {
                String id = String.valueOf(type.getId()) + Integer.toString(i);
                boolean installed = Math.random() > 0.5;
                String label = String.valueOf(RandomStringUtils.randomAlphabetic((int)5)) + " " + StringUtils.capitalize((String)type.getId());
                String typeId = type.getId();
                String version = "1.0";
                Extension extension = new Extension(id, typeId, label, version, installed);
                this.extensions.put(extension.getId(), extension);
                ++i;
            }
        }
    }

    protected void deactivate() {
        this.types.clear();
        this.extensions.clear();
    }

    public void install(String id) {
        try {
            Thread.sleep((long)(Math.random() * 10000.0));
            Extension extension = this.getExtension(id, null);
            extension.setInstalled(true);
        }
        catch (InterruptedException interruptedException) {}
    }

    public void uninstall(String id) {
        try {
            Thread.sleep((long)(Math.random() * 5000.0));
            Extension extension = this.getExtension(id, null);
            extension.setInstalled(false);
        }
        catch (InterruptedException interruptedException) {}
    }

    public List<Extension> getExtensions(Locale locale) {
        return new ArrayList<Extension>(this.extensions.values());
    }

    public Extension getExtension(String id, Locale locale) {
        return this.extensions.get(id);
    }

    public List<ExtensionType> getTypes(Locale locale) {
        return this.types;
    }
}

