/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.core.binding.xml.internal;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.eclipse.smarthome.core.binding.BindingInfo;
import org.eclipse.smarthome.core.binding.BindingInfoProvider;
import org.eclipse.smarthome.core.common.osgi.ServiceBinder;
import org.eclipse.smarthome.core.i18n.BindingI18nUtil;
import org.eclipse.smarthome.core.i18n.I18nProvider;
import org.osgi.framework.Bundle;

public class XmlBindingInfoProvider
implements BindingInfoProvider {
    private Map<Bundle, List<BindingInfo>> bundleBindingInfoMap = new HashMap<Bundle, List<BindingInfo>>(10);
    private BindingI18nUtil bindingI18nUtil;

    private List<BindingInfo> acquireBindingInfos(Bundle bundle) {
        if (bundle != null) {
            List<BindingInfo> bindingInfos = this.bundleBindingInfoMap.get(bundle);
            if (bindingInfos == null) {
                bindingInfos = new ArrayList<BindingInfo>(10);
                this.bundleBindingInfoMap.put(bundle, bindingInfos);
            }
            return bindingInfos;
        }
        return null;
    }

    public synchronized void addBindingInfo(Bundle bundle, BindingInfo bindingInfo) {
        List<BindingInfo> bindingInfos;
        if (bindingInfo != null && (bindingInfos = this.acquireBindingInfos(bundle)) != null) {
            bindingInfos.add(bindingInfo);
        }
    }

    public synchronized void removeAllBindingInfos(Bundle bundle) {
        List<BindingInfo> bindingInfos;
        if (bundle != null && (bindingInfos = this.bundleBindingInfoMap.get(bundle)) != null) {
            this.bundleBindingInfoMap.remove(bundle);
        }
    }

    public synchronized BindingInfo getBindingInfo(String id, Locale locale) {
        Set<Map.Entry<Bundle, List<BindingInfo>>> bindingInfoList = this.bundleBindingInfoMap.entrySet();
        if (bindingInfoList != null) {
            for (Map.Entry entry : bindingInfoList) {
                for (BindingInfo bindingInfo : (List)entry.getValue()) {
                    if (!bindingInfo.getId().equals(id)) continue;
                    return this.createLocalizedBindingInfo((Bundle)entry.getKey(), bindingInfo, locale);
                }
            }
        }
        return null;
    }

    public synchronized Set<BindingInfo> getBindingInfos(Locale locale) {
        LinkedHashSet<BindingInfo> allBindingInfos = new LinkedHashSet<BindingInfo>(10);
        Set<Map.Entry<Bundle, List<BindingInfo>>> bindingInfoSet = this.bundleBindingInfoMap.entrySet();
        if (bindingInfoSet != null) {
            for (Map.Entry entry : bindingInfoSet) {
                for (BindingInfo bindingInfo : (List)entry.getValue()) {
                    BindingInfo localizedBindingInfo = this.createLocalizedBindingInfo((Bundle)entry.getKey(), bindingInfo, locale);
                    allBindingInfos.add(localizedBindingInfo);
                }
            }
        }
        return allBindingInfos;
    }

    @ServiceBinder.Bind
    public void setI18nProvider(I18nProvider i18nProvider) {
        this.bindingI18nUtil = new BindingI18nUtil(i18nProvider);
    }

    @ServiceBinder.Unbind
    public void unsetI18nProvider(I18nProvider i18nProvider) {
        this.bindingI18nUtil = null;
    }

    private BindingInfo createLocalizedBindingInfo(Bundle bundle, BindingInfo bindingInfo, Locale locale) {
        if (this.bindingI18nUtil != null) {
            String name = this.bindingI18nUtil.getName(bundle, bindingInfo.getId(), bindingInfo.getName(), locale);
            String description = this.bindingI18nUtil.getDescription(bundle, bindingInfo.getId(), bindingInfo.getDescription(), locale);
            return new BindingInfo(bindingInfo.getId(), name, description, bindingInfo.getAuthor(), bindingInfo.getServiceId(), bindingInfo.getConfigDescriptionURI());
        }
        return bindingInfo;
    }
}

