/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.config.core.i18n;

import java.net.URI;
import java.util.Locale;
import org.eclipse.smarthome.core.i18n.I18nProvider;
import org.eclipse.smarthome.core.i18n.I18nUtil;
import org.osgi.framework.Bundle;

public class ConfigDescriptionGroupI18nUtil {
    private I18nProvider i18nProvider;

    public ConfigDescriptionGroupI18nUtil(I18nProvider i18nProvider) {
        this.i18nProvider = i18nProvider;
    }

    public String getGroupDescription(Bundle bundle, URI configDescriptionURI, String groupName, String defaultDescription, Locale locale) {
        String key = I18nUtil.isConstant((String)defaultDescription) ? I18nUtil.stripConstant((String)defaultDescription) : this.inferKey(configDescriptionURI, groupName, "description");
        return this.i18nProvider.getText(bundle, key, defaultDescription, locale);
    }

    public String getGroupLabel(Bundle bundle, URI configDescriptionURI, String groupName, String defaultLabel, Locale locale) {
        String key = I18nUtil.isConstant((String)defaultLabel) ? I18nUtil.stripConstant((String)defaultLabel) : this.inferKey(configDescriptionURI, groupName, "label");
        return this.i18nProvider.getText(bundle, key, defaultLabel, locale);
    }

    private String inferKey(URI configDescriptionURI, String groupName, String lastSegment) {
        String uri = configDescriptionURI.getSchemeSpecificPart().replace(":", ".");
        return String.valueOf(configDescriptionURI.getScheme()) + ".config." + uri + ".group." + groupName + "." + lastSegment;
    }
}

