/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.automation.module.core.handler;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import java.util.Set;
import org.eclipse.smarthome.automation.Module;
import org.eclipse.smarthome.automation.Trigger;
import org.eclipse.smarthome.automation.handler.BaseModuleHandler;
import org.eclipse.smarthome.automation.handler.RuleEngineCallback;
import org.eclipse.smarthome.automation.handler.TriggerHandler;
import org.eclipse.smarthome.core.events.Event;
import org.eclipse.smarthome.core.events.EventFilter;
import org.eclipse.smarthome.core.events.EventSubscriber;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GenericEventTriggerHandler
extends BaseModuleHandler<Trigger>
implements TriggerHandler,
EventSubscriber {
    private final Logger logger = LoggerFactory.getLogger(GenericEventTriggerHandler.class);
    private RuleEngineCallback callback;
    private String source;
    private String topic;
    private Set<String> types;
    private BundleContext bundleContext;
    public static final String MODULE_TYPE_ID = "GenericEventTrigger";
    private static final String CFG_EVENT_TOPIC = "eventTopic";
    private static final String CFG_EVENT_SOURCE = "eventSource";
    private static final String CFG_EVENT_TYPES = "eventTypes";
    private ServiceRegistration eventSubscriberRegistration;

    public GenericEventTriggerHandler(Trigger module, BundleContext bundleContext) {
        super((Module)module);
        this.source = (String)module.getConfiguration().get(CFG_EVENT_SOURCE);
        this.topic = (String)module.getConfiguration().get(CFG_EVENT_TOPIC);
        this.types = ImmutableSet.copyOf((Object[])((String)module.getConfiguration().get(CFG_EVENT_TYPES)).split(","));
        this.bundleContext = bundleContext;
        Hashtable<String, String> properties = new Hashtable<String, String>();
        ((Dictionary)properties).put("event.topics", this.topic);
        this.eventSubscriberRegistration = this.bundleContext.registerService(EventSubscriber.class.getName(), (Object)this, properties);
        this.logger.trace("Registered EventSubscriber: Topic: {} Type: {} Source: {}", new Object[]{this.topic, this.types, this.source});
    }

    public void setRuleEngineCallback(RuleEngineCallback ruleCallback) {
        this.callback = ruleCallback;
    }

    public Set<String> getSubscribedEventTypes() {
        return this.types;
    }

    public EventFilter getEventFilter() {
        return null;
    }

    public void receive(Event event) {
        if (this.callback != null) {
            this.logger.trace("Received Event: Source: " + event.getSource() + " Topic: " + event.getTopic() + " Type: " + event.getType() + " Payload: " + event.getPayload());
            if (!event.getTopic().contains(this.source)) {
                return;
            }
            HashMap values = Maps.newHashMap();
            values.put("event", event);
            this.callback.triggered((Trigger)this.module, (Map)values);
        }
    }

    public String getTopic() {
        return this.topic;
    }

    public void setTopic(String topic) {
        this.topic = topic;
    }

    public void dispose() {
        if (this.eventSubscriberRegistration != null) {
            this.eventSubscriberRegistration.unregister();
            this.eventSubscriberRegistration = null;
        }
    }
}

