package org.eclipse.smarthome.model.thing.serializer;

import com.google.inject.Inject;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.smarthome.model.thing.services.ThingGrammarAccess;
import org.eclipse.xtext.IGrammarAccess;
import org.eclipse.xtext.RuleCall;
import org.eclipse.xtext.nodemodel.INode;
import org.eclipse.xtext.serializer.analysis.GrammarAlias.AbstractElementAlias;
import org.eclipse.xtext.serializer.analysis.GrammarAlias.GroupAlias;
import org.eclipse.xtext.serializer.analysis.GrammarAlias.TokenAlias;
import org.eclipse.xtext.serializer.analysis.ISyntacticSequencerPDAProvider.ISynNavigable;
import org.eclipse.xtext.serializer.analysis.ISyntacticSequencerPDAProvider.ISynTransition;
import org.eclipse.xtext.serializer.sequencer.AbstractSyntacticSequencer;

@SuppressWarnings("all")
public class ThingSyntacticSequencer extends AbstractSyntacticSequencer {

	protected ThingGrammarAccess grammarAccess;
	protected AbstractElementAlias match_ModelBridge_ChannelsKeyword_4_3_q;
	protected AbstractElementAlias match_ModelBridge_ThingsKeyword_4_1_q;
	protected AbstractElementAlias match_ModelBridge___LeftCurlyBracketKeyword_4_0_ThingsKeyword_4_1_q_ChannelsKeyword_4_3_q_RightCurlyBracketKeyword_4_5__q;
	protected AbstractElementAlias match_ModelBridge___LeftSquareBracketKeyword_3_0_RightSquareBracketKeyword_3_3__q;
	protected AbstractElementAlias match_ModelThing_ChannelsKeyword_3_1_q;
	protected AbstractElementAlias match_ModelThing_ThingKeyword_0_q;
	protected AbstractElementAlias match_ModelThing___LeftCurlyBracketKeyword_3_0_ChannelsKeyword_3_1_q_RightCurlyBracketKeyword_3_3__q;
	protected AbstractElementAlias match_ModelThing___LeftSquareBracketKeyword_2_0_RightSquareBracketKeyword_2_3__q;
	
	@Inject
	protected void init(IGrammarAccess access) {
		grammarAccess = (ThingGrammarAccess) access;
		match_ModelBridge_ChannelsKeyword_4_3_q = new TokenAlias(false, true, grammarAccess.getModelBridgeAccess().getChannelsKeyword_4_3());
		match_ModelBridge_ThingsKeyword_4_1_q = new TokenAlias(false, true, grammarAccess.getModelBridgeAccess().getThingsKeyword_4_1());
		match_ModelBridge___LeftCurlyBracketKeyword_4_0_ThingsKeyword_4_1_q_ChannelsKeyword_4_3_q_RightCurlyBracketKeyword_4_5__q = new GroupAlias(false, true, new TokenAlias(false, false, grammarAccess.getModelBridgeAccess().getLeftCurlyBracketKeyword_4_0()), new TokenAlias(false, true, grammarAccess.getModelBridgeAccess().getThingsKeyword_4_1()), new TokenAlias(false, true, grammarAccess.getModelBridgeAccess().getChannelsKeyword_4_3()), new TokenAlias(false, false, grammarAccess.getModelBridgeAccess().getRightCurlyBracketKeyword_4_5()));
		match_ModelBridge___LeftSquareBracketKeyword_3_0_RightSquareBracketKeyword_3_3__q = new GroupAlias(false, true, new TokenAlias(false, false, grammarAccess.getModelBridgeAccess().getLeftSquareBracketKeyword_3_0()), new TokenAlias(false, false, grammarAccess.getModelBridgeAccess().getRightSquareBracketKeyword_3_3()));
		match_ModelThing_ChannelsKeyword_3_1_q = new TokenAlias(false, true, grammarAccess.getModelThingAccess().getChannelsKeyword_3_1());
		match_ModelThing_ThingKeyword_0_q = new TokenAlias(false, true, grammarAccess.getModelThingAccess().getThingKeyword_0());
		match_ModelThing___LeftCurlyBracketKeyword_3_0_ChannelsKeyword_3_1_q_RightCurlyBracketKeyword_3_3__q = new GroupAlias(false, true, new TokenAlias(false, false, grammarAccess.getModelThingAccess().getLeftCurlyBracketKeyword_3_0()), new TokenAlias(false, true, grammarAccess.getModelThingAccess().getChannelsKeyword_3_1()), new TokenAlias(false, false, grammarAccess.getModelThingAccess().getRightCurlyBracketKeyword_3_3()));
		match_ModelThing___LeftSquareBracketKeyword_2_0_RightSquareBracketKeyword_2_3__q = new GroupAlias(false, true, new TokenAlias(false, false, grammarAccess.getModelThingAccess().getLeftSquareBracketKeyword_2_0()), new TokenAlias(false, false, grammarAccess.getModelThingAccess().getRightSquareBracketKeyword_2_3()));
	}
	
	@Override
	protected String getUnassignedRuleCallToken(EObject semanticObject, RuleCall ruleCall, INode node) {
		return "";
	}
	
	
	@Override
	protected void emitUnassignedTokens(EObject semanticObject, ISynTransition transition, INode fromNode, INode toNode) {
		if (transition.getAmbiguousSyntaxes().isEmpty()) return;
		List<INode> transitionNodes = collectNodes(fromNode, toNode);
		for (AbstractElementAlias syntax : transition.getAmbiguousSyntaxes()) {
			List<INode> syntaxNodes = getNodesFor(transitionNodes, syntax);
			if(match_ModelBridge_ChannelsKeyword_4_3_q.equals(syntax))
				emit_ModelBridge_ChannelsKeyword_4_3_q(semanticObject, getLastNavigableState(), syntaxNodes);
			else if(match_ModelBridge_ThingsKeyword_4_1_q.equals(syntax))
				emit_ModelBridge_ThingsKeyword_4_1_q(semanticObject, getLastNavigableState(), syntaxNodes);
			else if(match_ModelBridge___LeftCurlyBracketKeyword_4_0_ThingsKeyword_4_1_q_ChannelsKeyword_4_3_q_RightCurlyBracketKeyword_4_5__q.equals(syntax))
				emit_ModelBridge___LeftCurlyBracketKeyword_4_0_ThingsKeyword_4_1_q_ChannelsKeyword_4_3_q_RightCurlyBracketKeyword_4_5__q(semanticObject, getLastNavigableState(), syntaxNodes);
			else if(match_ModelBridge___LeftSquareBracketKeyword_3_0_RightSquareBracketKeyword_3_3__q.equals(syntax))
				emit_ModelBridge___LeftSquareBracketKeyword_3_0_RightSquareBracketKeyword_3_3__q(semanticObject, getLastNavigableState(), syntaxNodes);
			else if(match_ModelThing_ChannelsKeyword_3_1_q.equals(syntax))
				emit_ModelThing_ChannelsKeyword_3_1_q(semanticObject, getLastNavigableState(), syntaxNodes);
			else if(match_ModelThing_ThingKeyword_0_q.equals(syntax))
				emit_ModelThing_ThingKeyword_0_q(semanticObject, getLastNavigableState(), syntaxNodes);
			else if(match_ModelThing___LeftCurlyBracketKeyword_3_0_ChannelsKeyword_3_1_q_RightCurlyBracketKeyword_3_3__q.equals(syntax))
				emit_ModelThing___LeftCurlyBracketKeyword_3_0_ChannelsKeyword_3_1_q_RightCurlyBracketKeyword_3_3__q(semanticObject, getLastNavigableState(), syntaxNodes);
			else if(match_ModelThing___LeftSquareBracketKeyword_2_0_RightSquareBracketKeyword_2_3__q.equals(syntax))
				emit_ModelThing___LeftSquareBracketKeyword_2_0_RightSquareBracketKeyword_2_3__q(semanticObject, getLastNavigableState(), syntaxNodes);
			else acceptNodes(getLastNavigableState(), syntaxNodes);
		}
	}

	/**
	 * Syntax:
	 *     'Channels:'?
	 */
	protected void emit_ModelBridge_ChannelsKeyword_4_3_q(EObject semanticObject, ISynNavigable transition, List<INode> nodes) {
		acceptNodes(transition, nodes);
	}
	
	/**
	 * Syntax:
	 *     'Things:'?
	 */
	protected void emit_ModelBridge_ThingsKeyword_4_1_q(EObject semanticObject, ISynNavigable transition, List<INode> nodes) {
		acceptNodes(transition, nodes);
	}
	
	/**
	 * Syntax:
	 *     ('{' 'Things:'? 'Channels:'? '}')?
	 */
	protected void emit_ModelBridge___LeftCurlyBracketKeyword_4_0_ThingsKeyword_4_1_q_ChannelsKeyword_4_3_q_RightCurlyBracketKeyword_4_5__q(EObject semanticObject, ISynNavigable transition, List<INode> nodes) {
		acceptNodes(transition, nodes);
	}
	
	/**
	 * Syntax:
	 *     ('[' ']')?
	 */
	protected void emit_ModelBridge___LeftSquareBracketKeyword_3_0_RightSquareBracketKeyword_3_3__q(EObject semanticObject, ISynNavigable transition, List<INode> nodes) {
		acceptNodes(transition, nodes);
	}
	
	/**
	 * Syntax:
	 *     'Channels:'?
	 */
	protected void emit_ModelThing_ChannelsKeyword_3_1_q(EObject semanticObject, ISynNavigable transition, List<INode> nodes) {
		acceptNodes(transition, nodes);
	}
	
	/**
	 * Syntax:
	 *     'Thing'?
	 */
	protected void emit_ModelThing_ThingKeyword_0_q(EObject semanticObject, ISynNavigable transition, List<INode> nodes) {
		acceptNodes(transition, nodes);
	}
	
	/**
	 * Syntax:
	 *     ('{' 'Channels:'? '}')?
	 */
	protected void emit_ModelThing___LeftCurlyBracketKeyword_3_0_ChannelsKeyword_3_1_q_RightCurlyBracketKeyword_3_3__q(EObject semanticObject, ISynNavigable transition, List<INode> nodes) {
		acceptNodes(transition, nodes);
	}
	
	/**
	 * Syntax:
	 *     ('[' ']')?
	 */
	protected void emit_ModelThing___LeftSquareBracketKeyword_2_0_RightSquareBracketKeyword_2_3__q(EObject semanticObject, ISynNavigable transition, List<INode> nodes) {
		acceptNodes(transition, nodes);
	}
	
}
