package org.eclipse.smarthome.model.thing.serializer;

import com.google.inject.Inject;
import com.google.inject.Provider;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.smarthome.model.thing.services.ThingGrammarAccess;
import org.eclipse.smarthome.model.thing.thing.ModelBridge;
import org.eclipse.smarthome.model.thing.thing.ModelChannel;
import org.eclipse.smarthome.model.thing.thing.ModelProperty;
import org.eclipse.smarthome.model.thing.thing.ModelThing;
import org.eclipse.smarthome.model.thing.thing.ThingModel;
import org.eclipse.smarthome.model.thing.thing.ThingPackage;
import org.eclipse.xtext.serializer.acceptor.ISemanticSequenceAcceptor;
import org.eclipse.xtext.serializer.acceptor.SequenceFeeder;
import org.eclipse.xtext.serializer.diagnostic.ISemanticSequencerDiagnosticProvider;
import org.eclipse.xtext.serializer.diagnostic.ISerializationDiagnostic.Acceptor;
import org.eclipse.xtext.serializer.sequencer.AbstractDelegatingSemanticSequencer;
import org.eclipse.xtext.serializer.sequencer.GenericSequencer;
import org.eclipse.xtext.serializer.sequencer.ISemanticNodeProvider.INodesForEObjectProvider;
import org.eclipse.xtext.serializer.sequencer.ISemanticSequencer;
import org.eclipse.xtext.serializer.sequencer.ITransientValueService;
import org.eclipse.xtext.serializer.sequencer.ITransientValueService.ValueTransient;

@SuppressWarnings("all")
public class ThingSemanticSequencer extends AbstractDelegatingSemanticSequencer {

	@Inject
	private ThingGrammarAccess grammarAccess;
	
	public void createSequence(EObject context, EObject semanticObject) {
		if(semanticObject.eClass().getEPackage() == ThingPackage.eINSTANCE) switch(semanticObject.eClass().getClassifierID()) {
			case ThingPackage.MODEL_BRIDGE:
				if(context == grammarAccess.getModelBridgeRule() ||
				   context == grammarAccess.getModelPropertyContainerRule()) {
					sequence_ModelBridge(context, (ModelBridge) semanticObject); 
					return; 
				}
				else break;
			case ThingPackage.MODEL_CHANNEL:
				if(context == grammarAccess.getModelChannelRule() ||
				   context == grammarAccess.getModelPropertyContainerRule()) {
					sequence_ModelChannel(context, (ModelChannel) semanticObject); 
					return; 
				}
				else break;
			case ThingPackage.MODEL_PROPERTY:
				if(context == grammarAccess.getModelPropertyRule()) {
					sequence_ModelProperty(context, (ModelProperty) semanticObject); 
					return; 
				}
				else break;
			case ThingPackage.MODEL_THING:
				if(context == grammarAccess.getModelPropertyContainerRule() ||
				   context == grammarAccess.getModelThingRule()) {
					sequence_ModelThing(context, (ModelThing) semanticObject); 
					return; 
				}
				else break;
			case ThingPackage.THING_MODEL:
				if(context == grammarAccess.getThingModelRule()) {
					sequence_ThingModel(context, (ThingModel) semanticObject); 
					return; 
				}
				else break;
			}
		if (errorAcceptor != null) errorAcceptor.accept(diagnosticProvider.createInvalidContextOrTypeDiagnostic(semanticObject, context));
	}
	
	/**
	 * Constraint:
	 *     (
	 *         bridge?='Bridge' 
	 *         (id=UID | (thingTypeId=ID thingId=ID)) 
	 *         (properties+=ModelProperty? properties+=ModelProperty*)? 
	 *         ((things+=ModelThing | things+=ModelBridge)* channels+=ModelChannel*)?
	 *     )
	 */
	protected void sequence_ModelBridge(EObject context, ModelBridge semanticObject) {
		genericSequencer.createSequence(context, semanticObject);
	}
	
	
	/**
	 * Constraint:
	 *     (type=ModelItemType id=ID (properties+=ModelProperty properties+=ModelProperty*)?)
	 */
	protected void sequence_ModelChannel(EObject context, ModelChannel semanticObject) {
		genericSequencer.createSequence(context, semanticObject);
	}
	
	
	/**
	 * Constraint:
	 *     (key=ID value=ValueType)
	 */
	protected void sequence_ModelProperty(EObject context, ModelProperty semanticObject) {
		if(errorAcceptor != null) {
			if(transientValues.isValueTransient(semanticObject, ThingPackage.Literals.MODEL_PROPERTY__KEY) == ValueTransient.YES)
				errorAcceptor.accept(diagnosticProvider.createFeatureValueMissing(semanticObject, ThingPackage.Literals.MODEL_PROPERTY__KEY));
			if(transientValues.isValueTransient(semanticObject, ThingPackage.Literals.MODEL_PROPERTY__VALUE) == ValueTransient.YES)
				errorAcceptor.accept(diagnosticProvider.createFeatureValueMissing(semanticObject, ThingPackage.Literals.MODEL_PROPERTY__VALUE));
		}
		INodesForEObjectProvider nodes = createNodeProvider(semanticObject);
		SequenceFeeder feeder = createSequencerFeeder(semanticObject, nodes);
		feeder.accept(grammarAccess.getModelPropertyAccess().getKeyIDTerminalRuleCall_0_0(), semanticObject.getKey());
		feeder.accept(grammarAccess.getModelPropertyAccess().getValueValueTypeParserRuleCall_2_0(), semanticObject.getValue());
		feeder.finish();
	}
	
	
	/**
	 * Constraint:
	 *     ((id=UID | (thingTypeId=ID thingId=ID)) (properties+=ModelProperty? properties+=ModelProperty*)? channels+=ModelChannel*)
	 */
	protected void sequence_ModelThing(EObject context, ModelThing semanticObject) {
		genericSequencer.createSequence(context, semanticObject);
	}
	
	
	/**
	 * Constraint:
	 *     (things+=ModelThing | things+=ModelBridge)*
	 */
	protected void sequence_ThingModel(EObject context, ThingModel semanticObject) {
		genericSequencer.createSequence(context, semanticObject);
	}
}
