/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.core.scriptengine.internal.extensions;

import com.google.common.base.Joiner;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang.ArrayUtils;
import org.eclipse.smarthome.core.scriptengine.Script;
import org.eclipse.smarthome.core.scriptengine.ScriptEngine;
import org.eclipse.smarthome.core.scriptengine.ScriptExecutionException;
import org.eclipse.smarthome.core.scriptengine.ScriptParsingException;
import org.eclipse.smarthome.io.console.Console;
import org.eclipse.smarthome.io.console.extensions.ConsoleCommandExtension;

public class ScriptEngineConsoleCommandExtension
implements ConsoleCommandExtension {
    private ScriptEngine scriptEngine;

    public boolean canHandle(String[] args) {
        String firstArg = args[0];
        return ">".equals(firstArg);
    }

    public void execute(String[] args, Console console) {
        block6: {
            args = (String[])ArrayUtils.remove((Object[])args, (int)0);
            if (this.scriptEngine != null) {
                String scriptString = Joiner.on((String)" ").join((Object[])args);
                try {
                    Script script = this.scriptEngine.newScriptFromString(scriptString);
                    Object result = script.execute();
                    if (result != null) {
                        console.println(result.toString());
                        break block6;
                    }
                    console.println("OK");
                }
                catch (ScriptParsingException e) {
                    console.println(e.getMessage());
                }
                catch (ScriptExecutionException e) {
                    console.println(e.getMessage());
                }
            } else {
                console.println("Script engine is not available.");
            }
        }
    }

    public List<String> getUsages() {
        return Collections.singletonList("> <script to execute> - Executes a script");
    }

    public void setScriptEngine(ScriptEngine scriptEngine) {
        this.scriptEngine = scriptEngine;
    }

    public void unsetScriptEngine(ScriptEngine scriptEngine) {
        this.scriptEngine = null;
    }
}

