/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.test;

import groovy.lang.Closure;
import java.util.ArrayList;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.function.Predicate;
import org.eclipse.smarthome.core.i18n.LocaleProvider;
import org.eclipse.smarthome.test.internal.java.MissingServiceAnalyzer;
import org.eclipse.smarthome.test.storage.VolatileStorageService;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.cm.Configuration;
import org.osgi.service.cm.ConfigurationAdmin;

@Deprecated
public abstract class OSGiTest {
    private final Map<String, List<ServiceRegistration<?>>> registeredServices = new HashMap();
    protected BundleContext bundleContext;
    protected static final int TIMEOUT = 10000;
    protected static final int SLEEPTIME = 50;

    @Before
    public void bindBundleContext() {
        this.bundleContext = this.getBundleContext();
        Assert.assertThat((Object)this.bundleContext, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
    }

    protected BundleContext getBundleContext() {
        Bundle bundle = FrameworkUtil.getBundle(this.getClass());
        if (bundle != null) {
            return bundle.getBundleContext();
        }
        return null;
    }

    private <T> T unrefService(ServiceReference<T> serviceReference) {
        if (serviceReference == null) {
            return null;
        }
        return (T)this.bundleContext.getService(serviceReference);
    }

    protected <T> T getService(Class<T> clazz) {
        ServiceReference serviceReference = this.bundleContext.getServiceReference(clazz.getName());
        if (serviceReference == null) {
            new MissingServiceAnalyzer(System.out, this.bundleContext).printMissingServiceDetails(clazz);
            return null;
        }
        return this.unrefService(serviceReference);
    }

    protected <T> T getService(Class<T> clazz, Predicate<ServiceReference<T>> filter) {
        ServiceReference<T>[] serviceReferences = this.getServices(clazz);
        if (serviceReferences == null) {
            return null;
        }
        ArrayList<T> filteredServiceReferences = new ArrayList<T>(serviceReferences.length);
        ServiceReference<T>[] serviceReferenceArray = serviceReferences;
        int n = serviceReferences.length;
        int n2 = 0;
        while (n2 < n) {
            ServiceReference<T> serviceReference = serviceReferenceArray[n2];
            if (filter.test(serviceReference)) {
                filteredServiceReferences.add(this.unrefService(serviceReference));
            }
            ++n2;
        }
        if (filteredServiceReferences.size() > 1) {
            Assert.fail((String)"More than 1 service matching the filter is registered.");
        }
        if (filteredServiceReferences.isEmpty()) {
            return null;
        }
        return (T)filteredServiceReferences.get(0);
    }

    private <T> ServiceReference<T>[] getServices(Class<T> clazz) {
        try {
            ServiceReference[] serviceReferences = this.bundleContext.getServiceReferences(clazz.getName(), null);
            return serviceReferences;
        }
        catch (InvalidSyntaxException invalidSyntaxException) {
            throw new IllegalArgumentException("Invalid exception for a null filter");
        }
    }

    protected <T, I extends T> I getService(Class<T> clazz, Class<I> implementationClass) {
        T service = this.getService(clazz, (ServiceReference<T> srvRef) -> implementationClass.isInstance(this.unrefService((ServiceReference)srvRef)));
        return (I)service;
    }

    protected ServiceRegistration<?> registerService(Object service) {
        return this.registerService(service, this.getInterfaceName(service), null);
    }

    protected ServiceRegistration<?> registerService(Object service, Dictionary<String, ?> properties) {
        return this.registerService(service, this.getInterfaceName(service), properties);
    }

    protected ServiceRegistration<?> registerService(Object service, String interfaceName) {
        return this.registerService(service, interfaceName, null);
    }

    protected ServiceRegistration<?> registerService(Object service, String interfaceName, Dictionary<String, ?> properties) {
        Assert.assertThat((Object)interfaceName, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        ServiceRegistration srvReg = this.bundleContext.registerService(interfaceName, service, properties);
        this.saveServiceRegistration(interfaceName, srvReg);
        return srvReg;
    }

    private void saveServiceRegistration(String interfaceName, ServiceRegistration<?> srvReg) {
        List<ServiceRegistration<?>> regs = this.registeredServices.get(interfaceName);
        if (regs == null) {
            regs = new ArrayList();
            this.registeredServices.put(interfaceName, regs);
        }
        regs.add(srvReg);
    }

    protected ServiceRegistration<?> registerService(Object service, String[] interfaceNames, Dictionary<String, ?> properties) {
        Assert.assertThat((Object)interfaceNames, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        ServiceRegistration srvReg = this.bundleContext.registerService(interfaceNames, service, properties);
        String[] stringArray = interfaceNames;
        int n = interfaceNames.length;
        int n2 = 0;
        while (n2 < n) {
            String interfaceName = stringArray[n2];
            this.saveServiceRegistration(interfaceName, srvReg);
            ++n2;
        }
        return srvReg;
    }

    protected ServiceRegistration<?> unregisterService(Object service) {
        return this.unregisterService(this.getInterfaceName(service));
    }

    protected ServiceRegistration<?> unregisterService(String interfaceName) {
        ServiceRegistration<?> reg = null;
        List<ServiceRegistration<?>> regList = this.registeredServices.remove(interfaceName);
        if (regList != null) {
            reg = regList.get(0);
            regList.forEach(r -> r.unregister());
        }
        return reg;
    }

    protected String getInterfaceName(Object service) {
        Class<?>[] classes = service.getClass().getInterfaces();
        if (classes.length >= 1) {
            return classes[0].getName();
        }
        return null;
    }

    protected void registerVolatileStorageService() {
        this.registerService(new VolatileStorageService());
    }

    @After
    public void unregisterMocks() {
        this.registeredServices.forEach((interfaceName, services) -> services.forEach(service -> service.unregister()));
        this.registeredServices.clear();
    }

    protected void waitFor(Closure<?> condition, int timeout, int sleepTime) throws Exception {
        int waitingTime = 0;
        while (condition != null && !Boolean.TRUE.equals(condition.call()) && waitingTime < timeout) {
            waitingTime += sleepTime;
            Thread.sleep(sleepTime);
        }
    }

    protected void waitFor(Closure<?> condition, int timeout) throws Exception {
        this.waitFor(condition, timeout, 50);
    }

    protected void waitFor(Closure<?> condition) throws Exception {
        this.waitFor(condition, 10000);
    }

    protected void waitForAssert(Closure<?> assertion, int timeout, int sleepTime) throws Exception {
        this.waitForAssert(assertion, null, timeout, sleepTime);
    }

    protected void waitForAssert(Closure<?> assertion, Closure<?> beforeLastCall, long timeout, int sleepTime) throws Exception {
        long timeoutNs = TimeUnit.MILLISECONDS.toNanos(timeout);
        long startingTime = System.nanoTime();
        while (System.nanoTime() - startingTime < timeoutNs) {
            try {
                assertion.call();
                return;
            }
            catch (Error | NullPointerException throwable) {
                Thread.sleep(sleepTime);
            }
        }
        if (beforeLastCall != null) {
            beforeLastCall.call();
        }
        assertion.call();
    }

    protected void waitForAssert(Closure<?> assertion, Closure<?> beforeLastCall) throws Exception {
        this.waitForAssert(assertion, beforeLastCall, 10000L, 50);
    }

    protected void waitForAssert(Closure<?> assertion, Closure<?> beforeLastCall, long timeout) throws Exception {
        this.waitForAssert(assertion, beforeLastCall, timeout, 50);
    }

    protected void waitForAssert(Closure<?> assertion, int timeout) throws Exception {
        this.waitForAssert(assertion, timeout, 50);
    }

    protected void waitForAssert(Closure<?> assertion) throws Exception {
        this.waitForAssert(assertion, 10000);
    }

    protected void setDefaultLocale(final Locale locale) throws Exception {
        Assert.assertThat((Object)locale, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        ConfigurationAdmin configAdmin = (ConfigurationAdmin)this.getService(Class.forName("org.osgi.service.cm.ConfigurationAdmin"));
        Assert.assertThat((Object)configAdmin, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        final LocaleProvider localeProvider = (LocaleProvider)this.getService(Class.forName("org.eclipse.smarthome.core.i18n.LocaleProvider"));
        Assert.assertThat((Object)localeProvider, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        Configuration config = configAdmin.getConfiguration("org.eclipse.smarthome.core.i18nprovider", null);
        Assert.assertThat((Object)config, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        Hashtable<String, String> properties = config.getProperties();
        if (properties == null) {
            properties = new Hashtable<String, String>();
        }
        ((Dictionary)properties).put("language", locale.getLanguage());
        ((Dictionary)properties).put("script", locale.getScript());
        ((Dictionary)properties).put("region", locale.getCountry());
        ((Dictionary)properties).put("variant", locale.getVariant());
        config.update(properties);
        this.waitForAssert(new Closure<Object>(null){
            private static final long serialVersionUID = -5083904877474902686L;

            public Object doCall() {
                Assert.assertThat((Object)localeProvider.getLocale(), (Matcher)CoreMatchers.is((Object)locale));
                return null;
            }
        });
    }
}

