/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.model.core.internal.folder;

import java.io.File;
import java.io.FileInputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.StandardWatchEventKinds;
import java.nio.file.WatchEvent;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;
import org.eclipse.smarthome.config.core.ConfigConstants;
import org.eclipse.smarthome.core.service.AbstractWatchService;
import org.eclipse.smarthome.model.core.ModelParser;
import org.eclipse.smarthome.model.core.ModelRepository;
import org.osgi.service.component.ComponentContext;

public class FolderObserver
extends AbstractWatchService {
    private ModelRepository modelRepo = null;
    private final Map<String, String[]> folderFileExtMap = new ConcurrentHashMap<String, String[]>();
    private final Set<String> parsers = new HashSet<String>();
    private final Set<File> ignoredFiles = new HashSet<File>();
    private final Map<String, File> nameFileMap = new HashMap<String, File>();

    public FolderObserver() {
        super(ConfigConstants.getConfigFolder());
    }

    public void setModelRepository(ModelRepository modelRepo) {
        this.modelRepo = modelRepo;
    }

    public void unsetModelRepository(ModelRepository modelRepo) {
        this.modelRepo = null;
    }

    protected void addModelParser(ModelParser modelParser) {
        this.parsers.add(modelParser.getExtension());
        this.processIgnoredFiles(modelParser.getExtension());
    }

    protected void removeModelParser(ModelParser modelParser) {
        this.parsers.remove(modelParser.getExtension());
        Set<String> removed = this.modelRepo.removeAllModelsOfType(modelParser.getExtension());
        this.ignoredFiles.addAll(removed.stream().map(name -> this.nameFileMap.get(name)).collect(Collectors.toSet()));
    }

    public void activate(ComponentContext ctx) {
        Dictionary config = ctx.getProperties();
        Enumeration keys = config.keys();
        while (keys.hasMoreElements()) {
            String foldername = (String)keys.nextElement();
            if (!StringUtils.isAlphanumeric((String)foldername)) continue;
            String[] fileExts = ((String)config.get(foldername)).split(",");
            File folder = this.getFile(foldername);
            if (folder.exists() && folder.isDirectory()) {
                this.folderFileExtMap.put(foldername, fileExts);
                continue;
            }
            this.logger.warn("Directory '{}' does not exist in '{}'. Please check your configuration settings!", (Object)foldername, (Object)ConfigConstants.getConfigFolder());
        }
        this.addModelsToRepo();
        super.activate();
    }

    public void deactivate() {
        super.deactivate();
        this.deleteModelsFromRepo();
        this.ignoredFiles.clear();
        this.folderFileExtMap.clear();
        this.parsers.clear();
        this.nameFileMap.clear();
    }

    private void processIgnoredFiles(String extension) {
        HashSet<File> clonedSet = new HashSet<File>(this.ignoredFiles);
        for (File file : clonedSet) {
            if (!extension.equals(this.getExtension(file.getPath()))) continue;
            this.checkFile(this.modelRepo, file, StandardWatchEventKinds.ENTRY_CREATE);
            this.ignoredFiles.remove(file);
        }
    }

    protected boolean watchSubDirectories() {
        return true;
    }

    protected WatchEvent.Kind<?>[] getWatchEventKinds(Path directory) {
        String folderName;
        if (directory != null && MapUtils.isNotEmpty(this.folderFileExtMap) && this.folderFileExtMap.containsKey(folderName = directory.getFileName().toString())) {
            return new WatchEvent.Kind[]{StandardWatchEventKinds.ENTRY_CREATE, StandardWatchEventKinds.ENTRY_DELETE, StandardWatchEventKinds.ENTRY_MODIFY};
        }
        return null;
    }

    private void addModelsToRepo() {
        if (MapUtils.isNotEmpty(this.folderFileExtMap)) {
            for (String folderName : this.folderFileExtMap.keySet()) {
                File folder;
                File[] files;
                String[] validExtension = this.folderFileExtMap.get(folderName);
                if (validExtension == null || validExtension.length <= 0 || (files = (folder = this.getFile(folderName)).listFiles(new FileExtensionsFilter(validExtension))) == null || files.length <= 0) continue;
                File[] fileArray = files;
                int n = files.length;
                int n2 = 0;
                while (n2 < n) {
                    File file = fileArray[n2];
                    if (!file.isHidden()) {
                        this.checkFile(this.modelRepo, file, StandardWatchEventKinds.ENTRY_CREATE);
                    }
                    ++n2;
                }
            }
        }
    }

    private void deleteModelsFromRepo() {
        Set<String> folders = this.folderFileExtMap.keySet();
        for (String folder : folders) {
            Iterable<String> models = this.modelRepo.getAllModelNamesOfType(folder);
            if (models == null) continue;
            for (String model : models) {
                this.logger.debug("Removing file {} from the model repo.", (Object)model);
                this.modelRepo.removeModel(model);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkFile(ModelRepository modelRepo, File file, WatchEvent.Kind kind) {
        if (modelRepo != null && file != null) {
            try {
                Class<FolderObserver> clazz = FolderObserver.class;
                synchronized (FolderObserver.class) {
                    if (kind == StandardWatchEventKinds.ENTRY_CREATE || kind == StandardWatchEventKinds.ENTRY_MODIFY) {
                        if (this.parsers.contains(this.getExtension(file.getName()))) {
                            try {
                                Throwable throwable = null;
                                Object var6_8 = null;
                                try (FileInputStream inputStream = FileUtils.openInputStream((File)file);){
                                    this.nameFileMap.put(file.getName(), file);
                                    modelRepo.addOrRefreshModel(file.getName(), inputStream);
                                }
                                catch (Throwable throwable2) {
                                    if (throwable == null) {
                                        throwable = throwable2;
                                    } else if (throwable != throwable2) {
                                        throwable.addSuppressed(throwable2);
                                    }
                                    throw throwable;
                                }
                            }
                            catch (IOException iOException) {
                                this.logger.warn("Error while opening file during update: {}", (Object)file.getAbsolutePath());
                            }
                        } else {
                            this.ignoredFiles.add(file);
                        }
                    } else if (kind == StandardWatchEventKinds.ENTRY_DELETE) {
                        modelRepo.removeModel(file.getName());
                        this.nameFileMap.remove(file.getName());
                    }
                    // ** MonitorExit[var4_4] (shouldn't be in output)
                }
            }
            catch (Exception e) {
                this.logger.error("Error handling update of file '{}': {}.", new Object[]{file.getAbsolutePath(), e.getMessage(), e});
            }
        }
        {
            return;
        }
    }

    private File getFileByFileExtMap(Map<String, String[]> folderFileExtMap, String filename) {
        String extension;
        if (StringUtils.isNotBlank((String)filename) && MapUtils.isNotEmpty(folderFileExtMap) && StringUtils.isNotBlank((String)(extension = this.getExtension(filename)))) {
            Set<Map.Entry<String, String[]>> entries = folderFileExtMap.entrySet();
            for (Map.Entry<String, String[]> entry : entries) {
                if (!ArrayUtils.contains((Object[])entry.getValue(), (Object)extension)) continue;
                return new File(this.getFile(entry.getKey()) + File.separator + filename);
            }
        }
        return null;
    }

    private File getFile(String filename) {
        return new File(String.valueOf(ConfigConstants.getConfigFolder()) + File.separator + filename);
    }

    public String getExtension(String filename) {
        return filename.substring(filename.lastIndexOf(".") + 1);
    }

    protected void processWatchEvent(WatchEvent<?> event, WatchEvent.Kind<?> kind, Path path) {
        File toCheck = this.getFileByFileExtMap(this.folderFileExtMap, path.getFileName().toString());
        if (toCheck != null && !toCheck.isHidden()) {
            this.checkFile(this.modelRepo, toCheck, kind);
        }
    }

    protected class FileExtensionsFilter
    implements FilenameFilter {
        private final String[] validExtensions;

        public FileExtensionsFilter(String[] validExtensions) {
            this.validExtensions = validExtensions;
        }

        @Override
        public boolean accept(File dir, String name) {
            if (this.validExtensions != null && this.validExtensions.length > 0) {
                String[] stringArray = this.validExtensions;
                int n = this.validExtensions.length;
                int n2 = 0;
                while (n2 < n) {
                    String extension = stringArray[n2];
                    if (name.toLowerCase().endsWith("." + extension)) {
                        return true;
                    }
                    ++n2;
                }
            }
            return false;
        }
    }
}

