/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.io.http.servlet;

import java.util.Hashtable;
import javax.servlet.Servlet;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import org.osgi.service.http.HttpContext;
import org.osgi.service.http.HttpService;
import org.osgi.service.http.NamespaceException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseSmartHomeServlet
extends HttpServlet {
    private static final long serialVersionUID = 6020752826735599455L;
    protected final Logger logger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    protected HttpService httpService;

    protected void setHttpService(HttpService httpService) {
        this.httpService = httpService;
    }

    protected void unsetHttpService(HttpService httpService) {
        this.httpService = null;
    }

    protected void activate(String alias, HttpContext httpContext) {
        try {
            this.logger.debug("Starting up {} at {}", (Object)((Object)((Object)this)).getClass().getSimpleName(), (Object)alias);
            Hashtable props = new Hashtable();
            this.httpService.registerServlet(alias, (Servlet)this, props, httpContext);
        }
        catch (NamespaceException e) {
            this.logger.error("Error during servlet registration - alias {} already in use", (Object)alias, (Object)e);
        }
        catch (ServletException e) {
            this.logger.error("Error during servlet registration", (Throwable)e);
        }
    }

    protected void deactivate(String alias) {
        this.httpService.unregister(alias);
    }
}

