/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.core.thing.type;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.CopyOnWriteArrayList;
import org.eclipse.smarthome.core.thing.Channel;
import org.eclipse.smarthome.core.thing.ThingTypeUID;
import org.eclipse.smarthome.core.thing.binding.ThingTypeProvider;
import org.eclipse.smarthome.core.thing.type.ChannelType;
import org.eclipse.smarthome.core.thing.type.ChannelTypeRegistry;
import org.eclipse.smarthome.core.thing.type.ChannelTypeUID;
import org.eclipse.smarthome.core.thing.type.ThingType;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;

@Component(immediate=true, service={ThingTypeRegistry.class})
public class ThingTypeRegistry {
    private final List<ThingTypeProvider> thingTypeProviders = new CopyOnWriteArrayList<ThingTypeProvider>();
    private ChannelTypeRegistry channelTypeRegistry;

    public List<ThingType> getThingTypes(Locale locale) {
        ArrayList<ThingType> thingTypes = new ArrayList<ThingType>();
        for (ThingTypeProvider thingTypeProvider : this.thingTypeProviders) {
            thingTypes.addAll(thingTypeProvider.getThingTypes(locale));
        }
        return Collections.unmodifiableList(thingTypes);
    }

    public List<ThingType> getThingTypes() {
        return this.getThingTypes((Locale)null);
    }

    public List<ThingType> getThingTypes(String bindingId, Locale locale) {
        ArrayList<ThingType> thingTypesForBinding = new ArrayList<ThingType>();
        for (ThingType thingType : this.getThingTypes()) {
            if (!thingType.getBindingId().equals(bindingId)) continue;
            thingTypesForBinding.add(thingType);
        }
        return Collections.unmodifiableList(thingTypesForBinding);
    }

    public List<ThingType> getThingTypes(String bindingId) {
        return this.getThingTypes(bindingId, null);
    }

    public ThingType getThingType(ThingTypeUID thingTypeUID, Locale locale) {
        for (ThingTypeProvider thingTypeProvider : this.thingTypeProviders) {
            ThingType thingType = thingTypeProvider.getThingType(thingTypeUID, locale);
            if (thingType == null) continue;
            return thingType;
        }
        return null;
    }

    public ThingType getThingType(ThingTypeUID thingTypeUID) {
        return this.getThingType(thingTypeUID, null);
    }

    public ChannelType getChannelType(Channel channel) {
        return this.getChannelType(channel, null);
    }

    public ChannelType getChannelType(Channel channel, Locale locale) {
        ChannelTypeUID channelTypeUID = channel.getChannelTypeUID();
        if (channelTypeUID != null) {
            return this.channelTypeRegistry.getChannelType(channelTypeUID, locale);
        }
        return null;
    }

    @Reference(cardinality=ReferenceCardinality.MULTIPLE, policy=ReferencePolicy.DYNAMIC)
    protected void addThingTypeProvider(ThingTypeProvider thingTypeProvider) {
        if (thingTypeProvider != null) {
            this.thingTypeProviders.add(thingTypeProvider);
        }
    }

    protected void removeThingTypeProvider(ThingTypeProvider thingTypeProvider) {
        if (thingTypeProvider != null) {
            this.thingTypeProviders.remove(thingTypeProvider);
        }
    }

    @Reference
    protected void setChannelTypeRegistry(ChannelTypeRegistry channelTypeRegistry) {
        this.channelTypeRegistry = channelTypeRegistry;
    }

    protected void unsetChannelTypeRegistry(ChannelTypeRegistry channelTypeRegistry) {
        this.channelTypeRegistry = null;
    }
}

