/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.core.thing.internal.type;

import java.net.URI;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.smarthome.core.thing.type.ChannelType;
import org.eclipse.smarthome.core.thing.type.ChannelTypeBuilder;
import org.eclipse.smarthome.core.thing.type.ChannelTypeUID;

@NonNullByDefault
abstract class AbstractChannelTypeBuilder<T extends ChannelTypeBuilder<T>>
implements ChannelTypeBuilder<T> {
    protected final ChannelTypeUID channelTypeUID;
    protected final String label;
    protected boolean advanced;
    protected @Nullable String description;
    protected @Nullable String category;
    protected final Set<String> tags = new HashSet<String>();
    protected @Nullable URI configDescriptionURI;

    public AbstractChannelTypeBuilder(ChannelTypeUID channelTypeUID, String label) {
        if (channelTypeUID == null) {
            throw new IllegalArgumentException("ChannelTypeUID must be set.");
        }
        if (StringUtils.isEmpty((String)label)) {
            throw new IllegalArgumentException("Label for a ChannelType must not be empty.");
        }
        this.channelTypeUID = channelTypeUID;
        this.label = label;
    }

    @Override
    public T isAdvanced(boolean advanced) {
        this.advanced = advanced;
        return (T)this;
    }

    @Override
    public T withDescription(String description) {
        this.description = description;
        return (T)this;
    }

    @Override
    public T withCategory(String category) {
        this.category = category;
        return (T)this;
    }

    @Override
    public T withTag(String tag) {
        this.tags.add(tag);
        return (T)this;
    }

    @Override
    public T withTags(Collection<String> tags) {
        if (tags != null) {
            this.tags.addAll(tags);
        }
        return (T)this;
    }

    @Override
    public T withConfigDescriptionURI(URI configDescriptionURI) {
        this.configDescriptionURI = configDescriptionURI;
        return (T)this;
    }

    @Override
    public abstract ChannelType build();
}

