/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.core.thing.internal;

import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.smarthome.config.core.Configuration;
import org.eclipse.smarthome.core.common.registry.AbstractRegistry;
import org.eclipse.smarthome.core.common.registry.Identifiable;
import org.eclipse.smarthome.core.common.registry.ManagedProvider;
import org.eclipse.smarthome.core.events.Event;
import org.eclipse.smarthome.core.events.EventPublisher;
import org.eclipse.smarthome.core.thing.Bridge;
import org.eclipse.smarthome.core.thing.Channel;
import org.eclipse.smarthome.core.thing.ChannelUID;
import org.eclipse.smarthome.core.thing.ManagedThingProvider;
import org.eclipse.smarthome.core.thing.Thing;
import org.eclipse.smarthome.core.thing.ThingProvider;
import org.eclipse.smarthome.core.thing.ThingRegistry;
import org.eclipse.smarthome.core.thing.ThingTypeUID;
import org.eclipse.smarthome.core.thing.ThingUID;
import org.eclipse.smarthome.core.thing.binding.ThingHandler;
import org.eclipse.smarthome.core.thing.binding.ThingHandlerFactory;
import org.eclipse.smarthome.core.thing.events.ThingEventFactory;
import org.eclipse.smarthome.core.thing.internal.BridgeImpl;
import org.eclipse.smarthome.core.thing.internal.ThingTracker;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true)
public class ThingRegistryImpl
extends AbstractRegistry<Thing, ThingUID, ThingProvider>
implements ThingRegistry {
    private final Logger logger = LoggerFactory.getLogger((String)ThingRegistryImpl.class.getName());
    private final List<ThingTracker> thingTrackers = new CopyOnWriteArrayList<ThingTracker>();
    private final List<ThingHandlerFactory> thingHandlerFactories = new CopyOnWriteArrayList<ThingHandlerFactory>();

    public ThingRegistryImpl() {
        super(ThingProvider.class);
    }

    public void addThingTracker(ThingTracker thingTracker) {
        this.notifyTrackerAboutAllThingsAdded(thingTracker);
        this.thingTrackers.add(thingTracker);
    }

    @Override
    public Channel getChannel(ChannelUID channelUID) {
        ThingUID thingUID = channelUID.getThingUID();
        Thing thing = (Thing)this.get((Object)thingUID);
        if (thing != null) {
            return thing.getChannel(channelUID.getId());
        }
        return null;
    }

    @Override
    public void updateConfiguration(ThingUID thingUID, Map<@NonNull String, Object> configurationParameters) {
        ThingHandler thingHandler;
        Thing thing = (Thing)this.get((Object)thingUID);
        if (thing != null) {
            thingHandler = thing.getHandler();
            if (thingHandler == null) {
                throw new IllegalStateException("Thing with UID " + (Object)((Object)thingUID) + " has no handler attached.");
            }
        } else {
            throw new IllegalArgumentException("Thing with UID " + (Object)((Object)thingUID) + " does not exists.");
        }
        thingHandler.handleConfigurationUpdate(configurationParameters);
    }

    @Override
    public Thing forceRemove(ThingUID thingUID) {
        return (Thing)super.remove((Object)thingUID);
    }

    @Override
    public Thing remove(ThingUID thingUID) {
        Thing thing = (Thing)this.get((Object)thingUID);
        if (thing != null) {
            this.notifyTrackers(thing, ThingTracker.ThingTrackerEvent.THING_REMOVING);
        }
        return thing;
    }

    public void removeThingTracker(ThingTracker thingTracker) {
        this.notifyTrackerAboutAllThingsRemoved(thingTracker);
        this.thingTrackers.remove(thingTracker);
    }

    protected void notifyListenersAboutAddedElement(Thing element) {
        super.notifyListenersAboutAddedElement((Identifiable)element);
        this.postEvent((Event)ThingEventFactory.createAddedEvent(element));
        this.notifyTrackers(element, ThingTracker.ThingTrackerEvent.THING_ADDED);
    }

    protected void notifyListenersAboutRemovedElement(Thing element) {
        super.notifyListenersAboutRemovedElement((Identifiable)element);
        this.notifyTrackers(element, ThingTracker.ThingTrackerEvent.THING_REMOVED);
        this.postEvent((Event)ThingEventFactory.createRemovedEvent(element));
    }

    protected void notifyListenersAboutUpdatedElement(Thing oldElement, Thing element) {
        super.notifyListenersAboutUpdatedElement((Identifiable)oldElement, (Identifiable)element);
        this.notifyTrackers(element, ThingTracker.ThingTrackerEvent.THING_UPDATED);
        this.postEvent((Event)ThingEventFactory.createUpdateEvent(element, oldElement));
    }

    protected void onAddElement(Thing thing) throws IllegalArgumentException {
        this.addThingToBridge(thing);
        if (thing instanceof Bridge) {
            this.addThingsToBridge((Bridge)thing);
        }
    }

    protected void onRemoveElement(Thing thing) {
        Thing bridge;
        this.preserveDynamicState(thing);
        ThingUID bridgeUID = thing.getBridgeUID();
        if (bridgeUID != null && (bridge = (Thing)this.get((Object)bridgeUID)) instanceof BridgeImpl) {
            ((BridgeImpl)bridge).removeThing(thing);
        }
    }

    protected void onUpdateElement(Thing oldThing, Thing thing) {
        this.preserveDynamicState(thing);
        this.onRemoveElement(thing);
        this.onAddElement(thing);
    }

    private void preserveDynamicState(Thing thing) {
        Thing existingThing = (Thing)this.get((Object)thing.getUID());
        if (existingThing != null) {
            thing.setHandler(existingThing.getHandler());
            thing.setStatusInfo(existingThing.getStatusInfo());
        }
    }

    private void addThingsToBridge(Bridge bridge) {
        this.forEach(thing -> {
            ThingUID bridgeUID = thing.getBridgeUID();
            if (bridgeUID != null && bridgeUID.equals((Object)bridge.getUID()) && bridge instanceof BridgeImpl && !bridge.getThings().contains(thing)) {
                ((BridgeImpl)bridge).addThing((Thing)thing);
            }
        });
    }

    private void addThingToBridge(Thing thing) {
        Thing bridge;
        ThingUID bridgeUID = thing.getBridgeUID();
        if (bridgeUID != null && (bridge = (Thing)this.get((Object)bridgeUID)) instanceof BridgeImpl && !((Bridge)bridge).getThings().contains(thing)) {
            ((BridgeImpl)bridge).addThing(thing);
        }
    }

    private void notifyTrackers(Thing thing, ThingTracker.ThingTrackerEvent event) {
        for (ThingTracker thingTracker : this.thingTrackers) {
            try {
                switch (event) {
                    case THING_ADDED: {
                        thingTracker.thingAdded(thing, ThingTracker.ThingTrackerEvent.THING_ADDED);
                        break;
                    }
                    case THING_REMOVING: {
                        thingTracker.thingRemoving(thing, ThingTracker.ThingTrackerEvent.THING_REMOVING);
                        break;
                    }
                    case THING_REMOVED: {
                        thingTracker.thingRemoved(thing, ThingTracker.ThingTrackerEvent.THING_REMOVED);
                        break;
                    }
                    case THING_UPDATED: {
                        thingTracker.thingUpdated(thing, ThingTracker.ThingTrackerEvent.THING_UPDATED);
                        break;
                    }
                }
            }
            catch (Exception ex) {
                this.logger.error("Could not inform the ThingTracker '{}' about the '{}' event!", new Object[]{thingTracker, event.name(), ex});
            }
        }
    }

    private void notifyTrackerAboutAllThingsAdded(ThingTracker thingTracker) {
        for (Thing thing : this.getAll()) {
            thingTracker.thingAdded(thing, ThingTracker.ThingTrackerEvent.TRACKER_ADDED);
        }
    }

    private void notifyTrackerAboutAllThingsRemoved(ThingTracker thingTracker) {
        for (Thing thing : this.getAll()) {
            thingTracker.thingRemoved(thing, ThingTracker.ThingTrackerEvent.TRACKER_REMOVED);
        }
    }

    @Override
    public Thing createThingOfType(ThingTypeUID thingTypeUID, ThingUID thingUID, ThingUID bridgeUID, String label, Configuration configuration) {
        this.logger.debug("Creating thing for type '{}'.", (Object)thingTypeUID);
        for (ThingHandlerFactory thingHandlerFactory : this.thingHandlerFactories) {
            if (!thingHandlerFactory.supportsThingType(thingTypeUID)) continue;
            Thing thing = thingHandlerFactory.createThing(thingTypeUID, configuration, thingUID, bridgeUID);
            if (thing == null) {
                this.logger.warn("Cannot create thing of type '{}'. Binding '{}' says it supports it, but it could not be created.", (Object)thingTypeUID, (Object)thingHandlerFactory.getClass().getName());
                continue;
            }
            thing.setLabel(label);
            return thing;
        }
        this.logger.warn("Cannot create thing. No binding found that supports creating a thing of type '{}'.", (Object)thingTypeUID);
        return null;
    }

    @Reference(cardinality=ReferenceCardinality.MULTIPLE, policy=ReferencePolicy.DYNAMIC)
    protected void addThingHandlerFactory(ThingHandlerFactory thingHandlerFactory) {
        this.thingHandlerFactories.add(thingHandlerFactory);
    }

    protected void removeThingHandlerFactory(ThingHandlerFactory thingHandlerFactory) {
        this.thingHandlerFactories.remove(thingHandlerFactory);
    }

    @Reference(cardinality=ReferenceCardinality.OPTIONAL, policy=ReferencePolicy.DYNAMIC)
    protected void setEventPublisher(EventPublisher eventPublisher) {
        super.setEventPublisher(eventPublisher);
    }

    protected void unsetEventPublisher(EventPublisher eventPublisher) {
        super.unsetEventPublisher(eventPublisher);
    }

    @Reference(cardinality=ReferenceCardinality.OPTIONAL, policy=ReferencePolicy.DYNAMIC, name="ManagedThingProvider")
    protected void setManagedProvider(ManagedThingProvider provider) {
        super.setManagedProvider((ManagedProvider)provider);
    }

    protected void unsetManagedProvider(ManagedThingProvider managedProvider) {
        super.unsetManagedProvider((ManagedProvider)managedProvider);
    }
}

