/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.core.thing.internal;

import java.net.URI;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.smarthome.config.core.ConfigDescriptionAliasProvider;
import org.eclipse.smarthome.core.thing.Channel;
import org.eclipse.smarthome.core.thing.ChannelUID;
import org.eclipse.smarthome.core.thing.Thing;
import org.eclipse.smarthome.core.thing.ThingRegistry;
import org.eclipse.smarthome.core.thing.ThingUID;
import org.eclipse.smarthome.core.thing.type.ChannelType;
import org.eclipse.smarthome.core.thing.type.ChannelTypeRegistry;
import org.eclipse.smarthome.core.thing.type.ThingType;
import org.eclipse.smarthome.core.thing.type.ThingTypeRegistry;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component
@NonNullByDefault
public class ThingConfigDescriptionAliasProvider
implements ConfigDescriptionAliasProvider {
    @NonNullByDefault(value={})
    private ThingRegistry thingRegistry;
    @NonNullByDefault(value={})
    private ThingTypeRegistry thingTypeRegistry;
    @NonNullByDefault(value={})
    private ChannelTypeRegistry channelTypeRegistry;

    @Reference
    protected void setThingRegistry(ThingRegistry thingRegistry) {
        this.thingRegistry = thingRegistry;
    }

    protected void unsetThingRegistry(ThingRegistry thingRegistry) {
        this.thingRegistry = null;
    }

    @Reference
    protected void setThingTypeRegistry(ThingTypeRegistry thingTypeRegistry) {
        this.thingTypeRegistry = thingTypeRegistry;
    }

    protected void unsetThingTypeRegistry(ThingTypeRegistry thingTypeRegistry) {
        this.thingTypeRegistry = null;
    }

    @Reference
    protected void setChannelTypeRegistry(ChannelTypeRegistry channelTypeRegistry) {
        this.channelTypeRegistry = channelTypeRegistry;
    }

    protected void unsetChannelTypeRegistry(ChannelTypeRegistry channelTypeRegistry) {
        this.channelTypeRegistry = null;
    }

    public @Nullable URI getAlias(@NonNull URI uri) {
        if (uri.getScheme() == null) {
            return null;
        }
        switch (uri.getScheme()) {
            case "thing": {
                return this.getThingConfigDescriptionURI(uri);
            }
            case "channel": {
                return this.getChannelConfigDescriptionURI(uri);
            }
        }
        return null;
    }

    private @Nullable URI getThingConfigDescriptionURI(URI uri) {
        ThingUID thingUID = new ThingUID(uri.getSchemeSpecificPart());
        Thing thing = this.thingRegistry.get(thingUID);
        if (thing == null) {
            return null;
        }
        ThingType thingType = this.thingTypeRegistry.getThingType(thing.getThingTypeUID());
        if (thingType == null) {
            return null;
        }
        URI configURI = thingType.getConfigDescriptionURI();
        return configURI;
    }

    private @Nullable URI getChannelConfigDescriptionURI(URI uri) {
        ChannelUID channelUID;
        ThingUID thingUID;
        Thing thing;
        String stringUID = uri.getSchemeSpecificPart();
        if (uri.getFragment() != null) {
            stringUID = String.valueOf(stringUID) + "#" + uri.getFragment();
        }
        if ((thing = this.thingRegistry.get(thingUID = (channelUID = new ChannelUID(stringUID)).getThingUID())) == null) {
            return null;
        }
        Channel channel = thing.getChannel(channelUID.getId());
        if (channel == null) {
            return null;
        }
        ChannelType channelType = this.channelTypeRegistry.getChannelType(channel.getChannelTypeUID());
        if (channelType == null) {
            return null;
        }
        URI configURI = channelType.getConfigDescriptionURI();
        return configURI;
    }
}

