/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.core.thing.firmware;

import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.smarthome.core.events.AbstractEvent;
import org.eclipse.smarthome.core.thing.firmware.FirmwareUpdateResult;
import org.eclipse.smarthome.core.thing.firmware.FirmwareUpdateResultInfo;

@NonNullByDefault
public final class FirmwareUpdateResultInfoEvent
extends AbstractEvent {
    public static final String TYPE = FirmwareUpdateResultInfoEvent.class.getSimpleName();
    private final FirmwareUpdateResultInfo firmwareUpdateResultInfo;

    protected FirmwareUpdateResultInfoEvent(String topic, String payload, FirmwareUpdateResultInfo firmwareUpdateResultInfo) {
        super(topic, payload, null);
        this.firmwareUpdateResultInfo = firmwareUpdateResultInfo;
    }

    public FirmwareUpdateResultInfo getFirmwareUpdateResultInfo() {
        return this.firmwareUpdateResultInfo;
    }

    public String getType() {
        return TYPE;
    }

    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.firmwareUpdateResultInfo == null ? 0 : this.firmwareUpdateResultInfo.hashCode());
        return result;
    }

    public boolean equals(@Nullable Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        FirmwareUpdateResultInfoEvent other = (FirmwareUpdateResultInfoEvent)((Object)obj);
        return !(this.firmwareUpdateResultInfo == null ? other.firmwareUpdateResultInfo != null : !this.firmwareUpdateResultInfo.equals(other.firmwareUpdateResultInfo));
    }

    public String toString() {
        FirmwareUpdateResult result = this.firmwareUpdateResultInfo.getResult();
        StringBuilder sb = new StringBuilder(String.format("The result of the firmware update for thing %s is %s.", new Object[]{this.firmwareUpdateResultInfo.getThingUID(), result.name()}));
        if (result == FirmwareUpdateResult.ERROR) {
            sb.append(String.format(" The error message is %s.", this.firmwareUpdateResultInfo.getErrorMessage()));
        }
        return sb.toString();
    }
}

