/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.core.thing.firmware;

import java.util.Objects;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.smarthome.core.thing.ThingUID;
import org.eclipse.smarthome.core.thing.firmware.FirmwareUpdateResult;

@NonNullByDefault
public final class FirmwareUpdateResultInfo {
    private final FirmwareUpdateResult result;
    private @Nullable String errorMessage;
    private final ThingUID thingUID;

    private FirmwareUpdateResultInfo(ThingUID thingUID, FirmwareUpdateResult result, @Nullable String errorMessage) {
        Objects.requireNonNull(thingUID, "The thingUID must not be null.");
        this.thingUID = thingUID;
        Objects.requireNonNull(result, "Firmware update result must not be null");
        this.result = result;
        if (result != FirmwareUpdateResult.SUCCESS) {
            if (errorMessage == null || errorMessage.isEmpty()) {
                throw new IllegalArgumentException("Error message must not be null or empty for erroneous firmare updates");
            }
            this.errorMessage = errorMessage;
        }
    }

    public static FirmwareUpdateResultInfo createFirmwareUpdateResultInfo(ThingUID thingUID, FirmwareUpdateResult result, String errorMessage) {
        return new FirmwareUpdateResultInfo(thingUID, result, errorMessage);
    }

    public FirmwareUpdateResult getResult() {
        return this.result;
    }

    public ThingUID getThingUID() {
        return this.thingUID;
    }

    public @Nullable String getErrorMessage() {
        return this.errorMessage;
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.errorMessage == null ? 0 : this.errorMessage.hashCode());
        result = 31 * result + (this.result == null ? 0 : this.result.hashCode());
        return result;
    }

    public boolean equals(@Nullable Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        FirmwareUpdateResultInfo other = (FirmwareUpdateResultInfo)obj;
        if (this.errorMessage == null ? other.errorMessage != null : !this.errorMessage.equals(other.errorMessage)) {
            return false;
        }
        return this.result == other.result;
    }

    public String toString() {
        return "FirmwareUpdateResultInfo [result=" + (Object)((Object)this.result) + ", errorMessage=" + this.errorMessage + "]";
    }
}

