/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.core.thing.firmware;

import java.util.Collection;
import java.util.Objects;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.smarthome.core.thing.ThingTypeUID;
import org.eclipse.smarthome.core.thing.ThingUID;
import org.eclipse.smarthome.core.thing.binding.firmware.ProgressStep;

@NonNullByDefault
public final class FirmwareUpdateProgressInfo {
    private final ThingUID thingUID;
    private final String firmwareVersion;
    private final ProgressStep progressStep;
    private final Collection<ProgressStep> sequence;
    private final boolean pending;
    private final @Nullable Integer progress;

    private FirmwareUpdateProgressInfo(ThingUID thingUID, String firmwareVersion, ProgressStep progressStep, Collection<ProgressStep> sequence, boolean pending, int progress) {
        Objects.requireNonNull(thingUID, "ThingUID must not be null.");
        Objects.requireNonNull(firmwareVersion, "Firmware version must not be null.");
        if (progress < 0 || progress > 100) {
            throw new IllegalArgumentException("The progress must be between 0 and 100.");
        }
        this.thingUID = thingUID;
        this.firmwareVersion = firmwareVersion;
        this.progressStep = progressStep;
        this.sequence = sequence;
        this.pending = pending;
        this.progress = progress;
    }

    public static FirmwareUpdateProgressInfo createFirmwareUpdateProgressInfo(ThingUID thingUID, String firmwareVersion, ProgressStep progressStep, Collection<ProgressStep> sequence, boolean pending, int progress) {
        return new FirmwareUpdateProgressInfo(thingUID, firmwareVersion, progressStep, sequence, pending, progress);
    }

    private FirmwareUpdateProgressInfo(ThingUID thingUID, String firmwareVersion, ProgressStep progressStep, Collection<ProgressStep> sequence, boolean pending) {
        Objects.requireNonNull(thingUID, "ThingUID must not be null.");
        Objects.requireNonNull(firmwareVersion, "Firmware version must not be null.");
        if (sequence == null || sequence.isEmpty()) {
            throw new IllegalArgumentException("Sequence must not be null or empty.");
        }
        Objects.requireNonNull(progressStep, "Progress step must not be null.");
        this.thingUID = thingUID;
        this.firmwareVersion = firmwareVersion;
        this.progressStep = progressStep;
        this.sequence = sequence;
        this.pending = pending;
        this.progress = null;
    }

    public static @NonNull FirmwareUpdateProgressInfo createFirmwareUpdateProgressInfo(ThingUID thingUID, ThingTypeUID thingTypeUID, String firmwareVersion, ProgressStep progressStep, Collection<ProgressStep> sequence, boolean pending) {
        return new FirmwareUpdateProgressInfo(thingUID, firmwareVersion, progressStep, sequence, pending);
    }

    public String getFirmwareVersion() {
        return this.firmwareVersion;
    }

    public ProgressStep getProgressStep() {
        return this.progressStep;
    }

    public Collection<ProgressStep> getSequence() {
        return this.sequence;
    }

    public boolean isPending() {
        return this.pending;
    }

    public @Nullable Integer getProgress() {
        return this.progress;
    }

    public ThingUID getThingUID() {
        return this.thingUID;
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.thingUID == null ? 0 : this.thingUID.hashCode());
        result = 31 * result + (this.firmwareVersion == null ? 0 : this.firmwareVersion.hashCode());
        result = 31 * result + (this.pending ? 1231 : 1237);
        result = 31 * result + this.progress;
        result = 31 * result + (this.progressStep == null ? 0 : this.progressStep.hashCode());
        result = 31 * result + (this.sequence == null ? 0 : this.sequence.hashCode());
        return result;
    }

    public boolean equals(@Nullable Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FirmwareUpdateProgressInfo)) {
            return false;
        }
        FirmwareUpdateProgressInfo other = (FirmwareUpdateProgressInfo)obj;
        if (this.thingUID == null ? other.thingUID != null : !this.thingUID.equals((Object)other.thingUID)) {
            return false;
        }
        if (this.firmwareVersion == null ? other.firmwareVersion != null : !this.firmwareVersion.equals(other.firmwareVersion)) {
            return false;
        }
        if (this.pending != other.pending) {
            return false;
        }
        if (!this.progress.equals(other.progress)) {
            return false;
        }
        if (this.progressStep != other.progressStep) {
            return false;
        }
        return !(this.sequence == null ? other.sequence != null : !this.sequence.equals(other.sequence));
    }

    public String toString() {
        return "FirmwareUpdateProgressInfo [thingUID=" + (Object)((Object)this.thingUID) + ", firmwareVersion=" + this.firmwareVersion + ", progressStep=" + (Object)((Object)this.progressStep) + ", sequence=" + this.sequence + ", pending=" + this.pending + ", progress=" + this.progress + "]";
    }
}

