/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.core.thing.binding.firmware;

import java.io.InputStream;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.smarthome.core.thing.ThingTypeUID;
import org.eclipse.smarthome.core.thing.binding.firmware.Firmware;
import org.eclipse.smarthome.core.thing.binding.firmware.FirmwareRestriction;
import org.eclipse.smarthome.core.thing.internal.firmware.FirmwareImpl;

@NonNullByDefault
public final class FirmwareBuilder {
    private final ThingTypeUID thingTypeUID;
    private final String version;
    private @Nullable String vendor;
    private @Nullable String model;
    private boolean modelRestricted;
    private @Nullable String description;
    private @Nullable String prerequisiteVersion;
    private @Nullable FirmwareRestriction firmwareRestriction;
    private @Nullable String changelog;
    private @Nullable URL onlineChangelog;
    private transient @Nullable InputStream inputStream;
    private @Nullable String md5Hash;
    private Map<String, String> properties;

    public static FirmwareBuilder create(ThingTypeUID thingTypeUID, String firmwareVersion) {
        return new FirmwareBuilder(thingTypeUID, firmwareVersion);
    }

    private FirmwareBuilder(ThingTypeUID thingTypeUID, String firmwareVersion) {
        this.checkNotNull((Object)thingTypeUID, "ThingTypeUID");
        this.thingTypeUID = thingTypeUID;
        this.checkNotNullOrEmpty(firmwareVersion, "Firmware version");
        this.version = firmwareVersion;
        this.properties = new HashMap<String, String>();
    }

    public FirmwareBuilder withVendor(@Nullable String vendor) {
        this.vendor = vendor;
        return this;
    }

    public FirmwareBuilder withModel(@Nullable String model) {
        this.model = model;
        return this;
    }

    public FirmwareBuilder withModelRestricted(boolean modelRestricted) {
        this.modelRestricted = modelRestricted;
        return this;
    }

    public FirmwareBuilder withDescription(@Nullable String description) {
        this.description = description;
        return this;
    }

    public FirmwareBuilder withPrerequisiteVersion(@Nullable String prerequisiteVersion) {
        this.prerequisiteVersion = prerequisiteVersion;
        return this;
    }

    public FirmwareBuilder withChangelog(@Nullable String changelog) {
        this.changelog = changelog;
        return this;
    }

    public FirmwareBuilder withOnlineChangelog(@Nullable URL onlineChangelog) {
        this.onlineChangelog = onlineChangelog;
        return this;
    }

    public FirmwareBuilder withInputStream(@Nullable InputStream inputStream) {
        this.inputStream = inputStream;
        return this;
    }

    public FirmwareBuilder withProperties(Map<String, String> properties) {
        this.checkNotNull(properties, "Properties");
        this.properties = properties;
        return this;
    }

    public FirmwareBuilder withMd5Hash(@Nullable String md5Hash) {
        this.md5Hash = md5Hash;
        return this;
    }

    public FirmwareBuilder withFirmwareRestriction(FirmwareRestriction firmwareRestriction) {
        this.checkNotNull(firmwareRestriction, "Firmware restriction function");
        this.firmwareRestriction = firmwareRestriction;
        return this;
    }

    private void checkNotNull(@Nullable Object object, String argumentName) {
        if (object == null) {
            throw new IllegalArgumentException(String.valueOf(argumentName) + " must not be null.");
        }
    }

    private void checkNotNullOrEmpty(@Nullable String string, String argumentName) {
        if (string == null || string.isEmpty()) {
            throw new IllegalArgumentException(String.valueOf(argumentName) + " must not be null or empty.");
        }
    }

    public Firmware build() {
        if (this.modelRestricted && StringUtils.isEmpty((String)this.model)) {
            throw new IllegalArgumentException("Cannot create model restricted firmware without model");
        }
        return new FirmwareImpl(this.thingTypeUID, this.vendor, this.model, this.modelRestricted, this.description, this.version, this.prerequisiteVersion, this.firmwareRestriction, this.changelog, this.onlineChangelog, this.inputStream, this.md5Hash, this.properties);
    }
}

