/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.core.thing;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.smarthome.core.thing.ChannelGroupUID;
import org.eclipse.smarthome.core.thing.ThingTypeUID;
import org.eclipse.smarthome.core.thing.ThingUID;
import org.eclipse.smarthome.core.thing.UID;

@NonNullByDefault
public class ChannelUID
extends UID {
    private static final String CHANNEL_SEGMENT_PATTERN = "[\\w-]*|[\\w-]*#[\\w-]*";
    private static final String CHANNEL_GROUP_SEPARATOR = "#";

    ChannelUID() {
    }

    public ChannelUID(String channelUid) {
        super(channelUid);
    }

    public ChannelUID(ThingUID thingUID, String id) {
        super(ChannelUID.toSegments(thingUID, null, id));
    }

    @Deprecated
    public ChannelUID(ThingTypeUID thingTypeUID, ThingUID thingUID, String id) {
        super(ChannelUID.toSegments(thingUID, null, id));
    }

    public ChannelUID(ChannelGroupUID channelGroupUID, String id) {
        super(ChannelUID.toSegments(channelGroupUID.getThingUID(), channelGroupUID.getId(), id));
    }

    public ChannelUID(ThingUID thingUID, String groupId, String id) {
        super(ChannelUID.toSegments(thingUID, groupId, id));
    }

    @Deprecated
    public ChannelUID(ThingTypeUID thingTypeUID, ThingUID thingUID, String groupId, String id) {
        super(ChannelUID.toSegments(thingUID, groupId, id));
    }

    @Deprecated
    public ChannelUID(ThingTypeUID thingTypeUID, String thingId, String id) {
        this(thingTypeUID.getBindingId(), thingTypeUID.getId(), thingId, id);
    }

    @Deprecated
    public ChannelUID(String bindingId, String thingTypeId, String thingId, String id) {
        super(bindingId, thingTypeId, thingId, id);
    }

    @Deprecated
    public ChannelUID(String bindingId, String thingTypeId, String thingId, String groupId, String id) {
        super(bindingId, thingTypeId, thingId, ChannelUID.getChannelId(groupId, id));
    }

    private static List<String> toSegments(ThingUID thingUID, @Nullable String groupId, String id) {
        ArrayList<String> ret = new ArrayList<String>(thingUID.getAllSegments());
        ret.add(ChannelUID.getChannelId(groupId, id));
        return ret;
    }

    private static String getChannelId(@Nullable String groupId, String id) {
        return groupId != null ? String.valueOf(groupId) + CHANNEL_GROUP_SEPARATOR + id : id;
    }

    public String getId() {
        List<String> segments = this.getAllSegments();
        return segments.get(segments.size() - 1);
    }

    public String getIdWithoutGroup() {
        if (!this.isInGroup()) {
            return this.getId();
        }
        return this.getId().split(CHANNEL_GROUP_SEPARATOR)[1];
    }

    public boolean isInGroup() {
        return this.getId().contains(CHANNEL_GROUP_SEPARATOR);
    }

    public @Nullable String getGroupId() {
        return this.isInGroup() ? this.getId().split(CHANNEL_GROUP_SEPARATOR)[0] : null;
    }

    protected int getMinimalNumberOfSegments() {
        return 4;
    }

    protected void validateSegment(String segment, int index, int length) {
        if (index < length - 1) {
            super.validateSegment(segment, index, length);
        } else if (!segment.matches(CHANNEL_SEGMENT_PATTERN)) {
            throw new IllegalArgumentException(String.format("UID segment '%s' contains invalid characters. The last segment of the channel UID must match the pattern '%s'.", segment, CHANNEL_SEGMENT_PATTERN));
        }
    }

    public ThingUID getThingUID() {
        List<String> allSegments = this.getAllSegments();
        return new ThingUID(allSegments.subList(0, allSegments.size() - 1).toArray(new String[allSegments.size() - 1]));
    }
}

