/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.core.thing;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.smarthome.config.core.Configuration;
import org.eclipse.smarthome.core.thing.ChannelUID;
import org.eclipse.smarthome.core.thing.type.AutoUpdatePolicy;
import org.eclipse.smarthome.core.thing.type.ChannelKind;
import org.eclipse.smarthome.core.thing.type.ChannelTypeUID;

@NonNullByDefault
public class Channel {
    private @Nullable String acceptedItemType;
    private final ChannelKind kind;
    @NonNullByDefault(value={})
    private ChannelUID uid;
    private @Nullable ChannelTypeUID channelTypeUID;
    private @Nullable String label;
    private @Nullable String description;
    private Configuration configuration;
    private Map<String, String> properties;
    private Set<String> defaultTags = new LinkedHashSet<String>();
    private @Nullable AutoUpdatePolicy autoUpdatePolicy;

    Channel() {
        this.kind = ChannelKind.STATE;
        this.configuration = new Configuration();
        this.properties = Collections.unmodifiableMap(new HashMap(0));
    }

    @Deprecated
    public Channel(ChannelUID uid, String acceptedItemType) {
        this.uid = uid;
        this.acceptedItemType = acceptedItemType;
        this.kind = ChannelKind.STATE;
        this.configuration = new Configuration();
        this.properties = Collections.unmodifiableMap(new HashMap(0));
    }

    @Deprecated
    public Channel(ChannelUID uid, String acceptedItemType, Configuration configuration) {
        this(uid, null, acceptedItemType, ChannelKind.STATE, configuration, new HashSet<String>(0), null, null, null, null);
    }

    @Deprecated
    public Channel(ChannelUID uid, String acceptedItemType, Set<String> defaultTags) {
        this(uid, null, acceptedItemType, ChannelKind.STATE, null, defaultTags, null, null, null, null);
    }

    @Deprecated
    public Channel(ChannelUID uid, String acceptedItemType, Configuration configuration, Set<String> defaultTags, Map<String, String> properties) {
        this(uid, null, acceptedItemType, ChannelKind.STATE, null, defaultTags, properties, null, null, null);
    }

    @Deprecated
    public Channel(ChannelUID uid, @Nullable ChannelTypeUID channelTypeUID, @Nullable String acceptedItemType, ChannelKind kind, @Nullable Configuration configuration, Set<String> defaultTags, @Nullable Map<String, String> properties, @Nullable String label, @Nullable String description, @Nullable AutoUpdatePolicy autoUpdatePolicy) {
        this.uid = uid;
        this.channelTypeUID = channelTypeUID;
        this.acceptedItemType = acceptedItemType;
        this.kind = kind;
        this.label = label;
        this.description = description;
        this.autoUpdatePolicy = autoUpdatePolicy;
        this.defaultTags = Collections.unmodifiableSet(new HashSet<String>(defaultTags));
        this.configuration = configuration == null ? new Configuration() : configuration;
        this.properties = properties == null ? Collections.unmodifiableMap(new HashMap(0)) : properties;
    }

    public @Nullable String getAcceptedItemType() {
        return this.acceptedItemType;
    }

    public ChannelKind getKind() {
        return this.kind;
    }

    public ChannelUID getUID() {
        return this.uid;
    }

    public @Nullable ChannelTypeUID getChannelTypeUID() {
        return this.channelTypeUID;
    }

    public @Nullable String getLabel() {
        return this.label;
    }

    public @Nullable String getDescription() {
        return this.description;
    }

    public Configuration getConfiguration() {
        return this.configuration;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getProperties() {
        Channel channel = this;
        synchronized (channel) {
            return Collections.unmodifiableMap(new HashMap<String, String>(this.properties));
        }
    }

    public Set<String> getDefaultTags() {
        return this.defaultTags;
    }

    public @Nullable AutoUpdatePolicy getAutoUpdatePolicy() {
        return this.autoUpdatePolicy;
    }
}

