/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.core.thing.xml.internal;

import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import org.eclipse.smarthome.config.core.ConfigDescriptionProvider;
import org.eclipse.smarthome.config.xml.AbstractXmlBasedProvider;
import org.eclipse.smarthome.config.xml.AbstractXmlConfigDescriptionProvider;
import org.eclipse.smarthome.config.xml.osgi.XmlDocumentBundleTracker;
import org.eclipse.smarthome.config.xml.osgi.XmlDocumentProvider;
import org.eclipse.smarthome.config.xml.osgi.XmlDocumentProviderFactory;
import org.eclipse.smarthome.config.xml.util.XmlDocumentReader;
import org.eclipse.smarthome.core.common.ThreadPoolManager;
import org.eclipse.smarthome.core.service.ReadyService;
import org.eclipse.smarthome.core.thing.ThingTypeUID;
import org.eclipse.smarthome.core.thing.UID;
import org.eclipse.smarthome.core.thing.binding.ThingTypeProvider;
import org.eclipse.smarthome.core.thing.i18n.ThingTypeI18nLocalizationService;
import org.eclipse.smarthome.core.thing.type.ChannelGroupTypeProvider;
import org.eclipse.smarthome.core.thing.type.ChannelTypeProvider;
import org.eclipse.smarthome.core.thing.type.ThingType;
import org.eclipse.smarthome.core.thing.xml.internal.ThingDescriptionReader;
import org.eclipse.smarthome.core.thing.xml.internal.ThingTypeXmlProvider;
import org.eclipse.smarthome.core.thing.xml.internal.XmlChannelGroupTypeProvider;
import org.eclipse.smarthome.core.thing.xml.internal.XmlChannelTypeProvider;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;

@Component(property={"esh.scope=core.xml.thing"})
public class XmlThingTypeProvider
extends AbstractXmlBasedProvider<UID, ThingType>
implements ThingTypeProvider,
XmlDocumentProviderFactory<List<?>> {
    private static final String XML_DIRECTORY = "/ESH-INF/thing/";
    public static final String READY_MARKER = "esh.xmlThingTypes";
    private ThingTypeI18nLocalizationService thingTypeI18nLocalizationService;
    private AbstractXmlConfigDescriptionProvider configDescriptionProvider;
    private XmlChannelTypeProvider channelTypeProvider;
    private XmlChannelGroupTypeProvider channelGroupTypeProvider;
    private XmlDocumentBundleTracker<List<?>> thingTypeTracker;
    private ReadyService readyService;
    private final ScheduledExecutorService scheduler = ThreadPoolManager.getScheduledPool((String)"file-processing");
    private Future<?> trackerJob;

    @Activate
    protected void activate(BundleContext bundleContext) {
        ThingDescriptionReader thingTypeReader = new ThingDescriptionReader();
        this.thingTypeTracker = new XmlDocumentBundleTracker(bundleContext, XML_DIRECTORY, (XmlDocumentReader)thingTypeReader, (XmlDocumentProviderFactory)this, READY_MARKER, this.readyService);
        this.trackerJob = this.scheduler.submit(() -> this.thingTypeTracker.open());
    }

    @Deactivate
    protected void deactivate() {
        if (this.trackerJob != null && !this.trackerJob.isDone()) {
            this.trackerJob.cancel(true);
            this.trackerJob = null;
        }
        this.thingTypeTracker.close();
        this.thingTypeTracker = null;
    }

    public ThingType getThingType(ThingTypeUID thingTypeUID, Locale locale) {
        return (ThingType)this.get(thingTypeUID, locale);
    }

    public synchronized Collection<ThingType> getThingTypes(Locale locale) {
        return this.getAll(locale);
    }

    @Reference
    public void setThingTypeI18nLocalizationService(ThingTypeI18nLocalizationService thingTypeI18nLocalizationService) {
        this.thingTypeI18nLocalizationService = thingTypeI18nLocalizationService;
    }

    public void unsetThingTypeI18nLocalizationService(ThingTypeI18nLocalizationService thingTypeI18nLocalizationService) {
        this.thingTypeI18nLocalizationService = null;
    }

    @Reference(target="(esh.scope=core.xml.thing)")
    public void setConfigDescriptionProvider(ConfigDescriptionProvider configDescriptionProvider) {
        this.configDescriptionProvider = (AbstractXmlConfigDescriptionProvider)configDescriptionProvider;
    }

    public void unsetConfigDescriptionProvider(ConfigDescriptionProvider configDescriptionProvider) {
        this.configDescriptionProvider = null;
    }

    @Reference(target="(esh.scope=core.xml.channels)")
    public void setChannelTypeProvider(ChannelTypeProvider channelTypeProvider) {
        this.channelTypeProvider = (XmlChannelTypeProvider)channelTypeProvider;
    }

    public void unsetChannelTypeProvider(ChannelTypeProvider channelTypeProvider) {
        this.channelTypeProvider = null;
    }

    @Reference(target="(esh.scope=core.xml.channelGroups)")
    public void setChannelGroupTypeProvider(ChannelGroupTypeProvider channelGroupTypeProvider) {
        this.channelGroupTypeProvider = (XmlChannelGroupTypeProvider)channelGroupTypeProvider;
    }

    public void unsetChannelGroupTypeProvider(ChannelGroupTypeProvider channelGroupTypeProvider) {
        this.channelGroupTypeProvider = null;
    }

    @Reference
    public void setReadyService(ReadyService readyService) {
        this.readyService = readyService;
    }

    public void unsetReadyService(ReadyService readyService) {
        this.readyService = null;
    }

    protected ThingType localize(Bundle bundle, ThingType thingType, Locale locale) {
        if (this.thingTypeI18nLocalizationService == null) {
            return null;
        }
        return this.thingTypeI18nLocalizationService.createLocalizedThingType(bundle, thingType, locale);
    }

    public XmlDocumentProvider<List<?>> createDocumentProvider(Bundle bundle) {
        return new ThingTypeXmlProvider(bundle, this.configDescriptionProvider, this, this.channelTypeProvider, this.channelGroupTypeProvider);
    }
}

