/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.core.thing.xml.internal;

import com.thoughtworks.xstream.converters.ConversionException;
import com.thoughtworks.xstream.converters.UnmarshallingContext;
import com.thoughtworks.xstream.io.HierarchicalStreamReader;
import java.util.List;
import java.util.Map;
import org.eclipse.smarthome.config.xml.util.ConverterAttributeMapValidator;
import org.eclipse.smarthome.config.xml.util.NodeIterator;
import org.eclipse.smarthome.core.thing.type.ChannelGroupTypeUID;
import org.eclipse.smarthome.core.thing.xml.internal.AbstractDescriptionTypeConverter;
import org.eclipse.smarthome.core.thing.xml.internal.ChannelGroupTypeXmlResult;
import org.eclipse.smarthome.core.thing.xml.internal.ChannelXmlResult;

public class ChannelGroupTypeConverter
extends AbstractDescriptionTypeConverter<ChannelGroupTypeXmlResult> {
    public ChannelGroupTypeConverter() {
        super(ChannelGroupTypeXmlResult.class, "channel-group-type");
        this.attributeMapValidator = new ConverterAttributeMapValidator((String[][])new String[][]{{"id", "true"}, {"advanced", "false"}});
    }

    private boolean isAdvanced(Map<String, String> attributes, boolean defaultValue) {
        String advancedObj = attributes.get("advanced");
        if (advancedObj != null) {
            return Boolean.parseBoolean(advancedObj);
        }
        return defaultValue;
    }

    protected List<ChannelXmlResult> readChannelTypeDefinitions(NodeIterator nodeIterator) throws ConversionException {
        return nodeIterator.nextList("channels", true);
    }

    @Override
    protected ChannelGroupTypeXmlResult unmarshalType(HierarchicalStreamReader reader, UnmarshallingContext context, Map<String, String> attributes, NodeIterator nodeIterator) throws ConversionException {
        ChannelGroupTypeUID channelGroupTypeUID = new ChannelGroupTypeUID(super.getUID(attributes, context));
        boolean advanced = this.isAdvanced(attributes, false);
        String label = super.readLabel(nodeIterator);
        String description = super.readDescription(nodeIterator);
        String category = this.readCategory(nodeIterator);
        List<ChannelXmlResult> channelTypeDefinitions = this.readChannelTypeDefinitions(nodeIterator);
        ChannelGroupTypeXmlResult groupChannelType = new ChannelGroupTypeXmlResult(channelGroupTypeUID, advanced, label, description, category, channelTypeDefinitions);
        return groupChannelType;
    }

    private String readCategory(NodeIterator nodeIterator) {
        Object category = nodeIterator.nextValue("category", false);
        if (category != null) {
            return category.toString();
        }
        return null;
    }
}

