/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.config.xml.util;

import com.thoughtworks.xstream.converters.ConversionException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.smarthome.config.xml.util.NodeAttributes;
import org.eclipse.smarthome.config.xml.util.NodeList;
import org.eclipse.smarthome.config.xml.util.NodeName;
import org.eclipse.smarthome.config.xml.util.NodeValue;

public class NodeIterator
implements Iterator<Object> {
    private List<?> nodes;
    private int index = 0;

    public NodeIterator(List<?> nodes) {
        this.nodes = nodes != null ? nodes : new ArrayList(0);
    }

    @Override
    public boolean hasNext() {
        return this.index < this.nodes.size();
    }

    @Override
    public Object next() {
        if (this.hasNext()) {
            return this.nodes.get(this.index++);
        }
        return null;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    public void revert() {
        if (this.index > 0) {
            --this.index;
        }
    }

    public void assertEndOfType() throws ConversionException {
        if (this.hasNext()) {
            ArrayList<Object> nodes = new ArrayList<Object>();
            while (this.hasNext()) {
                nodes.add(this.next());
            }
            throw new ConversionException("The document is invalid, it contains further unsupported data: " + nodes + "!");
        }
    }

    public Object next(String nodeName, boolean required) throws ConversionException {
        if (this.hasNext()) {
            Object nextNode = this.next();
            if (nextNode instanceof NodeName && nodeName.equals(((NodeName)nextNode).getNodeName())) {
                return nextNode;
            }
            --this.index;
        }
        if (required) {
            throw new ConversionException("The node '" + nodeName + "' is missing!");
        }
        return null;
    }

    public String nextAttribute(String nodeName, String attributeName, boolean required) throws ConversionException {
        if (this.hasNext()) {
            Object nextNode = this.next();
            if (nextNode instanceof NodeAttributes && nodeName.equals(((NodeName)nextNode).getNodeName())) {
                return ((NodeAttributes)nextNode).getAttribute(attributeName);
            }
            --this.index;
        }
        if (required) {
            throw new ConversionException("The attribute '" + attributeName + "' in the node '" + nodeName + "' is missing!");
        }
        return null;
    }

    public Object nextValue(String nodeName, boolean required) throws ConversionException {
        Object value = this.next(nodeName, required);
        if (value instanceof NodeValue) {
            return ((NodeValue)value).getValue();
        }
        return null;
    }

    public List<?> nextList(String nodeName, boolean required) throws ConversionException {
        Object list = this.next(nodeName, required);
        if (list instanceof NodeList) {
            return ((NodeList)list).getList();
        }
        return null;
    }
}

