/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.binding.wemo.internal.discovery;

import org.eclipse.smarthome.config.discovery.AbstractDiscoveryService;
import org.eclipse.smarthome.config.discovery.DiscoveryService;
import org.jupnp.UpnpService;
import org.jupnp.model.message.header.RootDeviceHeader;
import org.jupnp.model.message.header.UpnpHeader;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(service={DiscoveryService.class}, immediate=true, configurationPid="discovery.wemo")
public class WemoDiscoveryService
extends AbstractDiscoveryService {
    private Logger logger = LoggerFactory.getLogger(WemoDiscoveryService.class);
    private UpnpService upnpService;

    public WemoDiscoveryService() {
        super(5);
    }

    @Reference
    protected void setUpnpService(UpnpService upnpService) {
        this.upnpService = upnpService;
    }

    protected void unsetUpnpService(UpnpService upnpService) {
        this.upnpService = null;
    }

    public void activate() {
        this.logger.debug("Starting WeMo UPnP discovery...");
        this.startScan();
    }

    public void deactivate() {
        this.logger.debug("Stopping WeMo UPnP discovery...");
        this.stopScan();
    }

    protected void startScan() {
        this.logger.debug("Starting UPnP RootDevice search...");
        if (this.upnpService != null) {
            this.upnpService.getControlPoint().search((UpnpHeader)new RootDeviceHeader());
        } else {
            this.logger.debug("upnpService not set");
        }
    }

    protected synchronized void stopScan() {
        this.removeOlderResults(this.getTimestampOfLastScan());
        super.stopScan();
    }
}

