/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.binding.wemo.handler;

import java.io.StringReader;
import java.math.BigDecimal;
import java.net.URL;
import java.util.Collections;
import java.util.Set;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.commons.lang.StringUtils;
import org.eclipse.smarthome.binding.wemo.WemoBindingConstants;
import org.eclipse.smarthome.binding.wemo.handler.AbstractWemoHandler;
import org.eclipse.smarthome.binding.wemo.internal.http.WemoHttpCall;
import org.eclipse.smarthome.config.core.Configuration;
import org.eclipse.smarthome.core.library.types.OnOffType;
import org.eclipse.smarthome.core.thing.ChannelUID;
import org.eclipse.smarthome.core.thing.Thing;
import org.eclipse.smarthome.core.thing.ThingStatus;
import org.eclipse.smarthome.core.thing.ThingStatusDetail;
import org.eclipse.smarthome.core.thing.ThingTypeUID;
import org.eclipse.smarthome.core.types.Command;
import org.eclipse.smarthome.core.types.RefreshType;
import org.eclipse.smarthome.core.types.State;
import org.eclipse.smarthome.io.transport.upnp.UpnpIOParticipant;
import org.eclipse.smarthome.io.transport.upnp.UpnpIOService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.CharacterData;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public class WemoMakerHandler
extends AbstractWemoHandler
implements UpnpIOParticipant {
    private final Logger logger = LoggerFactory.getLogger(WemoMakerHandler.class);
    public static final Set<ThingTypeUID> SUPPORTED_THING_TYPES = Collections.singleton(WemoBindingConstants.THING_TYPE_MAKER);
    private UpnpIOService service;
    private final int DEFAULT_REFRESH_INTERVAL = 15;
    private ScheduledFuture<?> refreshJob;
    private final Runnable refreshRunnable = new Runnable(){

        @Override
        public void run() {
            try {
                WemoMakerHandler.this.updateWemoState();
            }
            catch (Exception e) {
                WemoMakerHandler.this.logger.debug("Exception during poll : {}", (Throwable)e);
                WemoMakerHandler.this.updateStatus(ThingStatus.OFFLINE, ThingStatusDetail.COMMUNICATION_ERROR, e.getMessage());
            }
        }
    };

    public WemoMakerHandler(Thing thing, UpnpIOService upnpIOService, WemoHttpCall wemoHttpcaller) {
        super(thing);
        this.wemoHttpCaller = wemoHttpcaller;
        this.logger.debug("Creating a WemoMakerHandler for thing '{}'", (Object)this.getThing().getUID());
        if (upnpIOService != null) {
            this.service = upnpIOService;
        } else {
            this.logger.debug("upnpIOService not set.");
        }
    }

    public void initialize() {
        Configuration configuration = this.getConfig();
        if (configuration.get("udn") != null) {
            this.logger.debug("Initializing WemoMakerHandler for UDN '{}'", configuration.get("udn"));
            this.onUpdate();
            this.updateStatus(ThingStatus.ONLINE);
        } else {
            this.logger.debug("Cannot initalize WemoMakerHandler. UDN not set.");
        }
    }

    public void dispose() {
        this.logger.debug("WeMoMakerHandler disposed.");
        if (this.refreshJob != null && !this.refreshJob.isCancelled()) {
            this.refreshJob.cancel(true);
            this.refreshJob = null;
        }
    }

    public void handleCommand(ChannelUID channelUID, Command command) {
        this.logger.trace("Command '{}' received for channel '{}'", (Object)command, (Object)channelUID);
        if (command instanceof RefreshType) {
            try {
                this.updateWemoState();
            }
            catch (Exception e) {
                this.logger.debug("Exception during poll : {}", (Throwable)e);
            }
        } else if (channelUID.getId().equals("relay") && command instanceof OnOffType) {
            try {
                String binaryState = null;
                if (command.equals(OnOffType.ON)) {
                    binaryState = "1";
                } else if (command.equals(OnOffType.OFF)) {
                    binaryState = "0";
                }
                String soapHeader = "\"urn:Belkin:service:basicevent:1#SetBinaryState\"";
                String content = "<?xml version=\"1.0\"?><s:Envelope xmlns:s=\"http://schemas.xmlsoap.org/soap/envelope/\" s:encodingStyle=\"http://schemas.xmlsoap.org/soap/encoding/\"><s:Body><u:SetBinaryState xmlns:u=\"urn:Belkin:service:basicevent:1\"><BinaryState>" + binaryState + "</BinaryState>" + "</u:SetBinaryState>" + "</s:Body>" + "</s:Envelope>";
                String wemoURL = this.getWemoURL("basicevent");
                if (wemoURL != null) {
                    this.wemoHttpCaller.executeCall(wemoURL, soapHeader, content);
                }
            }
            catch (Exception e) {
                this.logger.error("Failed to send command '{}' for device '{}' ", new Object[]{command, this.getThing().getUID(), e});
            }
        }
    }

    private synchronized void onSubscription() {
    }

    private synchronized void removeSubscription() {
    }

    private synchronized void onUpdate() {
        if (this.service.isRegistered((UpnpIOParticipant)this) && (this.refreshJob == null || this.refreshJob.isCancelled())) {
            Configuration config = this.getThing().getConfiguration();
            int refreshInterval = 15;
            Object refreshConfig = config.get("refresh");
            if (refreshConfig != null) {
                refreshInterval = ((BigDecimal)refreshConfig).intValue();
            }
            this.refreshJob = this.scheduler.scheduleWithFixedDelay(this.refreshRunnable, 0L, refreshInterval, TimeUnit.SECONDS);
        }
    }

    public String getUDN() {
        return (String)this.getThing().getConfiguration().get("udn");
    }

    protected void updateWemoState() {
        block15: {
            String action = "GetAttributes";
            String actionService = "deviceevent";
            String soapHeader = "\"urn:Belkin:service:" + actionService + ":1#" + action + "\"";
            String content = "<?xml version=\"1.0\"?><s:Envelope xmlns:s=\"http://schemas.xmlsoap.org/soap/envelope/\" s:encodingStyle=\"http://schemas.xmlsoap.org/soap/encoding/\"><s:Body><u:" + action + " xmlns:u=\"urn:Belkin:service:" + actionService + ":1\">" + "</u:" + action + ">" + "</s:Body>" + "</s:Envelope>";
            try {
                String wemoCallResponse;
                String wemoURL = this.getWemoURL(actionService);
                if (wemoURL == null || (wemoCallResponse = this.wemoHttpCaller.executeCall(wemoURL, soapHeader, content)) == null) break block15;
                try {
                    String stringParser = StringUtils.substringBetween((String)wemoCallResponse, (String)"<attributeList>", (String)"</attributeList>");
                    stringParser = StringEscapeUtils.unescapeXml((String)stringParser);
                    stringParser = StringEscapeUtils.unescapeXml((String)stringParser);
                    this.logger.trace("Maker response '{}' for device '{}' received", (Object)stringParser, (Object)this.getThing().getUID());
                    stringParser = "<data>" + stringParser + "</data>";
                    DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
                    DocumentBuilder db = dbf.newDocumentBuilder();
                    InputSource is = new InputSource();
                    is.setCharacterStream(new StringReader(stringParser));
                    Document doc = db.parse(is);
                    NodeList nodes = doc.getElementsByTagName("attribute");
                    int i = 0;
                    while (i < nodes.getLength()) {
                        Element element = (Element)nodes.item(i);
                        NodeList deviceIndex = element.getElementsByTagName("name");
                        Element line = (Element)deviceIndex.item(0);
                        String attributeName = WemoMakerHandler.getCharacterDataFromElement(line);
                        this.logger.trace("attributeName: {}", (Object)attributeName);
                        NodeList deviceID = element.getElementsByTagName("value");
                        line = (Element)deviceID.item(0);
                        String attributeValue = WemoMakerHandler.getCharacterDataFromElement(line);
                        this.logger.trace("attributeValue: {}", (Object)attributeValue);
                        switch (attributeName) {
                            case "Switch": {
                                OnOffType relayState;
                                OnOffType onOffType = relayState = attributeValue.equals("0") ? OnOffType.OFF : OnOffType.ON;
                                if (relayState == null) break;
                                this.logger.debug("New relayState '{}' for device '{}' received", (Object)relayState, (Object)this.getThing().getUID());
                                this.updateState("relay", (State)relayState);
                                break;
                            }
                            case "Sensor": {
                                OnOffType sensorState;
                                OnOffType onOffType = sensorState = attributeValue.equals("1") ? OnOffType.OFF : OnOffType.ON;
                                if (sensorState == null) break;
                                this.logger.debug("New sensorState '{}' for device '{}' received", (Object)sensorState, (Object)this.getThing().getUID());
                                this.updateState("sensor", (State)sensorState);
                            }
                        }
                        ++i;
                    }
                }
                catch (Exception e) {
                    this.logger.error("Failed to parse attributeList for WeMo Maker '{}'", (Object)this.getThing().getUID(), (Object)e);
                }
            }
            catch (Exception e) {
                this.logger.error("Failed to get attributes for device '{}'", (Object)this.getThing().getUID(), (Object)e);
            }
        }
    }

    public String getWemoURL(String actionService) {
        URL descriptorURL = this.service.getDescriptorURL((UpnpIOParticipant)this);
        String wemoURL = null;
        if (descriptorURL != null) {
            String deviceURL = StringUtils.substringBefore((String)descriptorURL.toString(), (String)"/setup.xml");
            wemoURL = String.valueOf(deviceURL) + "/upnp/control/" + actionService + "1";
            return wemoURL;
        }
        return null;
    }

    public static String getCharacterDataFromElement(Element e) {
        Node child = e.getFirstChild();
        if (child instanceof CharacterData) {
            CharacterData cd = (CharacterData)child;
            return cd.getData();
        }
        return "?";
    }

    public void onStatusChanged(boolean status) {
    }

    public void onServiceSubscribed(String service, boolean succeeded) {
    }

    public void onValueReceived(String variable, String value, String service) {
    }
}

