/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.binding.serialbutton.handler;

import java.io.IOException;
import java.io.InputStream;
import java.util.TooManyListenersException;
import org.apache.commons.io.IOUtils;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.smarthome.core.thing.ChannelUID;
import org.eclipse.smarthome.core.thing.Thing;
import org.eclipse.smarthome.core.thing.ThingStatus;
import org.eclipse.smarthome.core.thing.ThingStatusDetail;
import org.eclipse.smarthome.core.thing.binding.BaseThingHandler;
import org.eclipse.smarthome.core.types.Command;
import org.eclipse.smarthome.io.transport.serial.PortInUseException;
import org.eclipse.smarthome.io.transport.serial.SerialPort;
import org.eclipse.smarthome.io.transport.serial.SerialPortEvent;
import org.eclipse.smarthome.io.transport.serial.SerialPortEventListener;
import org.eclipse.smarthome.io.transport.serial.SerialPortIdentifier;
import org.eclipse.smarthome.io.transport.serial.SerialPortManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SerialButtonHandler
extends BaseThingHandler
implements SerialPortEventListener {
    private final Logger logger = LoggerFactory.getLogger(SerialButtonHandler.class);
    private final SerialPortManager serialPortManager;
    private SerialPortIdentifier portId;
    private SerialPort serialPort;
    private InputStream inputStream;

    public SerialButtonHandler(Thing thing, SerialPortManager serialPortManager) {
        super(thing);
        this.serialPortManager = serialPortManager;
    }

    public void initialize() {
        String port = (String)this.getConfig().get("port");
        if (port == null) {
            this.updateStatus(ThingStatus.OFFLINE, ThingStatusDetail.OFFLINE.CONFIGURATION_ERROR, "Port must be set!");
            return;
        }
        this.portId = this.serialPortManager.getIdentifier(port);
        if (this.portId == null) {
            this.updateStatus(ThingStatus.OFFLINE, ThingStatusDetail.OFFLINE.CONFIGURATION_ERROR, "Port is not known!");
            return;
        }
        try {
            this.serialPort = this.portId.open(this.getThing().getUID().toString(), 2000);
            this.serialPort.addEventListener((SerialPortEventListener)this);
            this.serialPort.notifyOnDataAvailable(true);
            this.inputStream = this.serialPort.getInputStream();
            this.updateStatus(ThingStatus.ONLINE);
        }
        catch (IOException iOException) {
            this.updateStatus(ThingStatus.OFFLINE, ThingStatusDetail.OFFLINE.COMMUNICATION_ERROR, "I/O error!");
        }
        catch (PortInUseException portInUseException) {
            this.updateStatus(ThingStatus.OFFLINE, ThingStatusDetail.OFFLINE.COMMUNICATION_ERROR, "Port is in use!");
        }
        catch (TooManyListenersException tooManyListenersException) {
            this.updateStatus(ThingStatus.OFFLINE, ThingStatusDetail.OFFLINE.COMMUNICATION_ERROR, "Cannot attach listener to port!");
        }
    }

    public void dispose() {
        if (this.serialPort != null) {
            this.serialPort.close();
        }
        IOUtils.closeQuietly((InputStream)this.inputStream);
    }

    public void serialEvent(SerialPortEvent event) {
        switch (event.getEventType()) {
            case 1: {
                try {
                    do {
                        byte[] readBuffer = new byte[20];
                        while (this.inputStream.available() > 0) {
                            this.inputStream.read(readBuffer);
                        }
                        try {
                            Thread.sleep(100L);
                        }
                        catch (InterruptedException interruptedException) {}
                    } while (this.inputStream.available() > 0);
                    this.triggerChannel("button", "PRESSED");
                }
                catch (IOException e1) {
                    this.logger.debug("Error reading from serial port: {}", (Object)e1.getMessage(), (Object)e1);
                }
                break;
            }
        }
    }

    public void handleCommand(@NonNull ChannelUID channelUID, @NonNull Command command) {
    }
}

