/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.binding.openweathermap.internal.factory;

import java.util.Collections;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.jetty.client.HttpClient;
import org.eclipse.smarthome.binding.openweathermap.internal.OpenWeatherMapBindingConstants;
import org.eclipse.smarthome.binding.openweathermap.internal.discovery.OpenWeatherMapDiscoveryService;
import org.eclipse.smarthome.binding.openweathermap.internal.handler.AbstractOpenWeatherMapHandler;
import org.eclipse.smarthome.binding.openweathermap.internal.handler.OpenWeatherMapAPIHandler;
import org.eclipse.smarthome.binding.openweathermap.internal.handler.OpenWeatherMapWeatherAndForecastHandler;
import org.eclipse.smarthome.config.discovery.DiscoveryService;
import org.eclipse.smarthome.core.i18n.LocaleProvider;
import org.eclipse.smarthome.core.i18n.LocationProvider;
import org.eclipse.smarthome.core.i18n.TranslationProvider;
import org.eclipse.smarthome.core.thing.Bridge;
import org.eclipse.smarthome.core.thing.Thing;
import org.eclipse.smarthome.core.thing.ThingTypeUID;
import org.eclipse.smarthome.core.thing.ThingUID;
import org.eclipse.smarthome.core.thing.binding.BaseThingHandlerFactory;
import org.eclipse.smarthome.core.thing.binding.ThingHandler;
import org.eclipse.smarthome.core.thing.binding.ThingHandlerFactory;
import org.eclipse.smarthome.io.net.http.HttpClientFactory;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@NonNullByDefault
@Component(service={ThingHandlerFactory.class}, configurationPid="binding.openweathermap")
public class OpenWeatherMapHandlerFactory
extends BaseThingHandlerFactory {
    private static final Set<ThingTypeUID> SUPPORTED_THING_TYPES_UIDS = Collections.unmodifiableSet(Stream.concat(OpenWeatherMapAPIHandler.SUPPORTED_THING_TYPES.stream(), AbstractOpenWeatherMapHandler.SUPPORTED_THING_TYPES.stream()).collect(Collectors.toSet()));
    private final Map<ThingUID, ServiceRegistration<?>> discoveryServiceRegs = new HashMap();
    @NonNullByDefault(value={})
    private HttpClient httpClient;
    @NonNullByDefault(value={})
    private LocaleProvider localeProvider;
    @NonNullByDefault(value={})
    private LocationProvider locationProvider;
    @NonNullByDefault(value={})
    private TranslationProvider i18nProvider;

    public boolean supportsThingType(ThingTypeUID thingTypeUID) {
        return SUPPORTED_THING_TYPES_UIDS.contains(thingTypeUID);
    }

    protected @Nullable ThingHandler createHandler(Thing thing) {
        ThingTypeUID thingTypeUID = thing.getThingTypeUID();
        if (OpenWeatherMapBindingConstants.THING_TYPE_WEATHER_API.equals((Object)thingTypeUID)) {
            OpenWeatherMapAPIHandler handler = new OpenWeatherMapAPIHandler((Bridge)thing, this.httpClient, this.localeProvider);
            OpenWeatherMapDiscoveryService discoveryService = new OpenWeatherMapDiscoveryService(handler, this.locationProvider, this.localeProvider, this.i18nProvider);
            this.discoveryServiceRegs.put(handler.getThing().getUID(), this.bundleContext.registerService(DiscoveryService.class.getName(), (Object)discoveryService, new Hashtable()));
            return handler;
        }
        if (OpenWeatherMapBindingConstants.THING_TYPE_WEATHER_AND_FORECAST.equals((Object)thingTypeUID)) {
            return new OpenWeatherMapWeatherAndForecastHandler(thing);
        }
        return null;
    }

    protected synchronized void removeHandler(ThingHandler thingHandler) {
        ServiceRegistration<?> serviceReg;
        if (thingHandler instanceof OpenWeatherMapAPIHandler && (serviceReg = this.discoveryServiceRegs.remove(thingHandler.getThing().getUID())) != null) {
            OpenWeatherMapDiscoveryService discoveryService = (OpenWeatherMapDiscoveryService)((Object)this.bundleContext.getService(serviceReg.getReference()));
            serviceReg.unregister();
            if (discoveryService != null) {
                discoveryService.deactivate();
            }
        }
    }

    @Reference
    protected void setHttpClientFactory(HttpClientFactory httpClientFactory) {
        this.httpClient = httpClientFactory.getCommonHttpClient();
    }

    protected void unsetHttpClientFactory(HttpClientFactory httpClientFactory) {
        this.httpClient = null;
    }

    @Reference
    protected void setLocationProvider(LocationProvider locationProvider) {
        this.locationProvider = locationProvider;
    }

    protected void unsetLocationProvider(LocationProvider locationProvider) {
        this.locationProvider = null;
    }

    @Reference
    protected void setLocaleProvider(LocaleProvider localeProvider) {
        this.localeProvider = localeProvider;
    }

    protected void unsetLocaleProvider(LocaleProvider localeProvider) {
        this.localeProvider = null;
    }

    @Reference
    protected void setTranslationProvider(TranslationProvider i18nProvider) {
        this.i18nProvider = i18nProvider;
    }

    protected void unsetTranslationProvider(TranslationProvider i18nProvider) {
        this.i18nProvider = null;
    }
}

