/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.binding.bosesoundtouch.internal;

import java.io.IOException;
import java.io.StringReader;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.smarthome.binding.bosesoundtouch.handler.BoseSoundTouchHandler;
import org.eclipse.smarthome.binding.bosesoundtouch.internal.XMLHandlerState;
import org.eclipse.smarthome.binding.bosesoundtouch.internal.XMLResponseHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.XMLReaderFactory;

public class XMLResponseProcessor {
    private BoseSoundTouchHandler handler;
    private Map<XMLHandlerState, Map<String, XMLHandlerState>> stateSwitchingMap;

    public XMLResponseProcessor(BoseSoundTouchHandler handler) {
        this.handler = handler;
        this.init();
    }

    public void handleMessage(String msg) throws SAXException, IOException {
        XMLReader reader = XMLReaderFactory.createXMLReader();
        reader.setContentHandler(new XMLResponseHandler(this.handler, this.stateSwitchingMap));
        reader.parse(new InputSource(new StringReader(msg)));
    }

    private void init() {
        this.stateSwitchingMap = new HashMap<XMLHandlerState, Map<String, XMLHandlerState>>();
        HashMap<String, XMLHandlerState> msgInitMap = new HashMap<String, XMLHandlerState>();
        this.stateSwitchingMap.put(XMLHandlerState.INIT, msgInitMap);
        msgInitMap.put("msg", XMLHandlerState.Msg);
        msgInitMap.put("SoundTouchSdkInfo", XMLHandlerState.Unprocessed);
        msgInitMap.put("userActivityUpdate", XMLHandlerState.Unprocessed);
        HashMap<String, XMLHandlerState> msgBodyMap = new HashMap<String, XMLHandlerState>();
        this.stateSwitchingMap.put(XMLHandlerState.MsgBody, msgBodyMap);
        msgBodyMap.put("info", XMLHandlerState.Info);
        msgBodyMap.put("volume", XMLHandlerState.Volume);
        msgBodyMap.put("presets", XMLHandlerState.Presets);
        msgBodyMap.put("key", XMLHandlerState.Unprocessed);
        msgBodyMap.put("status", XMLHandlerState.Unprocessed);
        msgBodyMap.put("zone", XMLHandlerState.Zone);
        msgBodyMap.put("bass", XMLHandlerState.Bass);
        msgBodyMap.put("sources", XMLHandlerState.Sources);
        msgBodyMap.put("bassCapabilities", XMLHandlerState.BassCapabilities);
        msgBodyMap.put("group", XMLHandlerState.Group);
        HashMap<String, XMLHandlerState> infoMap = new HashMap<String, XMLHandlerState>();
        this.stateSwitchingMap.put(XMLHandlerState.Info, infoMap);
        infoMap.put("components", XMLHandlerState.Unprocessed);
        infoMap.put("name", XMLHandlerState.InfoName);
        infoMap.put("type", XMLHandlerState.InfoType);
        infoMap.put("networkInfo", XMLHandlerState.Unprocessed);
        infoMap.put("margeAccountUUID", XMLHandlerState.Unprocessed);
        infoMap.put("margeURL", XMLHandlerState.Unprocessed);
        infoMap.put("moduleType", XMLHandlerState.Unprocessed);
        infoMap.put("variant", XMLHandlerState.Unprocessed);
        infoMap.put("variantMode", XMLHandlerState.Unprocessed);
        infoMap.put("countryCode", XMLHandlerState.Unprocessed);
        infoMap.put("regionCode", XMLHandlerState.Unprocessed);
        HashMap<String, XMLHandlerState> updatesMap = new HashMap<String, XMLHandlerState>();
        this.stateSwitchingMap.put(XMLHandlerState.Updates, updatesMap);
        updatesMap.put("clockDisplayUpdated", XMLHandlerState.Unprocessed);
        updatesMap.put("connectionStateUpdated", XMLHandlerState.UnprocessedNoTextExpected);
        updatesMap.put("infoUpdated", XMLHandlerState.Unprocessed);
        updatesMap.put("nowPlayingUpdated", XMLHandlerState.MsgBody);
        updatesMap.put("nowSelectionUpdated", XMLHandlerState.Unprocessed);
        updatesMap.put("recentsUpdated", XMLHandlerState.Unprocessed);
        updatesMap.put("volumeUpdated", XMLHandlerState.MsgBody);
        updatesMap.put("zoneUpdated", XMLHandlerState.ZoneUpdated);
        updatesMap.put("bassUpdated", XMLHandlerState.BassUpdated);
        updatesMap.put("presetsUpdated", XMLHandlerState.MsgBody);
        updatesMap.put("groupUpdated", XMLHandlerState.MsgBody);
        HashMap<String, XMLHandlerState> volume = new HashMap<String, XMLHandlerState>();
        this.stateSwitchingMap.put(XMLHandlerState.Volume, volume);
        volume.put("targetvolume", XMLHandlerState.VolumeTarget);
        volume.put("actualvolume", XMLHandlerState.VolumeActual);
        volume.put("muteenabled", XMLHandlerState.VolumeMuteEnabled);
        HashMap<String, XMLHandlerState> nowPlayingMap = new HashMap<String, XMLHandlerState>();
        this.stateSwitchingMap.put(XMLHandlerState.NowPlaying, nowPlayingMap);
        nowPlayingMap.put("album", XMLHandlerState.NowPlayingAlbum);
        nowPlayingMap.put("art", XMLHandlerState.NowPlayingArt);
        nowPlayingMap.put("artist", XMLHandlerState.NowPlayingArtist);
        nowPlayingMap.put("ContentItem", XMLHandlerState.ContentItem);
        nowPlayingMap.put("description", XMLHandlerState.NowPlayingDescription);
        nowPlayingMap.put("playStatus", XMLHandlerState.NowPlayingPlayStatus);
        nowPlayingMap.put("rateEnabled", XMLHandlerState.NowPlayingRateEnabled);
        nowPlayingMap.put("skipEnabled", XMLHandlerState.NowPlayingSkipEnabled);
        nowPlayingMap.put("skipPreviousEnabled", XMLHandlerState.NowPlayingSkipPreviousEnabled);
        nowPlayingMap.put("stationLocation", XMLHandlerState.NowPlayingStationLocation);
        nowPlayingMap.put("stationName", XMLHandlerState.NowPlayingStationName);
        nowPlayingMap.put("track", XMLHandlerState.NowPlayingTrack);
        nowPlayingMap.put("connectionStatusInfo", XMLHandlerState.Unprocessed);
        nowPlayingMap.put("time", XMLHandlerState.Unprocessed);
        nowPlayingMap.put("rating", XMLHandlerState.Unprocessed);
        nowPlayingMap.put("rateEnabled", XMLHandlerState.Unprocessed);
        HashMap<String, XMLHandlerState> contentItemMap = new HashMap<String, XMLHandlerState>();
        this.stateSwitchingMap.put(XMLHandlerState.ContentItem, contentItemMap);
        contentItemMap.put("itemName", XMLHandlerState.ContentItemItemName);
        contentItemMap.put("containerArt", XMLHandlerState.ContentItemContainerArt);
        HashMap<String, XMLHandlerState> presetMap = new HashMap<String, XMLHandlerState>();
        this.stateSwitchingMap.put(XMLHandlerState.Preset, presetMap);
        presetMap.put("ContentItem", XMLHandlerState.ContentItem);
        HashMap<String, XMLHandlerState> zoneMap = new HashMap<String, XMLHandlerState>();
        this.stateSwitchingMap.put(XMLHandlerState.Zone, zoneMap);
        zoneMap.put("member", XMLHandlerState.ZoneMember);
        HashMap<String, XMLHandlerState> bassMap = new HashMap<String, XMLHandlerState>();
        this.stateSwitchingMap.put(XMLHandlerState.Bass, bassMap);
        bassMap.put("targetbass", XMLHandlerState.BassTarget);
        bassMap.put("actualbass", XMLHandlerState.BassActual);
        HashMap sourceMap = new HashMap();
        this.stateSwitchingMap.put(XMLHandlerState.Sources, sourceMap);
        HashMap<String, XMLHandlerState> bassCapabilitiesMap = new HashMap<String, XMLHandlerState>();
        this.stateSwitchingMap.put(XMLHandlerState.BassCapabilities, bassCapabilitiesMap);
        bassCapabilitiesMap.put("bassAvailable", XMLHandlerState.BassAvailable);
        bassCapabilitiesMap.put("bassMin", XMLHandlerState.BassMin);
        bassCapabilitiesMap.put("bassMax", XMLHandlerState.BassMax);
        bassCapabilitiesMap.put("bassDefault", XMLHandlerState.BassDefault);
        HashMap<String, XMLHandlerState> groupsMap = new HashMap<String, XMLHandlerState>();
        this.stateSwitchingMap.put(XMLHandlerState.Group, groupsMap);
        groupsMap.put("name", XMLHandlerState.GroupName);
        groupsMap.put("masterDeviceId", XMLHandlerState.MasterDeviceId);
        groupsMap.put("roles", XMLHandlerState.Unprocessed);
        groupsMap.put("senderIPAddress", XMLHandlerState.Unprocessed);
        groupsMap.put("status", XMLHandlerState.Unprocessed);
        groupsMap.put("roles", XMLHandlerState.Unprocessed);
        groupsMap.put("groupRole", XMLHandlerState.Unprocessed);
        groupsMap.put("deviceId", XMLHandlerState.DeviceId);
        groupsMap.put("role", XMLHandlerState.Unprocessed);
        groupsMap.put("ipAddress", XMLHandlerState.DeviceIp);
    }
}

