/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.binding.bosesoundtouch.internal;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Stack;
import org.eclipse.smarthome.binding.bosesoundtouch.BoseSoundTouchConfiguration;
import org.eclipse.smarthome.binding.bosesoundtouch.handler.BoseSoundTouchHandler;
import org.eclipse.smarthome.binding.bosesoundtouch.internal.APIRequest;
import org.eclipse.smarthome.binding.bosesoundtouch.internal.CommandExecutor;
import org.eclipse.smarthome.binding.bosesoundtouch.internal.ContentItem;
import org.eclipse.smarthome.binding.bosesoundtouch.internal.XMLHandlerState;
import org.eclipse.smarthome.core.library.types.DecimalType;
import org.eclipse.smarthome.core.library.types.OnOffType;
import org.eclipse.smarthome.core.library.types.PercentType;
import org.eclipse.smarthome.core.library.types.PlayPauseType;
import org.eclipse.smarthome.core.library.types.RawType;
import org.eclipse.smarthome.core.library.types.StringType;
import org.eclipse.smarthome.core.types.State;
import org.eclipse.smarthome.core.types.UnDefType;
import org.eclipse.smarthome.io.net.http.HttpUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class XMLResponseHandler
extends DefaultHandler {
    private final Logger logger = LoggerFactory.getLogger(XMLResponseHandler.class);
    private BoseSoundTouchHandler handler;
    private CommandExecutor commandExecutor;
    private Map<XMLHandlerState, Map<String, XMLHandlerState>> stateSwitchingMap;
    private Stack<XMLHandlerState> states;
    private XMLHandlerState state;
    private boolean msgHeaderWasValid;
    private ContentItem contentItem;
    private boolean volumeMuteEnabled;
    private OnOffType rateEnabled;
    private OnOffType skipEnabled;
    private OnOffType skipPreviousEnabled;
    private State nowPlayingSource;
    private BoseSoundTouchConfiguration masterDeviceId;
    String deviceId;
    private Map<Integer, ContentItem> playerPresets;

    public XMLResponseHandler(BoseSoundTouchHandler handler, Map<XMLHandlerState, Map<String, XMLHandlerState>> stateSwitchingMap) {
        this.handler = handler;
        this.commandExecutor = handler.getCommandExecutor();
        this.stateSwitchingMap = stateSwitchingMap;
        this.init();
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        super.startElement(uri, localName, qName, attributes);
        this.logger.trace("{}: startElement('{}'; state: {})", new Object[]{this.handler.getDeviceName(), localName, this.state});
        this.states.push(this.state);
        XMLHandlerState curState = this.state;
        Map<String, XMLHandlerState> stateMap = this.stateSwitchingMap.get((Object)this.state);
        this.state = XMLHandlerState.Unprocessed;
        switch (curState) {
            case INIT: {
                if ("updates".equals(localName)) {
                    if (this.checkDeviceId(localName, attributes, false)) {
                        this.state = XMLHandlerState.Updates;
                        break;
                    }
                    this.state = XMLHandlerState.Unprocessed;
                    break;
                }
                this.state = stateMap.get(localName);
                if (this.state != null) break;
                if (this.logger.isDebugEnabled()) {
                    this.logger.warn("{}: Unhandled XML entity during {}: '{}", new Object[]{this.handler.getDeviceName(), curState, localName});
                }
                this.state = XMLHandlerState.Unprocessed;
                break;
            }
            case Msg: {
                if ("header".equals(localName)) {
                    if (this.checkDeviceId(localName, attributes, false)) {
                        this.state = XMLHandlerState.MsgHeader;
                        this.msgHeaderWasValid = true;
                        break;
                    }
                    this.state = XMLHandlerState.Unprocessed;
                    break;
                }
                if ("body".equals(localName)) {
                    if (this.msgHeaderWasValid) {
                        this.state = XMLHandlerState.MsgBody;
                        break;
                    }
                    this.state = XMLHandlerState.Unprocessed;
                    break;
                }
                if (this.logger.isDebugEnabled()) {
                    this.logger.warn("{}: Unhandled XML entity during {}: '{}'", new Object[]{this.handler.getDeviceName(), curState, localName});
                }
                this.state = XMLHandlerState.Unprocessed;
                break;
            }
            case MsgHeader: {
                if ("request".equals(localName)) {
                    this.state = XMLHandlerState.Unprocessed;
                    break;
                }
                if (this.logger.isDebugEnabled()) {
                    this.logger.warn("{}: Unhandled XML entity during {}: '{}'", new Object[]{this.handler.getDeviceName(), curState, localName});
                }
                this.state = XMLHandlerState.Unprocessed;
                break;
            }
            case MsgBody: {
                String source;
                if ("nowPlaying".equals(localName)) {
                    this.rateEnabled = OnOffType.OFF;
                    this.skipEnabled = OnOffType.OFF;
                    this.skipPreviousEnabled = OnOffType.OFF;
                    this.state = XMLHandlerState.NowPlaying;
                    source = attributes.getValue("source");
                    if (this.nowPlayingSource != null && this.nowPlayingSource.toString().equals(source)) break;
                    this.nowPlayingSource = new StringType(source);
                    this.updateRateEnabled(OnOffType.OFF);
                    this.updateSkipEnabled(OnOffType.OFF);
                    this.updateSkipPreviousEnabled(OnOffType.OFF);
                    this.updateNowPlayingAlbum((State)UnDefType.NULL);
                    this.updateNowPlayingArtwork((State)UnDefType.NULL);
                    this.updateNowPlayingArtist((State)UnDefType.NULL);
                    this.updateNowPlayingDescription((State)UnDefType.NULL);
                    this.updateNowPlayingGenre((State)UnDefType.NULL);
                    this.updateNowPlayingItemName((State)UnDefType.NULL);
                    this.updateNowPlayingStationLocation((State)UnDefType.NULL);
                    this.updateNowPlayingStationName((State)UnDefType.NULL);
                    this.updateNowPlayingTrack((State)UnDefType.NULL);
                    break;
                }
                if ("zone".equals(localName)) {
                    this.state = XMLHandlerState.Zone;
                    break;
                }
                if ("presets".equals(localName)) {
                    this.playerPresets = new HashMap<Integer, ContentItem>();
                    int i = 1;
                    while (i <= 6) {
                        this.playerPresets.put(i, null);
                        ++i;
                    }
                    this.state = XMLHandlerState.Presets;
                    break;
                }
                if ("group".equals(localName)) {
                    this.masterDeviceId = new BoseSoundTouchConfiguration();
                    this.state = stateMap.get(localName);
                    break;
                }
                this.state = stateMap.get(localName);
                if (this.state == null) {
                    if (this.logger.isDebugEnabled()) {
                        this.logger.warn("{}: Unhandled XML entity during {}: '{}", new Object[]{this.handler.getDeviceName(), curState, localName});
                    }
                    this.state = XMLHandlerState.Unprocessed;
                    break;
                }
                if (this.state == XMLHandlerState.Volume || this.state == XMLHandlerState.Presets || this.state == XMLHandlerState.Group || this.state == XMLHandlerState.Unprocessed || this.checkDeviceId(localName, attributes, false)) break;
                this.state = XMLHandlerState.Unprocessed;
                break;
            }
            case Presets: {
                if ("preset".equals(localName)) {
                    this.state = XMLHandlerState.Preset;
                    String id = attributes.getValue("id");
                    if (this.contentItem == null) {
                        this.contentItem = new ContentItem();
                    }
                    this.contentItem.setPresetID(Integer.parseInt(id));
                    break;
                }
                if (this.logger.isDebugEnabled()) {
                    this.logger.warn("{}: Unhandled XML entity during {}: '{}'", new Object[]{this.handler.getDeviceName(), curState, localName});
                }
                this.state = XMLHandlerState.Unprocessed;
                break;
            }
            case Sources: {
                String source;
                if ("sourceItem".equals(localName)) {
                    this.state = XMLHandlerState.Unprocessed;
                    source = attributes.getValue("source");
                    String sourceAccount = attributes.getValue("sourceAccount");
                    String status = attributes.getValue("status");
                    if (!status.equals("READY")) break;
                    if (source.equals("AUX")) {
                        if (sourceAccount.equals("AUX")) {
                            this.commandExecutor.setAUXAvailable(true);
                        }
                        if (sourceAccount.equals("AUX1")) {
                            this.commandExecutor.setAUX1Available(true);
                        }
                        if (sourceAccount.equals("AUX2")) {
                            this.commandExecutor.setAUX2Available(true);
                        }
                        if (sourceAccount.equals("AUX3")) {
                            this.commandExecutor.setAUX3Available(true);
                        }
                    }
                    if (source.equals("STORED_MUSIC")) {
                        this.commandExecutor.setStoredMusicAvailable(true);
                    }
                    if (source.equals("INTERNET_RADIO")) {
                        this.commandExecutor.setInternetRadioAvailable(true);
                    }
                    if (source.equals("BLUETOOTH")) {
                        this.commandExecutor.setBluetoothAvailable(true);
                    }
                    if (!source.equals("PRODUCT")) break;
                    if (sourceAccount.equals("TV")) {
                        this.commandExecutor.setTVAvailable(true);
                    }
                    if (!sourceAccount.equals("HDMI_1")) break;
                    this.commandExecutor.setHDMI1Available(true);
                    break;
                }
                if (this.logger.isDebugEnabled()) {
                    this.logger.warn("{}: Unhandled XML entity during {}: '{}'", new Object[]{this.handler.getDeviceName(), curState, localName});
                }
                this.state = XMLHandlerState.Unprocessed;
                break;
            }
            case Bass: 
            case ContentItem: 
            case Group: 
            case GroupName: 
            case Info: 
            case Preset: 
            case MasterDeviceId: 
            case DeviceId: 
            case DeviceIp: 
            case NowPlaying: 
            case Updates: 
            case Volume: 
            case Zone: 
            case BassCapabilities: {
                this.state = this.nextState(stateMap, curState, localName);
                break;
            }
            case BassActual: 
            case BassTarget: 
            case BassUpdated: 
            case BassMin: 
            case BassMax: 
            case BassDefault: 
            case ContentItemItemName: 
            case ContentItemContainerArt: 
            case InfoName: 
            case InfoType: 
            case NowPlayingAlbum: 
            case NowPlayingArt: 
            case NowPlayingArtist: 
            case NowPlayingDescription: 
            case NowPlayingGenre: 
            case NowPlayingPlayStatus: 
            case NowPlayingRateEnabled: 
            case NowPlayingSkipEnabled: 
            case NowPlayingSkipPreviousEnabled: 
            case NowPlayingStationLocation: 
            case NowPlayingStationName: 
            case NowPlayingTrack: 
            case VolumeActual: 
            case VolumeTarget: 
            case VolumeUpdated: 
            case VolumeMuteEnabled: 
            case ZoneMember: 
            case ZoneUpdated: {
                if (this.logger.isDebugEnabled()) {
                    this.logger.warn("{}: Unhandled XML entity during {}: '{}'", new Object[]{this.handler.getDeviceName(), curState, localName});
                }
                this.state = XMLHandlerState.Unprocessed;
                break;
            }
            case BassAvailable: {
                if (this.logger.isDebugEnabled()) {
                    this.logger.warn("{}: Unhandled XML entity during {}: '{}'", new Object[]{this.handler.getDeviceName(), curState, localName});
                }
                this.state = XMLHandlerState.Unprocessed;
                break;
            }
            case Unprocessed: {
                this.state = XMLHandlerState.Unprocessed;
                break;
            }
            case UnprocessedNoTextExpected: {
                this.state = XMLHandlerState.UnprocessedNoTextExpected;
            }
        }
        if (this.state == XMLHandlerState.ContentItem) {
            if (this.contentItem == null) {
                this.contentItem = new ContentItem();
            }
            this.contentItem.setSource(attributes.getValue("source"));
            this.contentItem.setSourceAccount(attributes.getValue("sourceAccount"));
            this.contentItem.setLocation(attributes.getValue("location"));
            this.contentItem.setPresetable(Boolean.parseBoolean(attributes.getValue("isPresetable")));
            int attrId = 0;
            while (attrId < attributes.getLength()) {
                String attrName = attributes.getLocalName(attrId);
                if (!("source".equalsIgnoreCase(attrName) || "location".equalsIgnoreCase(attrName) || "sourceAccount".equalsIgnoreCase(attrName) || "isPresetable".equalsIgnoreCase(attrName))) {
                    this.contentItem.setAdditionalAttribute(attrName, attributes.getValue(attrId));
                }
                ++attrId;
            }
        }
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        super.endElement(uri, localName, qName);
        this.logger.trace("{}: endElement('{}')", (Object)this.handler.getDeviceName(), (Object)localName);
        XMLHandlerState prevState = this.state;
        this.state = this.states.pop();
        switch (prevState) {
            case Info: {
                this.commandExecutor.getInformations(APIRequest.VOLUME);
                this.commandExecutor.getInformations(APIRequest.PRESETS);
                this.commandExecutor.getInformations(APIRequest.NOW_PLAYING);
                this.commandExecutor.getInformations(APIRequest.GET_ZONE);
                this.commandExecutor.getInformations(APIRequest.BASS);
                this.commandExecutor.getInformations(APIRequest.SOURCES);
                this.commandExecutor.getInformations(APIRequest.BASSCAPABILITIES);
                this.commandExecutor.getInformations(APIRequest.GET_GROUP);
                break;
            }
            case ContentItem: {
                if (this.state != XMLHandlerState.NowPlaying) break;
                this.updateNowPlayingItemName((State)new StringType(this.contentItem.getItemName()));
                this.commandExecutor.setCurrentContentItem(this.contentItem);
                break;
            }
            case Preset: {
                if (this.state != XMLHandlerState.Presets) break;
                this.playerPresets.put(this.contentItem.getPresetID(), this.contentItem);
                this.contentItem = null;
                break;
            }
            case NowPlaying: {
                if (this.state != XMLHandlerState.MsgBody) break;
                this.updateRateEnabled(this.rateEnabled);
                this.updateSkipEnabled(this.skipEnabled);
                this.updateSkipPreviousEnabled(this.skipPreviousEnabled);
                break;
            }
            case BassUpdated: {
                this.commandExecutor.getInformations(APIRequest.BASS);
                break;
            }
            case VolumeUpdated: {
                this.commandExecutor.getInformations(APIRequest.VOLUME);
                break;
            }
            case NowPlayingRateEnabled: {
                this.rateEnabled = OnOffType.ON;
                break;
            }
            case NowPlayingSkipEnabled: {
                this.skipEnabled = OnOffType.ON;
                break;
            }
            case NowPlayingSkipPreviousEnabled: {
                this.skipPreviousEnabled = OnOffType.ON;
                break;
            }
            case Volume: {
                OnOffType muted = this.volumeMuteEnabled ? OnOffType.ON : OnOffType.OFF;
                this.commandExecutor.setCurrentMuted(this.volumeMuteEnabled);
                this.commandExecutor.postVolumeMuted(muted);
                break;
            }
            case ZoneUpdated: {
                this.commandExecutor.getInformations(APIRequest.GET_ZONE);
                break;
            }
            case Presets: {
                this.commandExecutor.updatePresetContainerFromPlayer(this.playerPresets);
                this.playerPresets = null;
                break;
            }
            case Group: {
                this.handler.handleGroupUpdated(this.masterDeviceId);
                break;
            }
        }
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        this.logger.trace("{}: Text data during {}: '{}'", new Object[]{this.handler.getDeviceName(), this.state, new String(ch, start, length)});
        super.characters(ch, start, length);
        switch (this.state) {
            case INIT: 
            case Msg: 
            case MsgHeader: 
            case MsgBody: 
            case Bass: 
            case BassUpdated: 
            case ContentItem: 
            case Info: 
            case Presets: 
            case Preset: 
            case NowPlaying: 
            case NowPlayingRateEnabled: 
            case NowPlayingSkipEnabled: 
            case NowPlayingSkipPreviousEnabled: 
            case UnprocessedNoTextExpected: 
            case Updates: 
            case Volume: 
            case VolumeUpdated: 
            case Zone: 
            case ZoneUpdated: 
            case Sources: {
                this.logger.debug("{}: Unexpected text data during {}: '{}'", new Object[]{this.handler.getDeviceName(), this.state, new String(ch, start, length)});
                break;
            }
            case BassTarget: 
            case BassMin: 
            case BassMax: 
            case BassDefault: 
            case VolumeTarget: {
                break;
            }
            case BassCapabilities: {
                this.logger.debug("{}: Unexpected text data during {}: '{}'", new Object[]{this.handler.getDeviceName(), this.state, new String(ch, start, length)});
                break;
            }
            case Unprocessed: {
                break;
            }
            case BassActual: {
                this.commandExecutor.updateBassLevelGUIState(new DecimalType(new String(ch, start, length)));
                break;
            }
            case InfoName: {
                this.setConfigOption("INFO_NAME", new String(ch, start, length));
                break;
            }
            case InfoType: {
                this.setConfigOption("INFO_TYPE", new String(ch, start, length));
                break;
            }
            case BassAvailable: {
                boolean bassAvailable = Boolean.parseBoolean(new String(ch, start, length));
                this.commandExecutor.setBassAvailable(bassAvailable);
                break;
            }
            case NowPlayingAlbum: {
                this.updateNowPlayingAlbum((State)new StringType(new String(ch, start, length)));
                break;
            }
            case NowPlayingArt: {
                String url = new String(ch, start, length);
                if (url.startsWith("http")) {
                    this.handler.getScheduler().submit(() -> {
                        RawType image = HttpUtil.downloadImage((String)url, (boolean)true, (long)500000L);
                        if (image != null) {
                            this.updateNowPlayingArtwork((State)image);
                        } else {
                            this.updateNowPlayingArtwork((State)UnDefType.UNDEF);
                        }
                    });
                    break;
                }
                this.updateNowPlayingArtwork((State)UnDefType.UNDEF);
                break;
            }
            case NowPlayingArtist: {
                this.updateNowPlayingArtist((State)new StringType(new String(ch, start, length)));
                break;
            }
            case ContentItemItemName: {
                this.contentItem.setItemName(new String(ch, start, length));
                break;
            }
            case ContentItemContainerArt: {
                this.contentItem.setContainerArt(new String(ch, start, length));
                break;
            }
            case NowPlayingDescription: {
                this.updateNowPlayingDescription((State)new StringType(new String(ch, start, length)));
                break;
            }
            case NowPlayingGenre: {
                this.updateNowPlayingGenre((State)new StringType(new String(ch, start, length)));
                break;
            }
            case NowPlayingPlayStatus: {
                String playPauseState = new String(ch, start, length);
                if ("PLAY_STATE".equals(playPauseState) || "BUFFERING_STATE".equals(playPauseState)) {
                    this.commandExecutor.updatePlayerControlGUIState((State)PlayPauseType.PLAY);
                    break;
                }
                if (!"STOP_STATE".equals(playPauseState) && !"PAUSE_STATE".equals(playPauseState)) break;
                this.commandExecutor.updatePlayerControlGUIState((State)PlayPauseType.PAUSE);
                break;
            }
            case NowPlayingStationLocation: {
                this.updateNowPlayingStationLocation((State)new StringType(new String(ch, start, length)));
                break;
            }
            case NowPlayingStationName: {
                this.updateNowPlayingStationName((State)new StringType(new String(ch, start, length)));
                break;
            }
            case NowPlayingTrack: {
                this.updateNowPlayingTrack((State)new StringType(new String(ch, start, length)));
                break;
            }
            case VolumeActual: {
                this.commandExecutor.updateVolumeGUIState(new PercentType(Integer.parseInt(new String(ch, start, length))));
                break;
            }
            case VolumeMuteEnabled: {
                this.volumeMuteEnabled = Boolean.parseBoolean(new String(ch, start, length));
                this.commandExecutor.setCurrentMuted(this.volumeMuteEnabled);
                break;
            }
            case MasterDeviceId: {
                if (this.masterDeviceId == null) break;
                this.masterDeviceId.macAddress = new String(ch, start, length);
                break;
            }
            case GroupName: {
                if (this.masterDeviceId == null) break;
                this.masterDeviceId.groupName = new String(ch, start, length);
                break;
            }
            case DeviceId: {
                this.deviceId = new String(ch, start, length);
                break;
            }
            case DeviceIp: {
                if (this.masterDeviceId == null || !Objects.equals(this.masterDeviceId.macAddress, this.deviceId)) break;
                this.masterDeviceId.host = new String(ch, start, length);
                break;
            }
        }
    }

    @Override
    public void skippedEntity(String name) throws SAXException {
        super.skippedEntity(name);
    }

    private boolean checkDeviceId(String localName, Attributes attributes, boolean allowFromMaster) {
        String deviceID = attributes.getValue("deviceID");
        if (deviceID == null) {
            this.logger.warn("{}: No device-ID in entity {}", (Object)this.handler.getDeviceName(), (Object)localName);
            return false;
        }
        if (deviceID.equals(this.handler.getMacAddress())) {
            return true;
        }
        this.logger.warn("{}: Wrong device-ID in entity '{}': Got: '{}', expected: '{}'", new Object[]{this.handler.getDeviceName(), localName, deviceID, this.handler.getMacAddress()});
        return false;
    }

    private void init() {
        this.states = new Stack();
        this.state = XMLHandlerState.INIT;
        this.nowPlayingSource = null;
    }

    private XMLHandlerState nextState(Map<String, XMLHandlerState> stateMap, XMLHandlerState curState, String localName) {
        XMLHandlerState state = stateMap.get(localName);
        if (state == null) {
            if (this.logger.isDebugEnabled()) {
                this.logger.warn("{}: Unhandled XML entity during {}: '{}'", new Object[]{this.handler.getDeviceName(), curState, localName});
            }
            state = XMLHandlerState.Unprocessed;
        }
        return state;
    }

    private void setConfigOption(String option, String value) {
        Map prop = this.handler.getThing().getProperties();
        String cur = (String)prop.get(option);
        if (cur == null || !cur.equals(value)) {
            this.logger.debug("{}: Option '{}' updated: From '{}' to '{}'", new Object[]{this.handler.getDeviceName(), option, cur, value});
            this.handler.getThing().setProperty(option, value);
        }
    }

    private void updateNowPlayingAlbum(State state) {
        this.handler.updateState("nowPlayingAlbum", state);
    }

    private void updateNowPlayingArtwork(State state) {
        this.handler.updateState("nowPlayingArtwork", state);
    }

    private void updateNowPlayingArtist(State state) {
        this.handler.updateState("nowPlayingArtist", state);
    }

    private void updateNowPlayingDescription(State state) {
        this.handler.updateState("nowPlayingDescription", state);
    }

    private void updateNowPlayingGenre(State state) {
        this.handler.updateState("nowPlayingGenre", state);
    }

    private void updateNowPlayingItemName(State state) {
        this.handler.updateState("nowPlayingItemName", state);
    }

    private void updateNowPlayingStationLocation(State state) {
        this.handler.updateState("nowPlayingStationLocation", state);
    }

    private void updateNowPlayingStationName(State state) {
        this.handler.updateState("nowPlayingStationName", state);
    }

    private void updateNowPlayingTrack(State state) {
        this.handler.updateState("nowPlayingTrack", state);
    }

    private void updateRateEnabled(OnOffType state) {
        this.handler.updateState("rateEnabled", (State)state);
    }

    private void updateSkipEnabled(OnOffType state) {
        this.handler.updateState("skipEnabled", (State)state);
    }

    private void updateSkipPreviousEnabled(OnOffType state) {
        this.handler.updateState("skipPreviousEnabled", (State)state);
    }
}

