/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.binding.bosesoundtouch.handler;

import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.eclipse.jetty.websocket.api.Session;
import org.eclipse.jetty.websocket.api.WebSocketFrameListener;
import org.eclipse.jetty.websocket.api.WebSocketListener;
import org.eclipse.jetty.websocket.api.extensions.Frame;
import org.eclipse.jetty.websocket.client.ClientUpgradeRequest;
import org.eclipse.jetty.websocket.client.WebSocketClient;
import org.eclipse.smarthome.binding.bosesoundtouch.BoseSoundTouchBindingConstants;
import org.eclipse.smarthome.binding.bosesoundtouch.BoseSoundTouchConfiguration;
import org.eclipse.smarthome.binding.bosesoundtouch.internal.APIRequest;
import org.eclipse.smarthome.binding.bosesoundtouch.internal.BoseSoundTouchNotificationChannelConfiguration;
import org.eclipse.smarthome.binding.bosesoundtouch.internal.BoseStateDescriptionOptionProvider;
import org.eclipse.smarthome.binding.bosesoundtouch.internal.CommandExecutor;
import org.eclipse.smarthome.binding.bosesoundtouch.internal.OperationModeType;
import org.eclipse.smarthome.binding.bosesoundtouch.internal.PresetContainer;
import org.eclipse.smarthome.binding.bosesoundtouch.internal.RemoteKeyType;
import org.eclipse.smarthome.binding.bosesoundtouch.internal.XMLResponseProcessor;
import org.eclipse.smarthome.core.library.types.DecimalType;
import org.eclipse.smarthome.core.library.types.NextPreviousType;
import org.eclipse.smarthome.core.library.types.OnOffType;
import org.eclipse.smarthome.core.library.types.PercentType;
import org.eclipse.smarthome.core.library.types.PlayPauseType;
import org.eclipse.smarthome.core.library.types.StringType;
import org.eclipse.smarthome.core.thing.Channel;
import org.eclipse.smarthome.core.thing.ChannelUID;
import org.eclipse.smarthome.core.thing.Thing;
import org.eclipse.smarthome.core.thing.ThingStatus;
import org.eclipse.smarthome.core.thing.ThingStatusDetail;
import org.eclipse.smarthome.core.thing.binding.BaseThingHandler;
import org.eclipse.smarthome.core.thing.type.ChannelTypeUID;
import org.eclipse.smarthome.core.types.Command;
import org.eclipse.smarthome.core.types.RefreshType;
import org.eclipse.smarthome.core.types.State;
import org.eclipse.smarthome.core.types.StateOption;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BoseSoundTouchHandler
extends BaseThingHandler
implements WebSocketListener,
WebSocketFrameListener {
    private static final int MAX_MISSED_PONGS_COUNT = 2;
    private static final int RETRY_INTERVAL_IN_SECS = 30;
    private final Logger logger = LoggerFactory.getLogger(BoseSoundTouchHandler.class);
    private ScheduledFuture<?> connectionChecker;
    private WebSocketClient client;
    private volatile Session session;
    private volatile CommandExecutor commandExecutor;
    private volatile int missedPongsCount = 0;
    private XMLResponseProcessor xmlResponseProcessor;
    private PresetContainer presetContainer;
    private BoseStateDescriptionOptionProvider stateOptionProvider;

    public BoseSoundTouchHandler(Thing thing, PresetContainer presetContainer, BoseStateDescriptionOptionProvider stateOptionProvider) {
        super(thing);
        this.presetContainer = presetContainer;
        this.stateOptionProvider = stateOptionProvider;
        this.xmlResponseProcessor = new XMLResponseProcessor(this);
    }

    public void initialize() {
        this.connectionChecker = this.scheduler.scheduleWithFixedDelay(() -> this.checkConnection(), 0L, 30L, TimeUnit.SECONDS);
    }

    public void dispose() {
        if (this.connectionChecker != null && !this.connectionChecker.isCancelled()) {
            this.connectionChecker.cancel(true);
            this.connectionChecker = null;
        }
        this.closeConnection();
        super.dispose();
    }

    public void handleRemoval() {
        this.presetContainer.clear();
        super.handleRemoval();
    }

    public void updateState(String channelID, State state) {
        if (this.isLinked(channelID)) {
            super.updateState(channelID, state);
        } else {
            this.logger.debug("{}: Skipping state update because of not linked channel '{}'", (Object)this.getDeviceName(), (Object)channelID);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void handleCommand(ChannelUID channelUID, Command command) {
        ChannelTypeUID chTypeUid;
        if (this.commandExecutor == null) {
            this.logger.debug("{}: Can't handle command '{}' for channel '{}' because of not initialized connection.", new Object[]{this.getDeviceName(), command, channelUID});
            return;
        }
        this.logger.debug("{}: handleCommand({}, {});", new Object[]{this.getDeviceName(), channelUID, command});
        if (command.equals(RefreshType.REFRESH)) {
            switch (channelUID.getIdWithoutGroup()) {
                case "bass": {
                    this.commandExecutor.getInformations(APIRequest.BASS);
                    return;
                }
                case "nowPlayingArtwork": 
                case "nowPlayingItemName": 
                case "nowPlayingArtist": 
                case "nowPlayingStationName": 
                case "rateEnabled": 
                case "nowPlayingDescription": 
                case "skipPreviousEnabled": 
                case "skipEnabled": 
                case "nowPlayingAlbum": 
                case "nowPlayingGenre": 
                case "nowPlayingTrack": 
                case "nowPlayingStationLocation": {
                    this.commandExecutor.getInformations(APIRequest.NOW_PLAYING);
                    return;
                }
                case "volume": {
                    this.commandExecutor.getInformations(APIRequest.VOLUME);
                    return;
                }
                default: {
                    this.logger.debug("{} : Got command '{}' for channel '{}' which is unhandled!", new Object[]{this.getDeviceName(), command, channelUID.getId()});
                    return;
                }
                case "keyCode": 
            }
            return;
        }
        switch (channelUID.getIdWithoutGroup()) {
            case "power": {
                if (command instanceof OnOffType) {
                    this.commandExecutor.postPower((OnOffType)command);
                    return;
                }
                this.logger.debug("{}: Unhandled command type: {}: {}", new Object[]{this.getDeviceName(), command.getClass(), command});
                return;
            }
            case "volume": {
                if (command instanceof PercentType) {
                    this.commandExecutor.postVolume((PercentType)command);
                    return;
                }
                this.logger.debug("{}: Unhandled command type: {}: {}", new Object[]{this.getDeviceName(), command.getClass(), command});
                return;
            }
            case "mute": {
                if (command instanceof OnOffType) {
                    this.commandExecutor.postVolumeMuted((OnOffType)command);
                    return;
                }
                this.logger.debug("{}: Unhandled command type: {}: {}", new Object[]{this.getDeviceName(), command.getClass(), command});
                return;
            }
            case "operationMode": {
                if (!(command instanceof StringType)) return;
                String cmd = command.toString().toUpperCase().trim();
                try {
                    OperationModeType mode = OperationModeType.valueOf(cmd);
                    this.commandExecutor.postOperationMode(mode);
                    return;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    this.logger.warn("{}: OperationMode \"{}\" is not valid!", (Object)this.getDeviceName(), (Object)cmd);
                    return;
                }
            }
            case "playerControl": {
                if (!(command instanceof PlayPauseType) && !(command instanceof NextPreviousType)) {
                    this.logger.debug("{}: Unhandled command type: {}: {}", new Object[]{this.getDeviceName(), command.getClass(), command});
                    return;
                }
                this.commandExecutor.postPlayerControl(command);
                return;
            }
            case "preset": {
                if (command instanceof DecimalType) {
                    this.commandExecutor.postPreset((DecimalType)command);
                    return;
                }
                this.logger.debug("{}: Unhandled command type: {}: {}", new Object[]{this.getDeviceName(), command.getClass(), command});
                return;
            }
            case "bass": {
                if (command instanceof DecimalType) {
                    this.commandExecutor.postBass((DecimalType)command);
                    return;
                }
                this.logger.debug("{}: Unhandled command type: {}: {}", new Object[]{this.getDeviceName(), command.getClass(), command});
                return;
            }
            case "saveAsPreset": {
                if (command instanceof DecimalType) {
                    this.commandExecutor.addCurrentContentItemToPresetContainer((DecimalType)command);
                    return;
                }
                this.logger.debug("{}: Unhandled command type: {}: {}", new Object[]{this.getDeviceName(), command.getClass(), command});
                return;
            }
            case "keyCode": {
                if (!(command instanceof StringType)) return;
                String cmd = command.toString().toUpperCase().trim();
                try {
                    RemoteKeyType keyCommand = RemoteKeyType.valueOf(cmd);
                    this.commandExecutor.postRemoteKey(keyCommand);
                    return;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    this.logger.debug("{}: Unhandled remote key: {}", (Object)this.getDeviceName(), (Object)cmd);
                    return;
                }
            }
        }
        Channel channel = this.getThing().getChannel(channelUID.getId());
        if (channel != null && (chTypeUid = channel.getChannelTypeUID()) != null) {
            switch (channel.getChannelTypeUID().getId()) {
                case "notificationsound": {
                    String appKey = Objects.toString(this.getConfig().get("appKey"), null);
                    if (appKey != null && !appKey.isEmpty()) {
                        if (!(command instanceof StringType)) return;
                        String url = command.toString();
                        BoseSoundTouchNotificationChannelConfiguration notificationConfiguration = (BoseSoundTouchNotificationChannelConfiguration)channel.getConfiguration().as(BoseSoundTouchNotificationChannelConfiguration.class);
                        if (url.isEmpty()) return;
                        this.commandExecutor.playNotificationSound(appKey, notificationConfiguration, url);
                        return;
                    }
                    this.logger.warn("Missing app key - cannot use notification api");
                    return;
                }
            }
        }
        this.logger.warn("{} : Got command '{}' for channel '{}' which is unhandled!", new Object[]{this.getDeviceName(), command, channelUID.getId()});
    }

    public CommandExecutor getCommandExecutor() {
        return this.commandExecutor;
    }

    public Session getSession() {
        return this.session;
    }

    public String getDeviceName() {
        return (String)this.getThing().getProperties().get("INFO_NAME");
    }

    public String getDeviceType() {
        return (String)this.getThing().getProperties().get("INFO_TYPE");
    }

    public String getMacAddress() {
        return ((String)this.getThing().getConfiguration().get("macAddress")).replaceAll(":", "");
    }

    public String getIPAddress() {
        return (String)this.getThing().getConfiguration().getProperties().get("host");
    }

    public ScheduledExecutorService getScheduler() {
        return this.scheduler;
    }

    public PresetContainer getPresetContainer() {
        return this.presetContainer;
    }

    public void onWebSocketConnect(Session session) {
        this.logger.debug("{}: onWebSocketConnect('{}')", (Object)this.getDeviceName(), (Object)session);
        this.session = session;
        this.commandExecutor = new CommandExecutor(this);
        this.updateStatus(ThingStatus.ONLINE);
    }

    public void onWebSocketError(Throwable e) {
        this.logger.debug("{}: Error during websocket communication: {}", new Object[]{this.getDeviceName(), e.getMessage(), e});
        this.updateStatus(ThingStatus.OFFLINE, ThingStatusDetail.COMMUNICATION_ERROR, e.getMessage());
        if (this.commandExecutor != null) {
            this.commandExecutor.postOperationMode(OperationModeType.OFFLINE);
            this.commandExecutor = null;
        }
        if (this.session != null) {
            this.session.close(1011, String.valueOf(this.getDeviceName()) + ": Failure: " + e.getMessage());
            this.session = null;
        }
    }

    public void onWebSocketText(String msg) {
        this.logger.debug("{}: onWebSocketText('{}')", (Object)this.getDeviceName(), (Object)msg);
        try {
            this.xmlResponseProcessor.handleMessage(msg);
        }
        catch (Exception e) {
            this.logger.warn("{}: Could not parse XML from string '{}'.", new Object[]{this.getDeviceName(), msg, e});
        }
    }

    public void onWebSocketBinary(byte[] arr, int pos, int len) {
        this.logger.debug("{}: onWebSocketBinary({}, {}, '{}')", new Object[]{this.getDeviceName(), pos, len, Arrays.toString(arr)});
    }

    public void onWebSocketClose(int code, String reason) {
        this.logger.debug("{}: onClose({}, '{}')", new Object[]{this.getDeviceName(), code, reason});
        this.missedPongsCount = 0;
        this.updateStatus(ThingStatus.OFFLINE, ThingStatusDetail.COMMUNICATION_ERROR, reason);
        if (this.commandExecutor != null) {
            this.commandExecutor.postOperationMode(OperationModeType.OFFLINE);
        }
    }

    public void onWebSocketFrame(Frame frame) {
        if (frame.getType() == Frame.Type.PONG) {
            this.missedPongsCount = 0;
        }
    }

    private synchronized void openConnection() {
        this.closeConnection();
        try {
            this.client = new WebSocketClient();
            this.client.setMaxIdleTimeout(360000L);
            String wsUrl = "ws://" + this.getIPAddress() + ":8080/";
            this.logger.debug("{}: Connecting to: {}", (Object)this.getDeviceName(), (Object)wsUrl);
            ClientUpgradeRequest request = new ClientUpgradeRequest();
            request.setSubProtocols(new String[]{"gabbo"});
            this.client.setStopTimeout(1000L);
            this.client.start();
            this.client.connect((Object)this, new URI(wsUrl), request);
        }
        catch (Exception e) {
            this.onWebSocketError(e);
        }
    }

    private synchronized void closeConnection() {
        if (this.session != null) {
            try {
                this.session.close(1000, "Binding shutdown");
            }
            catch (Exception e) {
                this.logger.debug("{}: Error while closing websocket communication: {} ({})", new Object[]{this.getDeviceName(), e.getClass().getName(), e.getMessage()});
            }
            this.session = null;
        }
        if (this.client != null) {
            try {
                this.client.stop();
                this.client.destroy();
            }
            catch (Exception e) {
                this.logger.debug("{}: Error while closing websocket communication: {} ({})", new Object[]{this.getDeviceName(), e.getClass().getName(), e.getMessage()});
            }
            this.client = null;
        }
        this.commandExecutor = null;
    }

    private void checkConnection() {
        if (this.getThing().getStatus() != ThingStatus.ONLINE || this.session == null || this.client == null || this.commandExecutor == null) {
            this.openConnection();
        }
        if (this.getThing().getStatus() == ThingStatus.ONLINE && this.session != null && this.session.isOpen()) {
            try {
                this.session.getRemote().sendPing(null);
                ++this.missedPongsCount;
            }
            catch (IOException | NullPointerException e) {
                this.onWebSocketError(e);
                this.closeConnection();
                this.openConnection();
            }
            if (this.missedPongsCount >= 2) {
                this.logger.debug("{}: Closing connection because of too many missed PONGs: {} (max allowed {}) ", new Object[]{this.getDeviceName(), this.missedPongsCount, 2});
                this.missedPongsCount = 0;
                this.closeConnection();
                this.openConnection();
            }
        }
    }

    public void refreshPresetChannel() {
        List<StateOption> stateOptions = this.presetContainer.getAllPresets().stream().map(e -> e.toStateOption()).sorted(Comparator.comparing(StateOption::getValue)).collect(Collectors.toList());
        this.stateOptionProvider.setStateOptions(new ChannelUID(this.getThing().getUID(), "preset"), stateOptions);
    }

    public void handleGroupUpdated(BoseSoundTouchConfiguration masterPlayerConfiguration) {
        String deviceId = this.getMacAddress();
        if (masterPlayerConfiguration != null && masterPlayerConfiguration.macAddress != null) {
            if (Objects.equals(masterPlayerConfiguration.macAddress, deviceId)) {
                if (this.getThing().getThingTypeUID().equals((Object)BoseSoundTouchBindingConstants.BST_10_THING_TYPE_UID)) {
                    this.logger.debug("{}: Stereo Pair was created and this is the master device.", (Object)this.getDeviceName());
                } else {
                    this.logger.debug("{}: Unsupported operation for player of type: {}", (Object)this.getDeviceName(), (Object)this.getThing().getThingTypeUID());
                }
            } else if (this.getThing().getThingTypeUID().equals((Object)BoseSoundTouchBindingConstants.BST_10_THING_TYPE_UID)) {
                this.logger.debug("{}: Stereo Pair was created and this is NOT the master device.", (Object)this.getDeviceName());
                this.updateThing(this.editThing().withChannels(Collections.emptyList()).build());
            } else {
                this.logger.debug("{}: Unsupported operation for player of type: {}", (Object)this.getDeviceName(), (Object)this.getThing().getThingTypeUID());
            }
        } else if (this.getThing().getThingTypeUID().equals((Object)BoseSoundTouchBindingConstants.BST_10_THING_TYPE_UID)) {
            if (this.getThing().getChannels().isEmpty()) {
                this.logger.debug("{}: Stereo Pair was disbounded. Restoring channels", (Object)this.getDeviceName());
                this.updateThing(this.editThing().withChannels(this.getAllChannels()).build());
            } else {
                this.logger.debug("{}: Stereo Pair was disbounded.", (Object)this.getDeviceName());
            }
        } else {
            this.logger.debug("{}: Unsupported operation for player of type: {}", (Object)this.getDeviceName(), (Object)this.getThing().getThingTypeUID());
        }
    }

    private List<Channel> getAllChannels() {
        ArrayList<Channel> allChannels = new ArrayList<Channel>();
        allChannels.add(this.getCallback().createChannelBuilder(new ChannelUID(this.getThing().getUID(), "power"), new ChannelTypeUID("bosesoundtouch", "power")).build());
        allChannels.add(this.getCallback().createChannelBuilder(new ChannelUID(this.getThing().getUID(), "volume"), new ChannelTypeUID("bosesoundtouch", "volume")).build());
        allChannels.add(this.getCallback().createChannelBuilder(new ChannelUID(this.getThing().getUID(), "mute"), new ChannelTypeUID("bosesoundtouch", "mute")).build());
        allChannels.add(this.getCallback().createChannelBuilder(new ChannelUID(this.getThing().getUID(), "operationMode"), new ChannelTypeUID("bosesoundtouch", "operationMode_BST_10_20_30")).build());
        allChannels.add(this.getCallback().createChannelBuilder(new ChannelUID(this.getThing().getUID(), "playerControl"), new ChannelTypeUID("bosesoundtouch", "playerControl")).build());
        allChannels.add(this.getCallback().createChannelBuilder(new ChannelUID(this.getThing().getUID(), "preset"), new ChannelTypeUID("bosesoundtouch", "preset")).build());
        allChannels.add(this.getCallback().createChannelBuilder(new ChannelUID(this.getThing().getUID(), "bass"), new ChannelTypeUID("bosesoundtouch", "bass")).build());
        allChannels.add(this.getCallback().createChannelBuilder(new ChannelUID(this.getThing().getUID(), "rateEnabled"), new ChannelTypeUID("bosesoundtouch", "rateEnabled")).build());
        allChannels.add(this.getCallback().createChannelBuilder(new ChannelUID(this.getThing().getUID(), "skipEnabled"), new ChannelTypeUID("bosesoundtouch", "skipEnabled")).build());
        allChannels.add(this.getCallback().createChannelBuilder(new ChannelUID(this.getThing().getUID(), "skipPreviousEnabled"), new ChannelTypeUID("bosesoundtouch", "skipPreviousEnabled")).build());
        allChannels.add(this.getCallback().createChannelBuilder(new ChannelUID(this.getThing().getUID(), "saveAsPreset"), new ChannelTypeUID("bosesoundtouch", "saveAsPreset")).build());
        allChannels.add(this.getCallback().createChannelBuilder(new ChannelUID(this.getThing().getUID(), "keyCode"), new ChannelTypeUID("bosesoundtouch", "keyCode")).build());
        allChannels.add(this.getCallback().createChannelBuilder(new ChannelUID(this.getThing().getUID(), "nowPlayingAlbum"), new ChannelTypeUID("bosesoundtouch", "nowPlayingAlbum")).build());
        allChannels.add(this.getCallback().createChannelBuilder(new ChannelUID(this.getThing().getUID(), "nowPlayingArtwork"), new ChannelTypeUID("bosesoundtouch", "nowPlayingArtwork")).build());
        allChannels.add(this.getCallback().createChannelBuilder(new ChannelUID(this.getThing().getUID(), "nowPlayingArtist"), new ChannelTypeUID("bosesoundtouch", "nowPlayingArtist")).build());
        allChannels.add(this.getCallback().createChannelBuilder(new ChannelUID(this.getThing().getUID(), "nowPlayingDescription"), new ChannelTypeUID("bosesoundtouch", "nowPlayingDescription")).build());
        allChannels.add(this.getCallback().createChannelBuilder(new ChannelUID(this.getThing().getUID(), "nowPlayingGenre"), new ChannelTypeUID("bosesoundtouch", "nowPlayingGenre")).build());
        allChannels.add(this.getCallback().createChannelBuilder(new ChannelUID(this.getThing().getUID(), "nowPlayingItemName"), new ChannelTypeUID("bosesoundtouch", "nowPlayingItemName")).build());
        allChannels.add(this.getCallback().createChannelBuilder(new ChannelUID(this.getThing().getUID(), "nowPlayingStationLocation"), new ChannelTypeUID("bosesoundtouch", "nowPlayingStationLocation")).build());
        allChannels.add(this.getCallback().createChannelBuilder(new ChannelUID(this.getThing().getUID(), "nowPlayingStationName"), new ChannelTypeUID("bosesoundtouch", "nowPlayingStationName")).build());
        allChannels.add(this.getCallback().createChannelBuilder(new ChannelUID(this.getThing().getUID(), "nowPlayingTrack"), new ChannelTypeUID("bosesoundtouch", "nowPlayingTrack")).build());
        allChannels.add(this.getCallback().createChannelBuilder(new ChannelUID(this.getThing().getUID(), "notificationsound"), new ChannelTypeUID("bosesoundtouch", "notificationsound")).build());
        return allChannels;
    }
}

