/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.automation.module.core.internal.provider;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.eclipse.smarthome.automation.Action;
import org.eclipse.smarthome.automation.AnnotatedActions;
import org.eclipse.smarthome.automation.Module;
import org.eclipse.smarthome.automation.handler.BaseModuleHandlerFactory;
import org.eclipse.smarthome.automation.handler.ModuleHandler;
import org.eclipse.smarthome.automation.handler.ModuleHandlerFactory;
import org.eclipse.smarthome.automation.module.core.handler.AnnotationActionHandler;
import org.eclipse.smarthome.automation.module.core.provider.AnnotationActionModuleTypeHelper;
import org.eclipse.smarthome.automation.module.core.provider.ModuleInformation;
import org.eclipse.smarthome.automation.module.core.provider.i18n.ModuleTypeI18nService;
import org.eclipse.smarthome.automation.type.ActionType;
import org.eclipse.smarthome.automation.type.ModuleType;
import org.eclipse.smarthome.automation.type.ModuleTypeProvider;
import org.eclipse.smarthome.core.common.registry.Provider;
import org.eclipse.smarthome.core.common.registry.ProviderChangeListener;
import org.osgi.framework.Bundle;
import org.osgi.framework.FrameworkUtil;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;

@Component(service={ModuleTypeProvider.class, ModuleHandlerFactory.class})
public class AnnotatedActionModuleTypeProvider
extends BaseModuleHandlerFactory
implements ModuleTypeProvider {
    private final Collection<ProviderChangeListener<ModuleType>> changeListeners = ConcurrentHashMap.newKeySet();
    private Map<String, Set<ModuleInformation>> moduleInformation = new ConcurrentHashMap<String, Set<ModuleInformation>>();
    private final AnnotationActionModuleTypeHelper helper = new AnnotationActionModuleTypeHelper();
    private ModuleTypeI18nService moduleTypeI18nService;

    @Deactivate
    protected void deactivate() {
        this.moduleInformation = null;
    }

    public void addProviderChangeListener(ProviderChangeListener<ModuleType> listener) {
        this.changeListeners.add(listener);
    }

    public void removeProviderChangeListener(ProviderChangeListener<ModuleType> listener) {
        this.changeListeners.remove(listener);
    }

    public Collection<ModuleType> getAll() {
        ArrayList<ModuleType> moduleTypes = new ArrayList<ModuleType>();
        for (String moduleUID : this.moduleInformation.keySet()) {
            ActionType mt = this.helper.buildModuleType(moduleUID, this.moduleInformation);
            if (mt == null) continue;
            moduleTypes.add((ModuleType)mt);
        }
        return moduleTypes;
    }

    public <T extends ModuleType> T getModuleType(String UID, Locale locale) {
        return (T)this.localizeModuleType(UID, locale);
    }

    public <T extends ModuleType> Collection<T> getModuleTypes(Locale locale) {
        ArrayList<ModuleType> result = new ArrayList<ModuleType>();
        for (Map.Entry<String, Set<ModuleInformation>> entry : this.moduleInformation.entrySet()) {
            ModuleType localizedModuleType = this.localizeModuleType(entry.getKey(), locale);
            if (localizedModuleType == null) continue;
            result.add(localizedModuleType);
        }
        return result;
    }

    private ModuleType localizeModuleType(String uid, Locale locale) {
        Set<ModuleInformation> mis = this.moduleInformation.get(uid);
        if (mis != null && !mis.isEmpty()) {
            ModuleInformation mi = mis.iterator().next();
            Bundle bundle = FrameworkUtil.getBundle(mi.getActionProvider().getClass());
            ActionType mt = this.helper.buildModuleType(uid, this.moduleInformation);
            ModuleType localizedModuleType = this.moduleTypeI18nService.getModuleTypePerLocale((ModuleType)mt, locale, bundle);
            return localizedModuleType;
        }
        return null;
    }

    @Reference(cardinality=ReferenceCardinality.MULTIPLE, policy=ReferencePolicy.DYNAMIC)
    public void addActionProvider(AnnotatedActions actionProvider, Map<String, Object> properties) {
        Collection<ModuleInformation> moduleInformations = this.helper.parseAnnotations(actionProvider);
        String configName = this.getConfigNameFromService(properties);
        for (ModuleInformation mi : moduleInformations) {
            mi.setConfigName(configName);
            ActionType oldType = null;
            if (this.moduleInformation.containsKey(mi.getUID())) {
                oldType = this.helper.buildModuleType(mi.getUID(), this.moduleInformation);
                Set<ModuleInformation> availableModuleConfigs = this.moduleInformation.get(mi.getUID());
                availableModuleConfigs.add(mi);
            } else {
                ConcurrentHashMap.KeySetView configs = ConcurrentHashMap.newKeySet();
                configs.add(mi);
                this.moduleInformation.put(mi.getUID(), configs);
            }
            ActionType mt = this.helper.buildModuleType(mi.getUID(), this.moduleInformation);
            if (mt == null) continue;
            for (ProviderChangeListener<ModuleType> l : this.changeListeners) {
                if (oldType != null) {
                    l.updated((Provider)this, (Object)oldType, (Object)mt);
                    continue;
                }
                l.added((Provider)this, (Object)mt);
            }
        }
    }

    public void removeActionProvider(AnnotatedActions actionProvider, Map<String, Object> properties) {
        Collection<ModuleInformation> moduleInformations = this.helper.parseAnnotations(actionProvider);
        String configName = this.getConfigNameFromService(properties);
        for (ModuleInformation mi : moduleInformations) {
            mi.setConfigName(configName);
            ActionType oldType = null;
            Set<ModuleInformation> availableModuleConfigs = this.moduleInformation.get(mi.getUID());
            if (availableModuleConfigs == null) continue;
            if (availableModuleConfigs.size() > 1) {
                oldType = this.helper.buildModuleType(mi.getUID(), this.moduleInformation);
                availableModuleConfigs.remove(mi);
            } else {
                this.moduleInformation.remove(mi.getUID());
            }
            ActionType mt = this.helper.buildModuleType(mi.getUID(), this.moduleInformation);
            for (ProviderChangeListener<ModuleType> l : this.changeListeners) {
                if (oldType != null) {
                    l.updated((Provider)this, (Object)oldType, (Object)mt);
                    continue;
                }
                l.removed((Provider)this, (Object)mt);
            }
        }
    }

    private String getConfigNameFromService(Map<String, Object> properties) {
        Object o = properties.get("esh.servicecontext");
        String configName = null;
        if (o instanceof String) {
            configName = (String)o;
        }
        return configName;
    }

    public Collection<String> getTypes() {
        return this.moduleInformation.keySet();
    }

    protected ModuleHandler internalCreate(Module module, String ruleUID) {
        ModuleInformation finalMI;
        Action actionModule;
        if (module instanceof Action && this.moduleInformation.containsKey((actionModule = (Action)module).getTypeUID()) && (finalMI = this.helper.getModuleInformationForIdentifier(actionModule, this.moduleInformation, false)) != null) {
            ActionType moduleType = this.helper.buildModuleType(module.getTypeUID(), this.moduleInformation);
            return new AnnotationActionHandler(actionModule, moduleType, finalMI.getMethod(), finalMI.getActionProvider());
        }
        return null;
    }

    @Reference
    protected void setModuleTypeI18nService(ModuleTypeI18nService moduleTypeI18nService) {
        this.moduleTypeI18nService = moduleTypeI18nService;
    }

    protected void unsetModuleTypeI18nService(ModuleTypeI18nService moduleTypeI18nService) {
        this.moduleTypeI18nService = null;
    }
}

