/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.automation.type;

import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.smarthome.automation.Visibility;
import org.eclipse.smarthome.config.core.ConfigDescriptionParameter;
import org.eclipse.smarthome.core.common.registry.Identifiable;

@NonNullByDefault
public abstract class ModuleType
implements Identifiable<String> {
    private final String uid;
    private final Visibility visibility;
    private final Set<String> tags;
    private final @Nullable String label;
    private final @Nullable String description;
    protected List<ConfigDescriptionParameter> configDescriptions;

    public ModuleType(@Nullable String UID, @Nullable List<ConfigDescriptionParameter> configDescriptions) {
        this(UID, configDescriptions, null, null, null, null);
    }

    public ModuleType(@Nullable String UID, @Nullable List<ConfigDescriptionParameter> configDescriptions, @Nullable String label, @Nullable String description, @Nullable Set<String> tags, @Nullable Visibility visibility) {
        this.uid = UID == null ? UUID.randomUUID().toString() : UID;
        this.label = label;
        this.description = description;
        this.configDescriptions = configDescriptions == null ? Collections.emptyList() : Collections.unmodifiableList(configDescriptions);
        this.tags = tags == null ? Collections.emptySet() : Collections.unmodifiableSet(tags);
        this.visibility = visibility == null ? Visibility.VISIBLE : visibility;
    }

    public String getUID() {
        return this.uid;
    }

    public List<ConfigDescriptionParameter> getConfigurationDescriptions() {
        return this.configDescriptions;
    }

    public Set<String> getTags() {
        return this.tags;
    }

    public @Nullable String getLabel() {
        return this.label;
    }

    public @Nullable String getDescription() {
        return this.description;
    }

    public Visibility getVisibility() {
        return this.visibility;
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + this.uid.hashCode();
        return result;
    }

    public boolean equals(@Nullable Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ModuleType other = (ModuleType)obj;
        return this.uid.equals(other.uid);
    }
}

