/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.ui.basic.internal.render;

import org.apache.commons.lang.StringUtils;
import org.eclipse.emf.common.util.EList;
import org.eclipse.smarthome.core.library.types.StringType;
import org.eclipse.smarthome.core.types.State;
import org.eclipse.smarthome.model.sitemap.Video;
import org.eclipse.smarthome.model.sitemap.Widget;
import org.eclipse.smarthome.ui.basic.internal.render.AbstractWidgetRenderer;
import org.eclipse.smarthome.ui.basic.render.RenderException;

public class VideoRenderer
extends AbstractWidgetRenderer {
    @Override
    public boolean canRender(Widget w) {
        return w instanceof Video;
    }

    @Override
    public EList<Widget> renderWidget(Widget w, StringBuilder sb) throws RenderException {
        Video videoWidget = (Video)w;
        String snippet = null;
        String widgetId = this.itemUIRegistry.getWidgetId(w);
        String sitemap = w.eResource().getURI().path();
        snippet = videoWidget.getEncoding() != null && videoWidget.getEncoding().toLowerCase().contains("mjpeg") ? this.getSnippet("image") : this.getSnippet("video");
        String url = "../proxy?sitemap=" + sitemap + "&widgetId=" + widgetId;
        String mediaType = "";
        if (videoWidget.getEncoding() != null && videoWidget.getEncoding().toLowerCase().contains("hls")) {
            State state = this.itemUIRegistry.getState(w);
            url = state instanceof StringType ? state.toString() : videoWidget.getUrl();
            mediaType = "type=\"application/vnd.apple.mpegurl\"";
        }
        snippet = StringUtils.replace((String)snippet, (String)"%url%", (String)url);
        snippet = StringUtils.replace((String)snippet, (String)"%media_type%", (String)mediaType);
        snippet = this.preprocessSnippet(snippet, (Widget)videoWidget);
        sb.append(snippet);
        return null;
    }
}

