/*
 * generated by Xtext 2.12.0
 */
package org.eclipse.smarthome.model.persistence.serializer;

import com.google.inject.Inject;
import java.util.Set;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.smarthome.model.persistence.persistence.AllConfig;
import org.eclipse.smarthome.model.persistence.persistence.CronStrategy;
import org.eclipse.smarthome.model.persistence.persistence.Filter;
import org.eclipse.smarthome.model.persistence.persistence.GroupConfig;
import org.eclipse.smarthome.model.persistence.persistence.ItemConfig;
import org.eclipse.smarthome.model.persistence.persistence.PersistenceConfiguration;
import org.eclipse.smarthome.model.persistence.persistence.PersistenceModel;
import org.eclipse.smarthome.model.persistence.persistence.PersistencePackage;
import org.eclipse.smarthome.model.persistence.persistence.Strategy;
import org.eclipse.smarthome.model.persistence.persistence.ThresholdFilter;
import org.eclipse.smarthome.model.persistence.persistence.TimeFilter;
import org.eclipse.smarthome.model.persistence.services.PersistenceGrammarAccess;
import org.eclipse.xtext.Action;
import org.eclipse.xtext.Parameter;
import org.eclipse.xtext.ParserRule;
import org.eclipse.xtext.serializer.ISerializationContext;
import org.eclipse.xtext.serializer.acceptor.SequenceFeeder;
import org.eclipse.xtext.serializer.sequencer.AbstractDelegatingSemanticSequencer;
import org.eclipse.xtext.serializer.sequencer.ITransientValueService.ValueTransient;

@SuppressWarnings("all")
public abstract class AbstractPersistenceSemanticSequencer extends AbstractDelegatingSemanticSequencer {

	@Inject
	private PersistenceGrammarAccess grammarAccess;
	
	@Override
	public void sequence(ISerializationContext context, EObject semanticObject) {
		EPackage epackage = semanticObject.eClass().getEPackage();
		ParserRule rule = context.getParserRule();
		Action action = context.getAssignedAction();
		Set<Parameter> parameters = context.getEnabledBooleanParameters();
		if (epackage == PersistencePackage.eINSTANCE)
			switch (semanticObject.eClass().getClassifierID()) {
			case PersistencePackage.ALL_CONFIG:
				sequence_AllConfig(context, (AllConfig) semanticObject); 
				return; 
			case PersistencePackage.CRON_STRATEGY:
				sequence_CronStrategy(context, (CronStrategy) semanticObject); 
				return; 
			case PersistencePackage.FILTER:
				sequence_Filter(context, (Filter) semanticObject); 
				return; 
			case PersistencePackage.GROUP_CONFIG:
				sequence_GroupConfig(context, (GroupConfig) semanticObject); 
				return; 
			case PersistencePackage.ITEM_CONFIG:
				sequence_ItemConfig(context, (ItemConfig) semanticObject); 
				return; 
			case PersistencePackage.PERSISTENCE_CONFIGURATION:
				sequence_PersistenceConfiguration(context, (PersistenceConfiguration) semanticObject); 
				return; 
			case PersistencePackage.PERSISTENCE_MODEL:
				sequence_PersistenceModel(context, (PersistenceModel) semanticObject); 
				return; 
			case PersistencePackage.STRATEGY:
				sequence_Strategy(context, (Strategy) semanticObject); 
				return; 
			case PersistencePackage.THRESHOLD_FILTER:
				sequence_ThresholdFilter(context, (ThresholdFilter) semanticObject); 
				return; 
			case PersistencePackage.TIME_FILTER:
				sequence_TimeFilter(context, (TimeFilter) semanticObject); 
				return; 
			}
		if (errorAcceptor != null)
			errorAcceptor.accept(diagnosticProvider.createInvalidContextOrTypeDiagnostic(semanticObject, context));
	}
	
	/**
	 * Contexts:
	 *     AllConfig returns AllConfig
	 *
	 * Constraint:
	 *     {AllConfig}
	 */
	protected void sequence_AllConfig(ISerializationContext context, AllConfig semanticObject) {
		genericSequencer.createSequence(context, semanticObject);
	}
	
	
	/**
	 * Contexts:
	 *     Strategy returns CronStrategy
	 *     CronStrategy returns CronStrategy
	 *
	 * Constraint:
	 *     (name=ID cronExpression=STRING)
	 */
	protected void sequence_CronStrategy(ISerializationContext context, CronStrategy semanticObject) {
		if (errorAcceptor != null) {
			if (transientValues.isValueTransient(semanticObject, PersistencePackage.Literals.STRATEGY__NAME) == ValueTransient.YES)
				errorAcceptor.accept(diagnosticProvider.createFeatureValueMissing(semanticObject, PersistencePackage.Literals.STRATEGY__NAME));
			if (transientValues.isValueTransient(semanticObject, PersistencePackage.Literals.CRON_STRATEGY__CRON_EXPRESSION) == ValueTransient.YES)
				errorAcceptor.accept(diagnosticProvider.createFeatureValueMissing(semanticObject, PersistencePackage.Literals.CRON_STRATEGY__CRON_EXPRESSION));
		}
		SequenceFeeder feeder = createSequencerFeeder(context, semanticObject);
		feeder.accept(grammarAccess.getCronStrategyAccess().getNameIDTerminalRuleCall_1_0(), semanticObject.getName());
		feeder.accept(grammarAccess.getCronStrategyAccess().getCronExpressionSTRINGTerminalRuleCall_3_0(), semanticObject.getCronExpression());
		feeder.finish();
	}
	
	
	/**
	 * Contexts:
	 *     Filter returns Filter
	 *
	 * Constraint:
	 *     (name=ID definition=FilterDetails)
	 */
	protected void sequence_Filter(ISerializationContext context, Filter semanticObject) {
		if (errorAcceptor != null) {
			if (transientValues.isValueTransient(semanticObject, PersistencePackage.Literals.FILTER__NAME) == ValueTransient.YES)
				errorAcceptor.accept(diagnosticProvider.createFeatureValueMissing(semanticObject, PersistencePackage.Literals.FILTER__NAME));
			if (transientValues.isValueTransient(semanticObject, PersistencePackage.Literals.FILTER__DEFINITION) == ValueTransient.YES)
				errorAcceptor.accept(diagnosticProvider.createFeatureValueMissing(semanticObject, PersistencePackage.Literals.FILTER__DEFINITION));
		}
		SequenceFeeder feeder = createSequencerFeeder(context, semanticObject);
		feeder.accept(grammarAccess.getFilterAccess().getNameIDTerminalRuleCall_0_0(), semanticObject.getName());
		feeder.accept(grammarAccess.getFilterAccess().getDefinitionFilterDetailsParserRuleCall_2_0(), semanticObject.getDefinition());
		feeder.finish();
	}
	
	
	/**
	 * Contexts:
	 *     GroupConfig returns GroupConfig
	 *
	 * Constraint:
	 *     group=ID
	 */
	protected void sequence_GroupConfig(ISerializationContext context, GroupConfig semanticObject) {
		if (errorAcceptor != null) {
			if (transientValues.isValueTransient(semanticObject, PersistencePackage.Literals.GROUP_CONFIG__GROUP) == ValueTransient.YES)
				errorAcceptor.accept(diagnosticProvider.createFeatureValueMissing(semanticObject, PersistencePackage.Literals.GROUP_CONFIG__GROUP));
		}
		SequenceFeeder feeder = createSequencerFeeder(context, semanticObject);
		feeder.accept(grammarAccess.getGroupConfigAccess().getGroupIDTerminalRuleCall_0_0(), semanticObject.getGroup());
		feeder.finish();
	}
	
	
	/**
	 * Contexts:
	 *     ItemConfig returns ItemConfig
	 *
	 * Constraint:
	 *     item=ID
	 */
	protected void sequence_ItemConfig(ISerializationContext context, ItemConfig semanticObject) {
		if (errorAcceptor != null) {
			if (transientValues.isValueTransient(semanticObject, PersistencePackage.Literals.ITEM_CONFIG__ITEM) == ValueTransient.YES)
				errorAcceptor.accept(diagnosticProvider.createFeatureValueMissing(semanticObject, PersistencePackage.Literals.ITEM_CONFIG__ITEM));
		}
		SequenceFeeder feeder = createSequencerFeeder(context, semanticObject);
		feeder.accept(grammarAccess.getItemConfigAccess().getItemIDTerminalRuleCall_0(), semanticObject.getItem());
		feeder.finish();
	}
	
	
	/**
	 * Contexts:
	 *     PersistenceConfiguration returns PersistenceConfiguration
	 *
	 * Constraint:
	 *     (
	 *         (items+=AllConfig | items+=ItemConfig | items+=GroupConfig) 
	 *         items+=AllConfig? 
	 *         ((items+=ItemConfig | items+=GroupConfig)? items+=AllConfig?)* 
	 *         alias=STRING? 
	 *         (strategies+=[Strategy|ID] strategies+=[Strategy|ID]*)? 
	 *         (filters+=[Filter|ID] filters+=[Filter|ID]*)?
	 *     )
	 */
	protected void sequence_PersistenceConfiguration(ISerializationContext context, PersistenceConfiguration semanticObject) {
		genericSequencer.createSequence(context, semanticObject);
	}
	
	
	/**
	 * Contexts:
	 *     PersistenceModel returns PersistenceModel
	 *
	 * Constraint:
	 *     (strategies+=Strategy* (defaults+=[Strategy|ID] defaults+=[Strategy|ID]*)? filters+=Filter* configs+=PersistenceConfiguration*)
	 */
	protected void sequence_PersistenceModel(ISerializationContext context, PersistenceModel semanticObject) {
		genericSequencer.createSequence(context, semanticObject);
	}
	
	
	/**
	 * Contexts:
	 *     Strategy returns Strategy
	 *
	 * Constraint:
	 *     name=ID
	 */
	protected void sequence_Strategy(ISerializationContext context, Strategy semanticObject) {
		if (errorAcceptor != null) {
			if (transientValues.isValueTransient(semanticObject, PersistencePackage.Literals.STRATEGY__NAME) == ValueTransient.YES)
				errorAcceptor.accept(diagnosticProvider.createFeatureValueMissing(semanticObject, PersistencePackage.Literals.STRATEGY__NAME));
		}
		SequenceFeeder feeder = createSequencerFeeder(context, semanticObject);
		feeder.accept(grammarAccess.getStrategyAccess().getNameIDTerminalRuleCall_1_0(), semanticObject.getName());
		feeder.finish();
	}
	
	
	/**
	 * Contexts:
	 *     FilterDetails returns ThresholdFilter
	 *     ThresholdFilter returns ThresholdFilter
	 *
	 * Constraint:
	 *     (value=DECIMAL percent?='%')
	 */
	protected void sequence_ThresholdFilter(ISerializationContext context, ThresholdFilter semanticObject) {
		if (errorAcceptor != null) {
			if (transientValues.isValueTransient(semanticObject, PersistencePackage.Literals.THRESHOLD_FILTER__VALUE) == ValueTransient.YES)
				errorAcceptor.accept(diagnosticProvider.createFeatureValueMissing(semanticObject, PersistencePackage.Literals.THRESHOLD_FILTER__VALUE));
			if (transientValues.isValueTransient(semanticObject, PersistencePackage.Literals.THRESHOLD_FILTER__PERCENT) == ValueTransient.YES)
				errorAcceptor.accept(diagnosticProvider.createFeatureValueMissing(semanticObject, PersistencePackage.Literals.THRESHOLD_FILTER__PERCENT));
		}
		SequenceFeeder feeder = createSequencerFeeder(context, semanticObject);
		feeder.accept(grammarAccess.getThresholdFilterAccess().getValueDECIMALParserRuleCall_1_0(), semanticObject.getValue());
		feeder.accept(grammarAccess.getThresholdFilterAccess().getPercentPercentSignKeyword_2_0(), semanticObject.isPercent());
		feeder.finish();
	}
	
	
	/**
	 * Contexts:
	 *     FilterDetails returns TimeFilter
	 *     TimeFilter returns TimeFilter
	 *
	 * Constraint:
	 *     (value=INT (unit='s' | unit='m' | unit='h' | unit='d'))
	 */
	protected void sequence_TimeFilter(ISerializationContext context, TimeFilter semanticObject) {
		genericSequencer.createSequence(context, semanticObject);
	}
	
	
}
