/**
 * Copyright (c) 2023 DB Netz AG and others.
 * 
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v2.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v20.html
 * 
 */
package org.eclipse.set.model.model11001.Zugnummernmeldeanlage.provider;

import java.util.ArrayList;
import java.util.Collection;

import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;

import org.eclipse.emf.edit.provider.ChangeNotifier;
import org.eclipse.emf.edit.provider.ComposeableAdapterFactory;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.provider.IChangeNotifier;
import org.eclipse.emf.edit.provider.IDisposable;
import org.eclipse.emf.edit.provider.IEditingDomainItemProvider;
import org.eclipse.emf.edit.provider.IItemLabelProvider;
import org.eclipse.emf.edit.provider.IItemPropertySource;
import org.eclipse.emf.edit.provider.INotifyChangedListener;
import org.eclipse.emf.edit.provider.IStructuredItemContentProvider;
import org.eclipse.emf.edit.provider.ITreeItemContentProvider;

import org.eclipse.set.model.model11001.Zugnummernmeldeanlage.util.ZugnummernmeldeanlageAdapterFactory;

/**
 * This is the factory that is used to provide the interfaces needed to support Viewers.
 * The adapters generated by this factory convert EMF adapter notifications into calls to {@link #fireNotifyChanged fireNotifyChanged}.
 * The adapters also support Eclipse property sheets.
 * Note that most of the adapters are shared among multiple instances.
 * <!-- begin-user-doc -->
 * <!-- end-user-doc -->
 * @generated
 */
public class ZugnummernmeldeanlageItemProviderAdapterFactory extends ZugnummernmeldeanlageAdapterFactory implements ComposeableAdapterFactory, IChangeNotifier, IDisposable {
	/**
	 * This keeps track of the root adapter factory that delegates to this adapter factory.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ComposedAdapterFactory parentAdapterFactory;

	/**
	 * This is used to implement {@link org.eclipse.emf.edit.provider.IChangeNotifier}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected IChangeNotifier changeNotifier = new ChangeNotifier();

	/**
	 * This keeps track of all the supported types checked by {@link #isFactoryForType isFactoryForType}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected Collection<Object> supportedTypes = new ArrayList<Object>();

	/**
	 * This constructs an instance.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public ZugnummernmeldeanlageItemProviderAdapterFactory() {
		supportedTypes.add(IEditingDomainItemProvider.class);
		supportedTypes.add(IStructuredItemContentProvider.class);
		supportedTypes.add(ITreeItemContentProvider.class);
		supportedTypes.add(IItemLabelProvider.class);
		supportedTypes.add(IItemPropertySource.class);
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.model.model11001.Zugnummernmeldeanlage.Akustikdauer_Anb_Ann_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected Akustikdauer_Anb_Ann_TypeClassItemProvider akustikdauer_Anb_Ann_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.model.model11001.Zugnummernmeldeanlage.Akustikdauer_Anb_Ann_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createAkustikdauer_Anb_Ann_TypeClassAdapter() {
		if (akustikdauer_Anb_Ann_TypeClassItemProvider == null) {
			akustikdauer_Anb_Ann_TypeClassItemProvider = new Akustikdauer_Anb_Ann_TypeClassItemProvider(this);
		}

		return akustikdauer_Anb_Ann_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.model.model11001.Zugnummernmeldeanlage.Akustikdauer_Sonst_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected Akustikdauer_Sonst_TypeClassItemProvider akustikdauer_Sonst_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.model.model11001.Zugnummernmeldeanlage.Akustikdauer_Sonst_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createAkustikdauer_Sonst_TypeClassAdapter() {
		if (akustikdauer_Sonst_TypeClassItemProvider == null) {
			akustikdauer_Sonst_TypeClassItemProvider = new Akustikdauer_Sonst_TypeClassItemProvider(this);
		}

		return akustikdauer_Sonst_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.model.model11001.Zugnummernmeldeanlage.Akustikdauer_Voranz_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected Akustikdauer_Voranz_TypeClassItemProvider akustikdauer_Voranz_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.model.model11001.Zugnummernmeldeanlage.Akustikdauer_Voranz_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createAkustikdauer_Voranz_TypeClassAdapter() {
		if (akustikdauer_Voranz_TypeClassItemProvider == null) {
			akustikdauer_Voranz_TypeClassItemProvider = new Akustikdauer_Voranz_TypeClassItemProvider(this);
		}

		return akustikdauer_Voranz_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.model.model11001.Zugnummernmeldeanlage.Anschlussnummer_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected Anschlussnummer_TypeClassItemProvider anschlussnummer_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.model.model11001.Zugnummernmeldeanlage.Anschlussnummer_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createAnschlussnummer_TypeClassAdapter() {
		if (anschlussnummer_TypeClassItemProvider == null) {
			anschlussnummer_TypeClassItemProvider = new Anschlussnummer_TypeClassItemProvider(this);
		}

		return anschlussnummer_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.model.model11001.Zugnummernmeldeanlage.Ausfahrdruck_Gegengleis_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected Ausfahrdruck_Gegengleis_TypeClassItemProvider ausfahrdruck_Gegengleis_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.model.model11001.Zugnummernmeldeanlage.Ausfahrdruck_Gegengleis_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createAusfahrdruck_Gegengleis_TypeClassAdapter() {
		if (ausfahrdruck_Gegengleis_TypeClassItemProvider == null) {
			ausfahrdruck_Gegengleis_TypeClassItemProvider = new Ausfahrdruck_Gegengleis_TypeClassItemProvider(this);
		}

		return ausfahrdruck_Gegengleis_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.model.model11001.Zugnummernmeldeanlage.Ausfahrdruck_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected Ausfahrdruck_TypeClassItemProvider ausfahrdruck_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.model.model11001.Zugnummernmeldeanlage.Ausfahrdruck_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createAusfahrdruck_TypeClassAdapter() {
		if (ausfahrdruck_TypeClassItemProvider == null) {
			ausfahrdruck_TypeClassItemProvider = new Ausfahrdruck_TypeClassItemProvider(this);
		}

		return ausfahrdruck_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.model.model11001.Zugnummernmeldeanlage.Bedienbarkeit_Anzeigefeld_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected Bedienbarkeit_Anzeigefeld_TypeClassItemProvider bedienbarkeit_Anzeigefeld_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.model.model11001.Zugnummernmeldeanlage.Bedienbarkeit_Anzeigefeld_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createBedienbarkeit_Anzeigefeld_TypeClassAdapter() {
		if (bedienbarkeit_Anzeigefeld_TypeClassItemProvider == null) {
			bedienbarkeit_Anzeigefeld_TypeClassItemProvider = new Bedienbarkeit_Anzeigefeld_TypeClassItemProvider(this);
		}

		return bedienbarkeit_Anzeigefeld_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.model.model11001.Zugnummernmeldeanlage.Besonderes_Schaltkriterium_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected Besonderes_Schaltkriterium_TypeClassItemProvider besonderes_Schaltkriterium_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.model.model11001.Zugnummernmeldeanlage.Besonderes_Schaltkriterium_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createBesonderes_Schaltkriterium_TypeClassAdapter() {
		if (besonderes_Schaltkriterium_TypeClassItemProvider == null) {
			besonderes_Schaltkriterium_TypeClassItemProvider = new Besonderes_Schaltkriterium_TypeClassItemProvider(this);
		}

		return besonderes_Schaltkriterium_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.model.model11001.Zugnummernmeldeanlage.Bezeichnung_Besondere_Anlage_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected Bezeichnung_Besondere_Anlage_TypeClassItemProvider bezeichnung_Besondere_Anlage_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.model.model11001.Zugnummernmeldeanlage.Bezeichnung_Besondere_Anlage_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createBezeichnung_Besondere_Anlage_TypeClassAdapter() {
		if (bezeichnung_Besondere_Anlage_TypeClassItemProvider == null) {
			bezeichnung_Besondere_Anlage_TypeClassItemProvider = new Bezeichnung_Besondere_Anlage_TypeClassItemProvider(this);
		}

		return bezeichnung_Besondere_Anlage_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.model.model11001.Zugnummernmeldeanlage.Bf_Kennung_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected Bf_Kennung_TypeClassItemProvider bf_Kennung_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.model.model11001.Zugnummernmeldeanlage.Bf_Kennung_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createBf_Kennung_TypeClassAdapter() {
		if (bf_Kennung_TypeClassItemProvider == null) {
			bf_Kennung_TypeClassItemProvider = new Bf_Kennung_TypeClassItemProvider(this);
		}

		return bf_Kennung_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.model.model11001.Zugnummernmeldeanlage.Bf_Nr_ANB_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected Bf_Nr_ANB_TypeClassItemProvider bf_Nr_ANB_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.model.model11001.Zugnummernmeldeanlage.Bf_Nr_ANB_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createBf_Nr_ANB_TypeClassAdapter() {
		if (bf_Nr_ANB_TypeClassItemProvider == null) {
			bf_Nr_ANB_TypeClassItemProvider = new Bf_Nr_ANB_TypeClassItemProvider(this);
		}

		return bf_Nr_ANB_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.model.model11001.Zugnummernmeldeanlage.Bf_Nr_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected Bf_Nr_TypeClassItemProvider bf_Nr_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.model.model11001.Zugnummernmeldeanlage.Bf_Nr_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createBf_Nr_TypeClassAdapter() {
		if (bf_Nr_TypeClassItemProvider == null) {
			bf_Nr_TypeClassItemProvider = new Bf_Nr_TypeClassItemProvider(this);
		}

		return bf_Nr_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.model.model11001.Zugnummernmeldeanlage.Bf_Nr_ZN_A_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected Bf_Nr_ZN_A_TypeClassItemProvider bf_Nr_ZN_A_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.model.model11001.Zugnummernmeldeanlage.Bf_Nr_ZN_A_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createBf_Nr_ZN_A_TypeClassAdapter() {
		if (bf_Nr_ZN_A_TypeClassItemProvider == null) {
			bf_Nr_ZN_A_TypeClassItemProvider = new Bf_Nr_ZN_A_TypeClassItemProvider(this);
		}

		return bf_Nr_ZN_A_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.model.model11001.Zugnummernmeldeanlage.Durchfahrdruck_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected Durchfahrdruck_TypeClassItemProvider durchfahrdruck_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.model.model11001.Zugnummernmeldeanlage.Durchfahrdruck_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createDurchfahrdruck_TypeClassAdapter() {
		if (durchfahrdruck_TypeClassItemProvider == null) {
			durchfahrdruck_TypeClassItemProvider = new Durchfahrdruck_TypeClassItemProvider(this);
		}

		return durchfahrdruck_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.model.model11001.Zugnummernmeldeanlage.Einfahrdruck_Gegengleis_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected Einfahrdruck_Gegengleis_TypeClassItemProvider einfahrdruck_Gegengleis_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.model.model11001.Zugnummernmeldeanlage.Einfahrdruck_Gegengleis_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createEinfahrdruck_Gegengleis_TypeClassAdapter() {
		if (einfahrdruck_Gegengleis_TypeClassItemProvider == null) {
			einfahrdruck_Gegengleis_TypeClassItemProvider = new Einfahrdruck_Gegengleis_TypeClassItemProvider(this);
		}

		return einfahrdruck_Gegengleis_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.model.model11001.Zugnummernmeldeanlage.Einfahrdruck_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected Einfahrdruck_TypeClassItemProvider einfahrdruck_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.model.model11001.Zugnummernmeldeanlage.Einfahrdruck_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createEinfahrdruck_TypeClassAdapter() {
		if (einfahrdruck_TypeClassItemProvider == null) {
			einfahrdruck_TypeClassItemProvider = new Einfahrdruck_TypeClassItemProvider(this);
		}

		return einfahrdruck_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.model.model11001.Zugnummernmeldeanlage.Einwahlstelle_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected Einwahlstelle_TypeClassItemProvider einwahlstelle_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.model.model11001.Zugnummernmeldeanlage.Einwahlstelle_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createEinwahlstelle_TypeClassAdapter() {
		if (einwahlstelle_TypeClassItemProvider == null) {
			einwahlstelle_TypeClassItemProvider = new Einwahlstelle_TypeClassItemProvider(this);
		}

		return einwahlstelle_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.model.model11001.Zugnummernmeldeanlage.Funktionalitaet_Anzeigefeld_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected Funktionalitaet_Anzeigefeld_TypeClassItemProvider funktionalitaet_Anzeigefeld_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.model.model11001.Zugnummernmeldeanlage.Funktionalitaet_Anzeigefeld_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createFunktionalitaet_Anzeigefeld_TypeClassAdapter() {
		if (funktionalitaet_Anzeigefeld_TypeClassItemProvider == null) {
			funktionalitaet_Anzeigefeld_TypeClassItemProvider = new Funktionalitaet_Anzeigefeld_TypeClassItemProvider(this);
		}

		return funktionalitaet_Anzeigefeld_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.model.model11001.Zugnummernmeldeanlage.HOA_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected HOA_TypeClassItemProvider hoA_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.model.model11001.Zugnummernmeldeanlage.HOA_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createHOA_TypeClassAdapter() {
		if (hoA_TypeClassItemProvider == null) {
			hoA_TypeClassItemProvider = new HOA_TypeClassItemProvider(this);
		}

		return hoA_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.model.model11001.Zugnummernmeldeanlage.IP_Adresse_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected IP_Adresse_TypeClassItemProvider iP_Adresse_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.model.model11001.Zugnummernmeldeanlage.IP_Adresse_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createIP_Adresse_TypeClassAdapter() {
		if (iP_Adresse_TypeClassItemProvider == null) {
			iP_Adresse_TypeClassItemProvider = new IP_Adresse_TypeClassItemProvider(this);
		}

		return iP_Adresse_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.model.model11001.Zugnummernmeldeanlage.Koppelunterstation_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected Koppelunterstation_TypeClassItemProvider koppelunterstation_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.model.model11001.Zugnummernmeldeanlage.Koppelunterstation_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createKoppelunterstation_TypeClassAdapter() {
		if (koppelunterstation_TypeClassItemProvider == null) {
			koppelunterstation_TypeClassItemProvider = new Koppelunterstation_TypeClassItemProvider(this);
		}

		return koppelunterstation_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.model.model11001.Zugnummernmeldeanlage.KUs_Zeittelegramm_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected KUs_Zeittelegramm_TypeClassItemProvider kUs_Zeittelegramm_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.model.model11001.Zugnummernmeldeanlage.KUs_Zeittelegramm_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createKUs_Zeittelegramm_TypeClassAdapter() {
		if (kUs_Zeittelegramm_TypeClassItemProvider == null) {
			kUs_Zeittelegramm_TypeClassItemProvider = new KUs_Zeittelegramm_TypeClassItemProvider(this);
		}

		return kUs_Zeittelegramm_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.model.model11001.Zugnummernmeldeanlage.Meldedruck_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected Meldedruck_TypeClassItemProvider meldedruck_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.model.model11001.Zugnummernmeldeanlage.Meldedruck_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createMeldedruck_TypeClassAdapter() {
		if (meldedruck_TypeClassItemProvider == null) {
			meldedruck_TypeClassItemProvider = new Meldedruck_TypeClassItemProvider(this);
		}

		return meldedruck_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.model.model11001.Zugnummernmeldeanlage.Prioritaet_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected Prioritaet_TypeClassItemProvider prioritaet_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.model.model11001.Zugnummernmeldeanlage.Prioritaet_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createPrioritaet_TypeClassAdapter() {
		if (prioritaet_TypeClassItemProvider == null) {
			prioritaet_TypeClassItemProvider = new Prioritaet_TypeClassItemProvider(this);
		}

		return prioritaet_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.model.model11001.Zugnummernmeldeanlage.Reaktivierungsfunktion_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected Reaktivierungsfunktion_TypeClassItemProvider reaktivierungsfunktion_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.model.model11001.Zugnummernmeldeanlage.Reaktivierungsfunktion_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createReaktivierungsfunktion_TypeClassAdapter() {
		if (reaktivierungsfunktion_TypeClassItemProvider == null) {
			reaktivierungsfunktion_TypeClassItemProvider = new Reaktivierungsfunktion_TypeClassItemProvider(this);
		}

		return reaktivierungsfunktion_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.model.model11001.Zugnummernmeldeanlage.Sichtbarkeit_Anzeigefeld_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected Sichtbarkeit_Anzeigefeld_TypeClassItemProvider sichtbarkeit_Anzeigefeld_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.model.model11001.Zugnummernmeldeanlage.Sichtbarkeit_Anzeigefeld_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createSichtbarkeit_Anzeigefeld_TypeClassAdapter() {
		if (sichtbarkeit_Anzeigefeld_TypeClassItemProvider == null) {
			sichtbarkeit_Anzeigefeld_TypeClassItemProvider = new Sichtbarkeit_Anzeigefeld_TypeClassItemProvider(this);
		}

		return sichtbarkeit_Anzeigefeld_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.model.model11001.Zugnummernmeldeanlage.Telegramm_02_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected Telegramm_02_TypeClassItemProvider telegramm_02_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.model.model11001.Zugnummernmeldeanlage.Telegramm_02_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createTelegramm_02_TypeClassAdapter() {
		if (telegramm_02_TypeClassItemProvider == null) {
			telegramm_02_TypeClassItemProvider = new Telegramm_02_TypeClassItemProvider(this);
		}

		return telegramm_02_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.model.model11001.Zugnummernmeldeanlage.Telegramm_03_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected Telegramm_03_TypeClassItemProvider telegramm_03_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.model.model11001.Zugnummernmeldeanlage.Telegramm_03_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createTelegramm_03_TypeClassAdapter() {
		if (telegramm_03_TypeClassItemProvider == null) {
			telegramm_03_TypeClassItemProvider = new Telegramm_03_TypeClassItemProvider(this);
		}

		return telegramm_03_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.model.model11001.Zugnummernmeldeanlage.Telegramm_04_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected Telegramm_04_TypeClassItemProvider telegramm_04_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.model.model11001.Zugnummernmeldeanlage.Telegramm_04_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createTelegramm_04_TypeClassAdapter() {
		if (telegramm_04_TypeClassItemProvider == null) {
			telegramm_04_TypeClassItemProvider = new Telegramm_04_TypeClassItemProvider(this);
		}

		return telegramm_04_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.model.model11001.Zugnummernmeldeanlage.Telegramm_10_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected Telegramm_10_TypeClassItemProvider telegramm_10_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.model.model11001.Zugnummernmeldeanlage.Telegramm_10_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createTelegramm_10_TypeClassAdapter() {
		if (telegramm_10_TypeClassItemProvider == null) {
			telegramm_10_TypeClassItemProvider = new Telegramm_10_TypeClassItemProvider(this);
		}

		return telegramm_10_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.model.model11001.Zugnummernmeldeanlage.Telegramm_21_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected Telegramm_21_TypeClassItemProvider telegramm_21_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.model.model11001.Zugnummernmeldeanlage.Telegramm_21_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createTelegramm_21_TypeClassAdapter() {
		if (telegramm_21_TypeClassItemProvider == null) {
			telegramm_21_TypeClassItemProvider = new Telegramm_21_TypeClassItemProvider(this);
		}

		return telegramm_21_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.model.model11001.Zugnummernmeldeanlage.Telegramm_30_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected Telegramm_30_TypeClassItemProvider telegramm_30_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.model.model11001.Zugnummernmeldeanlage.Telegramm_30_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createTelegramm_30_TypeClassAdapter() {
		if (telegramm_30_TypeClassItemProvider == null) {
			telegramm_30_TypeClassItemProvider = new Telegramm_30_TypeClassItemProvider(this);
		}

		return telegramm_30_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.model.model11001.Zugnummernmeldeanlage.Telegramm_84_Alle_Fstr_AttributeGroup} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected Telegramm_84_Alle_Fstr_AttributeGroupItemProvider telegramm_84_Alle_Fstr_AttributeGroupItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.model.model11001.Zugnummernmeldeanlage.Telegramm_84_Alle_Fstr_AttributeGroup}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createTelegramm_84_Alle_Fstr_AttributeGroupAdapter() {
		if (telegramm_84_Alle_Fstr_AttributeGroupItemProvider == null) {
			telegramm_84_Alle_Fstr_AttributeGroupItemProvider = new Telegramm_84_Alle_Fstr_AttributeGroupItemProvider(this);
		}

		return telegramm_84_Alle_Fstr_AttributeGroupItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.model.model11001.Zugnummernmeldeanlage.Telegramm_84_Einzelne_Fstr_AttributeGroup} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected Telegramm_84_Einzelne_Fstr_AttributeGroupItemProvider telegramm_84_Einzelne_Fstr_AttributeGroupItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.model.model11001.Zugnummernmeldeanlage.Telegramm_84_Einzelne_Fstr_AttributeGroup}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createTelegramm_84_Einzelne_Fstr_AttributeGroupAdapter() {
		if (telegramm_84_Einzelne_Fstr_AttributeGroupItemProvider == null) {
			telegramm_84_Einzelne_Fstr_AttributeGroupItemProvider = new Telegramm_84_Einzelne_Fstr_AttributeGroupItemProvider(this);
		}

		return telegramm_84_Einzelne_Fstr_AttributeGroupItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.model.model11001.Zugnummernmeldeanlage.Telegramm_84_Fuer_Alle_Fstr_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected Telegramm_84_Fuer_Alle_Fstr_TypeClassItemProvider telegramm_84_Fuer_Alle_Fstr_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.model.model11001.Zugnummernmeldeanlage.Telegramm_84_Fuer_Alle_Fstr_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createTelegramm_84_Fuer_Alle_Fstr_TypeClassAdapter() {
		if (telegramm_84_Fuer_Alle_Fstr_TypeClassItemProvider == null) {
			telegramm_84_Fuer_Alle_Fstr_TypeClassItemProvider = new Telegramm_84_Fuer_Alle_Fstr_TypeClassItemProvider(this);
		}

		return telegramm_84_Fuer_Alle_Fstr_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.model.model11001.Zugnummernmeldeanlage.Telegramm_84_Verzicht_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected Telegramm_84_Verzicht_TypeClassItemProvider telegramm_84_Verzicht_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.model.model11001.Zugnummernmeldeanlage.Telegramm_84_Verzicht_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createTelegramm_84_Verzicht_TypeClassAdapter() {
		if (telegramm_84_Verzicht_TypeClassItemProvider == null) {
			telegramm_84_Verzicht_TypeClassItemProvider = new Telegramm_84_Verzicht_TypeClassItemProvider(this);
		}

		return telegramm_84_Verzicht_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.model.model11001.Zugnummernmeldeanlage.Telegramm_85_Alle_Fstr_AttributeGroup} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected Telegramm_85_Alle_Fstr_AttributeGroupItemProvider telegramm_85_Alle_Fstr_AttributeGroupItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.model.model11001.Zugnummernmeldeanlage.Telegramm_85_Alle_Fstr_AttributeGroup}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createTelegramm_85_Alle_Fstr_AttributeGroupAdapter() {
		if (telegramm_85_Alle_Fstr_AttributeGroupItemProvider == null) {
			telegramm_85_Alle_Fstr_AttributeGroupItemProvider = new Telegramm_85_Alle_Fstr_AttributeGroupItemProvider(this);
		}

		return telegramm_85_Alle_Fstr_AttributeGroupItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.model.model11001.Zugnummernmeldeanlage.Telegramm_85_Einzelne_Fstr_AttributeGroup} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected Telegramm_85_Einzelne_Fstr_AttributeGroupItemProvider telegramm_85_Einzelne_Fstr_AttributeGroupItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.model.model11001.Zugnummernmeldeanlage.Telegramm_85_Einzelne_Fstr_AttributeGroup}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createTelegramm_85_Einzelne_Fstr_AttributeGroupAdapter() {
		if (telegramm_85_Einzelne_Fstr_AttributeGroupItemProvider == null) {
			telegramm_85_Einzelne_Fstr_AttributeGroupItemProvider = new Telegramm_85_Einzelne_Fstr_AttributeGroupItemProvider(this);
		}

		return telegramm_85_Einzelne_Fstr_AttributeGroupItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.model.model11001.Zugnummernmeldeanlage.Telegramm_85_Fuer_Alle_Fstr_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected Telegramm_85_Fuer_Alle_Fstr_TypeClassItemProvider telegramm_85_Fuer_Alle_Fstr_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.model.model11001.Zugnummernmeldeanlage.Telegramm_85_Fuer_Alle_Fstr_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createTelegramm_85_Fuer_Alle_Fstr_TypeClassAdapter() {
		if (telegramm_85_Fuer_Alle_Fstr_TypeClassItemProvider == null) {
			telegramm_85_Fuer_Alle_Fstr_TypeClassItemProvider = new Telegramm_85_Fuer_Alle_Fstr_TypeClassItemProvider(this);
		}

		return telegramm_85_Fuer_Alle_Fstr_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.model.model11001.Zugnummernmeldeanlage.Telegrammwiederholung_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected Telegrammwiederholung_TypeClassItemProvider telegrammwiederholung_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.model.model11001.Zugnummernmeldeanlage.Telegrammwiederholung_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createTelegrammwiederholung_TypeClassAdapter() {
		if (telegrammwiederholung_TypeClassItemProvider == null) {
			telegrammwiederholung_TypeClassItemProvider = new Telegrammwiederholung_TypeClassItemProvider(this);
		}

		return telegrammwiederholung_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.model.model11001.Zugnummernmeldeanlage.Unterstation_Max_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected Unterstation_Max_TypeClassItemProvider unterstation_Max_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.model.model11001.Zugnummernmeldeanlage.Unterstation_Max_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createUnterstation_Max_TypeClassAdapter() {
		if (unterstation_Max_TypeClassItemProvider == null) {
			unterstation_Max_TypeClassItemProvider = new Unterstation_Max_TypeClassItemProvider(this);
		}

		return unterstation_Max_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.model.model11001.Zugnummernmeldeanlage.Unterstation_Nr_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected Unterstation_Nr_TypeClassItemProvider unterstation_Nr_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.model.model11001.Zugnummernmeldeanlage.Unterstation_Nr_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createUnterstation_Nr_TypeClassAdapter() {
		if (unterstation_Nr_TypeClassItemProvider == null) {
			unterstation_Nr_TypeClassItemProvider = new Unterstation_Nr_TypeClassItemProvider(this);
		}

		return unterstation_Nr_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.model.model11001.Zugnummernmeldeanlage.Verzoegerung_Manuell_Loeschung_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected Verzoegerung_Manuell_Loeschung_TypeClassItemProvider verzoegerung_Manuell_Loeschung_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.model.model11001.Zugnummernmeldeanlage.Verzoegerung_Manuell_Loeschung_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createVerzoegerung_Manuell_Loeschung_TypeClassAdapter() {
		if (verzoegerung_Manuell_Loeschung_TypeClassItemProvider == null) {
			verzoegerung_Manuell_Loeschung_TypeClassItemProvider = new Verzoegerung_Manuell_Loeschung_TypeClassItemProvider(this);
		}

		return verzoegerung_Manuell_Loeschung_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.model.model11001.Zugnummernmeldeanlage.Vormeldestart_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected Vormeldestart_TypeClassItemProvider vormeldestart_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.model.model11001.Zugnummernmeldeanlage.Vormeldestart_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createVormeldestart_TypeClassAdapter() {
		if (vormeldestart_TypeClassItemProvider == null) {
			vormeldestart_TypeClassItemProvider = new Vormeldestart_TypeClassItemProvider(this);
		}

		return vormeldestart_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.model.model11001.Zugnummernmeldeanlage.ZBS_Adresse_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ZBS_Adresse_TypeClassItemProvider zbS_Adresse_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.model.model11001.Zugnummernmeldeanlage.ZBS_Adresse_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createZBS_Adresse_TypeClassAdapter() {
		if (zbS_Adresse_TypeClassItemProvider == null) {
			zbS_Adresse_TypeClassItemProvider = new ZBS_Adresse_TypeClassItemProvider(this);
		}

		return zbS_Adresse_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.model.model11001.Zugnummernmeldeanlage.ZBS_Anbindung_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ZBS_Anbindung_TypeClassItemProvider zbS_Anbindung_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.model.model11001.Zugnummernmeldeanlage.ZBS_Anbindung_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createZBS_Anbindung_TypeClassAdapter() {
		if (zbS_Anbindung_TypeClassItemProvider == null) {
			zbS_Anbindung_TypeClassItemProvider = new ZBS_Anbindung_TypeClassItemProvider(this);
		}

		return zbS_Anbindung_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.model.model11001.Zugnummernmeldeanlage.ZBS_Schnittstelle_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ZBS_Schnittstelle_TypeClassItemProvider zbS_Schnittstelle_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.model.model11001.Zugnummernmeldeanlage.ZBS_Schnittstelle_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createZBS_Schnittstelle_TypeClassAdapter() {
		if (zbS_Schnittstelle_TypeClassItemProvider == null) {
			zbS_Schnittstelle_TypeClassItemProvider = new ZBS_Schnittstelle_TypeClassItemProvider(this);
		}

		return zbS_Schnittstelle_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.model.model11001.Zugnummernmeldeanlage.Zeitsynchronisation_Funkuhr_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected Zeitsynchronisation_Funkuhr_TypeClassItemProvider zeitsynchronisation_Funkuhr_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.model.model11001.Zugnummernmeldeanlage.Zeitsynchronisation_Funkuhr_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createZeitsynchronisation_Funkuhr_TypeClassAdapter() {
		if (zeitsynchronisation_Funkuhr_TypeClassItemProvider == null) {
			zeitsynchronisation_Funkuhr_TypeClassItemProvider = new Zeitsynchronisation_Funkuhr_TypeClassItemProvider(this);
		}

		return zeitsynchronisation_Funkuhr_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.model.model11001.Zugnummernmeldeanlage.ZLV_Bus} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ZLV_BusItemProvider zlV_BusItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.model.model11001.Zugnummernmeldeanlage.ZLV_Bus}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createZLV_BusAdapter() {
		if (zlV_BusItemProvider == null) {
			zlV_BusItemProvider = new ZLV_BusItemProvider(this);
		}

		return zlV_BusItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.model.model11001.Zugnummernmeldeanlage.ZLV_Bus_Allg_AttributeGroup} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ZLV_Bus_Allg_AttributeGroupItemProvider zlV_Bus_Allg_AttributeGroupItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.model.model11001.Zugnummernmeldeanlage.ZLV_Bus_Allg_AttributeGroup}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createZLV_Bus_Allg_AttributeGroupAdapter() {
		if (zlV_Bus_Allg_AttributeGroupItemProvider == null) {
			zlV_Bus_Allg_AttributeGroupItemProvider = new ZLV_Bus_Allg_AttributeGroupItemProvider(this);
		}

		return zlV_Bus_Allg_AttributeGroupItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.model.model11001.Zugnummernmeldeanlage.ZLV_Bus_Besondere_Anlage} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ZLV_Bus_Besondere_AnlageItemProvider zlV_Bus_Besondere_AnlageItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.model.model11001.Zugnummernmeldeanlage.ZLV_Bus_Besondere_Anlage}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createZLV_Bus_Besondere_AnlageAdapter() {
		if (zlV_Bus_Besondere_AnlageItemProvider == null) {
			zlV_Bus_Besondere_AnlageItemProvider = new ZLV_Bus_Besondere_AnlageItemProvider(this);
		}

		return zlV_Bus_Besondere_AnlageItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.model.model11001.Zugnummernmeldeanlage.ZLV_Bus_Besondere_Anlage_Bezeichnung_AttributeGroup} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ZLV_Bus_Besondere_Anlage_Bezeichnung_AttributeGroupItemProvider zlV_Bus_Besondere_Anlage_Bezeichnung_AttributeGroupItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.model.model11001.Zugnummernmeldeanlage.ZLV_Bus_Besondere_Anlage_Bezeichnung_AttributeGroup}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createZLV_Bus_Besondere_Anlage_Bezeichnung_AttributeGroupAdapter() {
		if (zlV_Bus_Besondere_Anlage_Bezeichnung_AttributeGroupItemProvider == null) {
			zlV_Bus_Besondere_Anlage_Bezeichnung_AttributeGroupItemProvider = new ZLV_Bus_Besondere_Anlage_Bezeichnung_AttributeGroupItemProvider(this);
		}

		return zlV_Bus_Besondere_Anlage_Bezeichnung_AttributeGroupItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.model.model11001.Zugnummernmeldeanlage.ZLV_Bus_Bezeichnung_AttributeGroup} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ZLV_Bus_Bezeichnung_AttributeGroupItemProvider zlV_Bus_Bezeichnung_AttributeGroupItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.model.model11001.Zugnummernmeldeanlage.ZLV_Bus_Bezeichnung_AttributeGroup}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createZLV_Bus_Bezeichnung_AttributeGroupAdapter() {
		if (zlV_Bus_Bezeichnung_AttributeGroupItemProvider == null) {
			zlV_Bus_Bezeichnung_AttributeGroupItemProvider = new ZLV_Bus_Bezeichnung_AttributeGroupItemProvider(this);
		}

		return zlV_Bus_Bezeichnung_AttributeGroupItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.model.model11001.Zugnummernmeldeanlage.ZLV_Bus_Nr_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ZLV_Bus_Nr_TypeClassItemProvider zlV_Bus_Nr_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.model.model11001.Zugnummernmeldeanlage.ZLV_Bus_Nr_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createZLV_Bus_Nr_TypeClassAdapter() {
		if (zlV_Bus_Nr_TypeClassItemProvider == null) {
			zlV_Bus_Nr_TypeClassItemProvider = new ZLV_Bus_Nr_TypeClassItemProvider(this);
		}

		return zlV_Bus_Nr_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.model.model11001.Zugnummernmeldeanlage.ZLV_Bus_US_Zuordnung} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ZLV_Bus_US_ZuordnungItemProvider zlV_Bus_US_ZuordnungItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.model.model11001.Zugnummernmeldeanlage.ZLV_Bus_US_Zuordnung}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createZLV_Bus_US_ZuordnungAdapter() {
		if (zlV_Bus_US_ZuordnungItemProvider == null) {
			zlV_Bus_US_ZuordnungItemProvider = new ZLV_Bus_US_ZuordnungItemProvider(this);
		}

		return zlV_Bus_US_ZuordnungItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.model.model11001.Zugnummernmeldeanlage.ZLV_Bus_US_Zuordnung_Telegramm_AttributeGroup} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ZLV_Bus_US_Zuordnung_Telegramm_AttributeGroupItemProvider zlV_Bus_US_Zuordnung_Telegramm_AttributeGroupItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.model.model11001.Zugnummernmeldeanlage.ZLV_Bus_US_Zuordnung_Telegramm_AttributeGroup}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createZLV_Bus_US_Zuordnung_Telegramm_AttributeGroupAdapter() {
		if (zlV_Bus_US_Zuordnung_Telegramm_AttributeGroupItemProvider == null) {
			zlV_Bus_US_Zuordnung_Telegramm_AttributeGroupItemProvider = new ZLV_Bus_US_Zuordnung_Telegramm_AttributeGroupItemProvider(this);
		}

		return zlV_Bus_US_Zuordnung_Telegramm_AttributeGroupItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.model.model11001.Zugnummernmeldeanlage.ZLV_Bus_Zuordnung_Allg_AttributeGroup} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ZLV_Bus_Zuordnung_Allg_AttributeGroupItemProvider zlV_Bus_Zuordnung_Allg_AttributeGroupItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.model.model11001.Zugnummernmeldeanlage.ZLV_Bus_Zuordnung_Allg_AttributeGroup}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createZLV_Bus_Zuordnung_Allg_AttributeGroupAdapter() {
		if (zlV_Bus_Zuordnung_Allg_AttributeGroupItemProvider == null) {
			zlV_Bus_Zuordnung_Allg_AttributeGroupItemProvider = new ZLV_Bus_Zuordnung_Allg_AttributeGroupItemProvider(this);
		}

		return zlV_Bus_Zuordnung_Allg_AttributeGroupItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.model.model11001.Zugnummernmeldeanlage.ZN} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ZNItemProvider znItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.model.model11001.Zugnummernmeldeanlage.ZN}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createZNAdapter() {
		if (znItemProvider == null) {
			znItemProvider = new ZNItemProvider(this);
		}

		return znItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.model.model11001.Zugnummernmeldeanlage.ZN_A_Bedienbezeichner_Frei_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ZN_A_Bedienbezeichner_Frei_TypeClassItemProvider zN_A_Bedienbezeichner_Frei_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.model.model11001.Zugnummernmeldeanlage.ZN_A_Bedienbezeichner_Frei_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createZN_A_Bedienbezeichner_Frei_TypeClassAdapter() {
		if (zN_A_Bedienbezeichner_Frei_TypeClassItemProvider == null) {
			zN_A_Bedienbezeichner_Frei_TypeClassItemProvider = new ZN_A_Bedienbezeichner_Frei_TypeClassItemProvider(this);
		}

		return zN_A_Bedienbezeichner_Frei_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.model.model11001.Zugnummernmeldeanlage.ZN_A_Bezeichner_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ZN_A_Bezeichner_TypeClassItemProvider zN_A_Bezeichner_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.model.model11001.Zugnummernmeldeanlage.ZN_A_Bezeichner_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createZN_A_Bezeichner_TypeClassAdapter() {
		if (zN_A_Bezeichner_TypeClassItemProvider == null) {
			zN_A_Bezeichner_TypeClassItemProvider = new ZN_A_Bezeichner_TypeClassItemProvider(this);
		}

		return zN_A_Bezeichner_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.model.model11001.Zugnummernmeldeanlage.ZN_Akustik} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ZN_AkustikItemProvider zN_AkustikItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.model.model11001.Zugnummernmeldeanlage.ZN_Akustik}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createZN_AkustikAdapter() {
		if (zN_AkustikItemProvider == null) {
			zN_AkustikItemProvider = new ZN_AkustikItemProvider(this);
		}

		return zN_AkustikItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.model.model11001.Zugnummernmeldeanlage.ZN_Akustik_Anzeigefeld_AttributeGroup} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ZN_Akustik_Anzeigefeld_AttributeGroupItemProvider zN_Akustik_Anzeigefeld_AttributeGroupItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.model.model11001.Zugnummernmeldeanlage.ZN_Akustik_Anzeigefeld_AttributeGroup}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createZN_Akustik_Anzeigefeld_AttributeGroupAdapter() {
		if (zN_Akustik_Anzeigefeld_AttributeGroupItemProvider == null) {
			zN_Akustik_Anzeigefeld_AttributeGroupItemProvider = new ZN_Akustik_Anzeigefeld_AttributeGroupItemProvider(this);
		}

		return zN_Akustik_Anzeigefeld_AttributeGroupItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.model.model11001.Zugnummernmeldeanlage.ZN_Allg_AttributeGroup} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ZN_Allg_AttributeGroupItemProvider zN_Allg_AttributeGroupItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.model.model11001.Zugnummernmeldeanlage.ZN_Allg_AttributeGroup}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createZN_Allg_AttributeGroupAdapter() {
		if (zN_Allg_AttributeGroupItemProvider == null) {
			zN_Allg_AttributeGroupItemProvider = new ZN_Allg_AttributeGroupItemProvider(this);
		}

		return zN_Allg_AttributeGroupItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.model.model11001.Zugnummernmeldeanlage.ZN_Anlagentyp_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ZN_Anlagentyp_TypeClassItemProvider zN_Anlagentyp_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.model.model11001.Zugnummernmeldeanlage.ZN_Anlagentyp_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createZN_Anlagentyp_TypeClassAdapter() {
		if (zN_Anlagentyp_TypeClassItemProvider == null) {
			zN_Anlagentyp_TypeClassItemProvider = new ZN_Anlagentyp_TypeClassItemProvider(this);
		}

		return zN_Anlagentyp_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.model.model11001.Zugnummernmeldeanlage.ZN_Anzeigefeld} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ZN_AnzeigefeldItemProvider zN_AnzeigefeldItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.model.model11001.Zugnummernmeldeanlage.ZN_Anzeigefeld}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createZN_AnzeigefeldAdapter() {
		if (zN_AnzeigefeldItemProvider == null) {
			zN_AnzeigefeldItemProvider = new ZN_AnzeigefeldItemProvider(this);
		}

		return zN_AnzeigefeldItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.model.model11001.Zugnummernmeldeanlage.ZN_Anzeigefeld_Allg_AttributeGroup} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ZN_Anzeigefeld_Allg_AttributeGroupItemProvider zN_Anzeigefeld_Allg_AttributeGroupItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.model.model11001.Zugnummernmeldeanlage.ZN_Anzeigefeld_Allg_AttributeGroup}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createZN_Anzeigefeld_Allg_AttributeGroupAdapter() {
		if (zN_Anzeigefeld_Allg_AttributeGroupItemProvider == null) {
			zN_Anzeigefeld_Allg_AttributeGroupItemProvider = new ZN_Anzeigefeld_Allg_AttributeGroupItemProvider(this);
		}

		return zN_Anzeigefeld_Allg_AttributeGroupItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.model.model11001.Zugnummernmeldeanlage.ZN_Anzeigefeld_Bezeichnung_AttributeGroup} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ZN_Anzeigefeld_Bezeichnung_AttributeGroupItemProvider zN_Anzeigefeld_Bezeichnung_AttributeGroupItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.model.model11001.Zugnummernmeldeanlage.ZN_Anzeigefeld_Bezeichnung_AttributeGroup}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createZN_Anzeigefeld_Bezeichnung_AttributeGroupAdapter() {
		if (zN_Anzeigefeld_Bezeichnung_AttributeGroupItemProvider == null) {
			zN_Anzeigefeld_Bezeichnung_AttributeGroupItemProvider = new ZN_Anzeigefeld_Bezeichnung_AttributeGroupItemProvider(this);
		}

		return zN_Anzeigefeld_Bezeichnung_AttributeGroupItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.model.model11001.Zugnummernmeldeanlage.ZN_Anzeigefeld_Loeschkriterium_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ZN_Anzeigefeld_Loeschkriterium_TypeClassItemProvider zN_Anzeigefeld_Loeschkriterium_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.model.model11001.Zugnummernmeldeanlage.ZN_Anzeigefeld_Loeschkriterium_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createZN_Anzeigefeld_Loeschkriterium_TypeClassAdapter() {
		if (zN_Anzeigefeld_Loeschkriterium_TypeClassItemProvider == null) {
			zN_Anzeigefeld_Loeschkriterium_TypeClassItemProvider = new ZN_Anzeigefeld_Loeschkriterium_TypeClassItemProvider(this);
		}

		return zN_Anzeigefeld_Loeschkriterium_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.model.model11001.Zugnummernmeldeanlage.ZN_Feld_Ohne_Anzeige_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ZN_Feld_Ohne_Anzeige_TypeClassItemProvider zN_Feld_Ohne_Anzeige_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.model.model11001.Zugnummernmeldeanlage.ZN_Feld_Ohne_Anzeige_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createZN_Feld_Ohne_Anzeige_TypeClassAdapter() {
		if (zN_Feld_Ohne_Anzeige_TypeClassItemProvider == null) {
			zN_Feld_Ohne_Anzeige_TypeClassItemProvider = new ZN_Feld_Ohne_Anzeige_TypeClassItemProvider(this);
		}

		return zN_Feld_Ohne_Anzeige_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.model.model11001.Zugnummernmeldeanlage.ZN_Fortschalt_Krit_Druck_AttributeGroup} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ZN_Fortschalt_Krit_Druck_AttributeGroupItemProvider zN_Fortschalt_Krit_Druck_AttributeGroupItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.model.model11001.Zugnummernmeldeanlage.ZN_Fortschalt_Krit_Druck_AttributeGroup}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createZN_Fortschalt_Krit_Druck_AttributeGroupAdapter() {
		if (zN_Fortschalt_Krit_Druck_AttributeGroupItemProvider == null) {
			zN_Fortschalt_Krit_Druck_AttributeGroupItemProvider = new ZN_Fortschalt_Krit_Druck_AttributeGroupItemProvider(this);
		}

		return zN_Fortschalt_Krit_Druck_AttributeGroupItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.model.model11001.Zugnummernmeldeanlage.ZN_Fortschalt_Krit_Schalt_AttributeGroup} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ZN_Fortschalt_Krit_Schalt_AttributeGroupItemProvider zN_Fortschalt_Krit_Schalt_AttributeGroupItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.model.model11001.Zugnummernmeldeanlage.ZN_Fortschalt_Krit_Schalt_AttributeGroup}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createZN_Fortschalt_Krit_Schalt_AttributeGroupAdapter() {
		if (zN_Fortschalt_Krit_Schalt_AttributeGroupItemProvider == null) {
			zN_Fortschalt_Krit_Schalt_AttributeGroupItemProvider = new ZN_Fortschalt_Krit_Schalt_AttributeGroupItemProvider(this);
		}

		return zN_Fortschalt_Krit_Schalt_AttributeGroupItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.model.model11001.Zugnummernmeldeanlage.ZN_Fortschalt_Kriterium} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ZN_Fortschalt_KriteriumItemProvider zN_Fortschalt_KriteriumItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.model.model11001.Zugnummernmeldeanlage.ZN_Fortschalt_Kriterium}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createZN_Fortschalt_KriteriumAdapter() {
		if (zN_Fortschalt_KriteriumItemProvider == null) {
			zN_Fortschalt_KriteriumItemProvider = new ZN_Fortschalt_KriteriumItemProvider(this);
		}

		return zN_Fortschalt_KriteriumItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.model.model11001.Zugnummernmeldeanlage.ZN_Modem_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ZN_Modem_TypeClassItemProvider zN_Modem_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.model.model11001.Zugnummernmeldeanlage.ZN_Modem_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createZN_Modem_TypeClassAdapter() {
		if (zN_Modem_TypeClassItemProvider == null) {
			zN_Modem_TypeClassItemProvider = new ZN_Modem_TypeClassItemProvider(this);
		}

		return zN_Modem_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.model.model11001.Zugnummernmeldeanlage.ZN_Schaltkriterium_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ZN_Schaltkriterium_TypeClassItemProvider zN_Schaltkriterium_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.model.model11001.Zugnummernmeldeanlage.ZN_Schaltkriterium_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createZN_Schaltkriterium_TypeClassAdapter() {
		if (zN_Schaltkriterium_TypeClassItemProvider == null) {
			zN_Schaltkriterium_TypeClassItemProvider = new ZN_Schaltkriterium_TypeClassItemProvider(this);
		}

		return zN_Schaltkriterium_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.model.model11001.Zugnummernmeldeanlage.ZN_Telegramm_84_Zuordnung} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ZN_Telegramm_84_ZuordnungItemProvider zN_Telegramm_84_ZuordnungItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.model.model11001.Zugnummernmeldeanlage.ZN_Telegramm_84_Zuordnung}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createZN_Telegramm_84_ZuordnungAdapter() {
		if (zN_Telegramm_84_ZuordnungItemProvider == null) {
			zN_Telegramm_84_ZuordnungItemProvider = new ZN_Telegramm_84_ZuordnungItemProvider(this);
		}

		return zN_Telegramm_84_ZuordnungItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.model.model11001.Zugnummernmeldeanlage.ZN_Telegramm_85_Zuordnung} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ZN_Telegramm_85_ZuordnungItemProvider zN_Telegramm_85_ZuordnungItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.model.model11001.Zugnummernmeldeanlage.ZN_Telegramm_85_Zuordnung}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createZN_Telegramm_85_ZuordnungAdapter() {
		if (zN_Telegramm_85_ZuordnungItemProvider == null) {
			zN_Telegramm_85_ZuordnungItemProvider = new ZN_Telegramm_85_ZuordnungItemProvider(this);
		}

		return zN_Telegramm_85_ZuordnungItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.model.model11001.Zugnummernmeldeanlage.ZN_Unterstation} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ZN_UnterstationItemProvider zN_UnterstationItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.model.model11001.Zugnummernmeldeanlage.ZN_Unterstation}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createZN_UnterstationAdapter() {
		if (zN_UnterstationItemProvider == null) {
			zN_UnterstationItemProvider = new ZN_UnterstationItemProvider(this);
		}

		return zN_UnterstationItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.model.model11001.Zugnummernmeldeanlage.ZN_Unterstation_Allg_AttributeGroup} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ZN_Unterstation_Allg_AttributeGroupItemProvider zN_Unterstation_Allg_AttributeGroupItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.model.model11001.Zugnummernmeldeanlage.ZN_Unterstation_Allg_AttributeGroup}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createZN_Unterstation_Allg_AttributeGroupAdapter() {
		if (zN_Unterstation_Allg_AttributeGroupItemProvider == null) {
			zN_Unterstation_Allg_AttributeGroupItemProvider = new ZN_Unterstation_Allg_AttributeGroupItemProvider(this);
		}

		return zN_Unterstation_Allg_AttributeGroupItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.model.model11001.Zugnummernmeldeanlage.ZN_Unterstation_Bf_Nr_AttributeGroup} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ZN_Unterstation_Bf_Nr_AttributeGroupItemProvider zN_Unterstation_Bf_Nr_AttributeGroupItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.model.model11001.Zugnummernmeldeanlage.ZN_Unterstation_Bf_Nr_AttributeGroup}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createZN_Unterstation_Bf_Nr_AttributeGroupAdapter() {
		if (zN_Unterstation_Bf_Nr_AttributeGroupItemProvider == null) {
			zN_Unterstation_Bf_Nr_AttributeGroupItemProvider = new ZN_Unterstation_Bf_Nr_AttributeGroupItemProvider(this);
		}

		return zN_Unterstation_Bf_Nr_AttributeGroupItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.model.model11001.Zugnummernmeldeanlage.ZN_ZBS} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ZN_ZBSItemProvider zN_ZBSItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.model.model11001.Zugnummernmeldeanlage.ZN_ZBS}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createZN_ZBSAdapter() {
		if (zN_ZBSItemProvider == null) {
			zN_ZBSItemProvider = new ZN_ZBSItemProvider(this);
		}

		return zN_ZBSItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.model.model11001.Zugnummernmeldeanlage.Zugvorbereitungsmeldung_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected Zugvorbereitungsmeldung_TypeClassItemProvider zugvorbereitungsmeldung_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.model.model11001.Zugnummernmeldeanlage.Zugvorbereitungsmeldung_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createZugvorbereitungsmeldung_TypeClassAdapter() {
		if (zugvorbereitungsmeldung_TypeClassItemProvider == null) {
			zugvorbereitungsmeldung_TypeClassItemProvider = new Zugvorbereitungsmeldung_TypeClassItemProvider(this);
		}

		return zugvorbereitungsmeldung_TypeClassItemProvider;
	}

	/**
	 * This returns the root adapter factory that contains this factory.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public ComposeableAdapterFactory getRootAdapterFactory() {
		return parentAdapterFactory == null ? this : parentAdapterFactory.getRootAdapterFactory();
	}

	/**
	 * This sets the composed adapter factory that contains this factory.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setParentAdapterFactory(ComposedAdapterFactory parentAdapterFactory) {
		this.parentAdapterFactory = parentAdapterFactory;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public boolean isFactoryForType(Object type) {
		return supportedTypes.contains(type) || super.isFactoryForType(type);
	}

	/**
	 * This implementation substitutes the factory itself as the key for the adapter.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter adapt(Notifier notifier, Object type) {
		return super.adapt(notifier, this);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Object adapt(Object object, Object type) {
		if (isFactoryForType(type)) {
			Object adapter = super.adapt(object, type);
			if (!(type instanceof Class<?>) || (((Class<?>)type).isInstance(adapter))) {
				return adapter;
			}
		}

		return null;
	}

	/**
	 * This adds a listener.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void addListener(INotifyChangedListener notifyChangedListener) {
		changeNotifier.addListener(notifyChangedListener);
	}

	/**
	 * This removes a listener.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void removeListener(INotifyChangedListener notifyChangedListener) {
		changeNotifier.removeListener(notifyChangedListener);
	}

	/**
	 * This delegates to {@link #changeNotifier} and to {@link #parentAdapterFactory}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void fireNotifyChanged(Notification notification) {
		changeNotifier.fireNotifyChanged(notification);

		if (parentAdapterFactory != null) {
			parentAdapterFactory.fireNotifyChanged(notification);
		}
	}

	/**
	 * This disposes all of the item providers created by this factory. 
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void dispose() {
		if (akustikdauer_Anb_Ann_TypeClassItemProvider != null) akustikdauer_Anb_Ann_TypeClassItemProvider.dispose();
		if (akustikdauer_Sonst_TypeClassItemProvider != null) akustikdauer_Sonst_TypeClassItemProvider.dispose();
		if (akustikdauer_Voranz_TypeClassItemProvider != null) akustikdauer_Voranz_TypeClassItemProvider.dispose();
		if (anschlussnummer_TypeClassItemProvider != null) anschlussnummer_TypeClassItemProvider.dispose();
		if (ausfahrdruck_Gegengleis_TypeClassItemProvider != null) ausfahrdruck_Gegengleis_TypeClassItemProvider.dispose();
		if (ausfahrdruck_TypeClassItemProvider != null) ausfahrdruck_TypeClassItemProvider.dispose();
		if (bedienbarkeit_Anzeigefeld_TypeClassItemProvider != null) bedienbarkeit_Anzeigefeld_TypeClassItemProvider.dispose();
		if (besonderes_Schaltkriterium_TypeClassItemProvider != null) besonderes_Schaltkriterium_TypeClassItemProvider.dispose();
		if (bezeichnung_Besondere_Anlage_TypeClassItemProvider != null) bezeichnung_Besondere_Anlage_TypeClassItemProvider.dispose();
		if (bf_Kennung_TypeClassItemProvider != null) bf_Kennung_TypeClassItemProvider.dispose();
		if (bf_Nr_ANB_TypeClassItemProvider != null) bf_Nr_ANB_TypeClassItemProvider.dispose();
		if (bf_Nr_TypeClassItemProvider != null) bf_Nr_TypeClassItemProvider.dispose();
		if (bf_Nr_ZN_A_TypeClassItemProvider != null) bf_Nr_ZN_A_TypeClassItemProvider.dispose();
		if (durchfahrdruck_TypeClassItemProvider != null) durchfahrdruck_TypeClassItemProvider.dispose();
		if (einfahrdruck_Gegengleis_TypeClassItemProvider != null) einfahrdruck_Gegengleis_TypeClassItemProvider.dispose();
		if (einfahrdruck_TypeClassItemProvider != null) einfahrdruck_TypeClassItemProvider.dispose();
		if (einwahlstelle_TypeClassItemProvider != null) einwahlstelle_TypeClassItemProvider.dispose();
		if (funktionalitaet_Anzeigefeld_TypeClassItemProvider != null) funktionalitaet_Anzeigefeld_TypeClassItemProvider.dispose();
		if (hoA_TypeClassItemProvider != null) hoA_TypeClassItemProvider.dispose();
		if (iP_Adresse_TypeClassItemProvider != null) iP_Adresse_TypeClassItemProvider.dispose();
		if (koppelunterstation_TypeClassItemProvider != null) koppelunterstation_TypeClassItemProvider.dispose();
		if (kUs_Zeittelegramm_TypeClassItemProvider != null) kUs_Zeittelegramm_TypeClassItemProvider.dispose();
		if (meldedruck_TypeClassItemProvider != null) meldedruck_TypeClassItemProvider.dispose();
		if (prioritaet_TypeClassItemProvider != null) prioritaet_TypeClassItemProvider.dispose();
		if (reaktivierungsfunktion_TypeClassItemProvider != null) reaktivierungsfunktion_TypeClassItemProvider.dispose();
		if (sichtbarkeit_Anzeigefeld_TypeClassItemProvider != null) sichtbarkeit_Anzeigefeld_TypeClassItemProvider.dispose();
		if (telegramm_02_TypeClassItemProvider != null) telegramm_02_TypeClassItemProvider.dispose();
		if (telegramm_03_TypeClassItemProvider != null) telegramm_03_TypeClassItemProvider.dispose();
		if (telegramm_04_TypeClassItemProvider != null) telegramm_04_TypeClassItemProvider.dispose();
		if (telegramm_10_TypeClassItemProvider != null) telegramm_10_TypeClassItemProvider.dispose();
		if (telegramm_21_TypeClassItemProvider != null) telegramm_21_TypeClassItemProvider.dispose();
		if (telegramm_30_TypeClassItemProvider != null) telegramm_30_TypeClassItemProvider.dispose();
		if (telegramm_84_Alle_Fstr_AttributeGroupItemProvider != null) telegramm_84_Alle_Fstr_AttributeGroupItemProvider.dispose();
		if (telegramm_84_Einzelne_Fstr_AttributeGroupItemProvider != null) telegramm_84_Einzelne_Fstr_AttributeGroupItemProvider.dispose();
		if (telegramm_84_Fuer_Alle_Fstr_TypeClassItemProvider != null) telegramm_84_Fuer_Alle_Fstr_TypeClassItemProvider.dispose();
		if (telegramm_84_Verzicht_TypeClassItemProvider != null) telegramm_84_Verzicht_TypeClassItemProvider.dispose();
		if (telegramm_85_Alle_Fstr_AttributeGroupItemProvider != null) telegramm_85_Alle_Fstr_AttributeGroupItemProvider.dispose();
		if (telegramm_85_Einzelne_Fstr_AttributeGroupItemProvider != null) telegramm_85_Einzelne_Fstr_AttributeGroupItemProvider.dispose();
		if (telegramm_85_Fuer_Alle_Fstr_TypeClassItemProvider != null) telegramm_85_Fuer_Alle_Fstr_TypeClassItemProvider.dispose();
		if (telegrammwiederholung_TypeClassItemProvider != null) telegrammwiederholung_TypeClassItemProvider.dispose();
		if (unterstation_Max_TypeClassItemProvider != null) unterstation_Max_TypeClassItemProvider.dispose();
		if (unterstation_Nr_TypeClassItemProvider != null) unterstation_Nr_TypeClassItemProvider.dispose();
		if (verzoegerung_Manuell_Loeschung_TypeClassItemProvider != null) verzoegerung_Manuell_Loeschung_TypeClassItemProvider.dispose();
		if (vormeldestart_TypeClassItemProvider != null) vormeldestart_TypeClassItemProvider.dispose();
		if (zbS_Adresse_TypeClassItemProvider != null) zbS_Adresse_TypeClassItemProvider.dispose();
		if (zbS_Anbindung_TypeClassItemProvider != null) zbS_Anbindung_TypeClassItemProvider.dispose();
		if (zbS_Schnittstelle_TypeClassItemProvider != null) zbS_Schnittstelle_TypeClassItemProvider.dispose();
		if (zeitsynchronisation_Funkuhr_TypeClassItemProvider != null) zeitsynchronisation_Funkuhr_TypeClassItemProvider.dispose();
		if (zlV_BusItemProvider != null) zlV_BusItemProvider.dispose();
		if (zlV_Bus_Allg_AttributeGroupItemProvider != null) zlV_Bus_Allg_AttributeGroupItemProvider.dispose();
		if (zlV_Bus_Besondere_AnlageItemProvider != null) zlV_Bus_Besondere_AnlageItemProvider.dispose();
		if (zlV_Bus_Besondere_Anlage_Bezeichnung_AttributeGroupItemProvider != null) zlV_Bus_Besondere_Anlage_Bezeichnung_AttributeGroupItemProvider.dispose();
		if (zlV_Bus_Bezeichnung_AttributeGroupItemProvider != null) zlV_Bus_Bezeichnung_AttributeGroupItemProvider.dispose();
		if (zlV_Bus_Nr_TypeClassItemProvider != null) zlV_Bus_Nr_TypeClassItemProvider.dispose();
		if (zlV_Bus_US_ZuordnungItemProvider != null) zlV_Bus_US_ZuordnungItemProvider.dispose();
		if (zlV_Bus_US_Zuordnung_Telegramm_AttributeGroupItemProvider != null) zlV_Bus_US_Zuordnung_Telegramm_AttributeGroupItemProvider.dispose();
		if (zlV_Bus_Zuordnung_Allg_AttributeGroupItemProvider != null) zlV_Bus_Zuordnung_Allg_AttributeGroupItemProvider.dispose();
		if (znItemProvider != null) znItemProvider.dispose();
		if (zN_A_Bedienbezeichner_Frei_TypeClassItemProvider != null) zN_A_Bedienbezeichner_Frei_TypeClassItemProvider.dispose();
		if (zN_A_Bezeichner_TypeClassItemProvider != null) zN_A_Bezeichner_TypeClassItemProvider.dispose();
		if (zN_AkustikItemProvider != null) zN_AkustikItemProvider.dispose();
		if (zN_Akustik_Anzeigefeld_AttributeGroupItemProvider != null) zN_Akustik_Anzeigefeld_AttributeGroupItemProvider.dispose();
		if (zN_Allg_AttributeGroupItemProvider != null) zN_Allg_AttributeGroupItemProvider.dispose();
		if (zN_Anlagentyp_TypeClassItemProvider != null) zN_Anlagentyp_TypeClassItemProvider.dispose();
		if (zN_AnzeigefeldItemProvider != null) zN_AnzeigefeldItemProvider.dispose();
		if (zN_Anzeigefeld_Allg_AttributeGroupItemProvider != null) zN_Anzeigefeld_Allg_AttributeGroupItemProvider.dispose();
		if (zN_Anzeigefeld_Bezeichnung_AttributeGroupItemProvider != null) zN_Anzeigefeld_Bezeichnung_AttributeGroupItemProvider.dispose();
		if (zN_Anzeigefeld_Loeschkriterium_TypeClassItemProvider != null) zN_Anzeigefeld_Loeschkriterium_TypeClassItemProvider.dispose();
		if (zN_Feld_Ohne_Anzeige_TypeClassItemProvider != null) zN_Feld_Ohne_Anzeige_TypeClassItemProvider.dispose();
		if (zN_Fortschalt_Krit_Druck_AttributeGroupItemProvider != null) zN_Fortschalt_Krit_Druck_AttributeGroupItemProvider.dispose();
		if (zN_Fortschalt_Krit_Schalt_AttributeGroupItemProvider != null) zN_Fortschalt_Krit_Schalt_AttributeGroupItemProvider.dispose();
		if (zN_Fortschalt_KriteriumItemProvider != null) zN_Fortschalt_KriteriumItemProvider.dispose();
		if (zN_Modem_TypeClassItemProvider != null) zN_Modem_TypeClassItemProvider.dispose();
		if (zN_Schaltkriterium_TypeClassItemProvider != null) zN_Schaltkriterium_TypeClassItemProvider.dispose();
		if (zN_Telegramm_84_ZuordnungItemProvider != null) zN_Telegramm_84_ZuordnungItemProvider.dispose();
		if (zN_Telegramm_85_ZuordnungItemProvider != null) zN_Telegramm_85_ZuordnungItemProvider.dispose();
		if (zN_UnterstationItemProvider != null) zN_UnterstationItemProvider.dispose();
		if (zN_Unterstation_Allg_AttributeGroupItemProvider != null) zN_Unterstation_Allg_AttributeGroupItemProvider.dispose();
		if (zN_Unterstation_Bf_Nr_AttributeGroupItemProvider != null) zN_Unterstation_Bf_Nr_AttributeGroupItemProvider.dispose();
		if (zN_ZBSItemProvider != null) zN_ZBSItemProvider.dispose();
		if (zugvorbereitungsmeldung_TypeClassItemProvider != null) zugvorbereitungsmeldung_TypeClassItemProvider.dispose();
	}

}
