/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sequoyah.localization.editor.model.operations;

import java.io.IOException;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.sequoyah.device.common.utilities.BasePlugin;
import org.eclipse.sequoyah.localization.editor.datatype.ColumnInfo;
import org.eclipse.sequoyah.localization.editor.model.StringEditorPart;
import org.eclipse.sequoyah.localization.editor.model.operations.EditorOperation;

public class RevertColumnToSavedStateOperation
extends EditorOperation {
    private final ColumnInfo actualState;
    private ColumnInfo savedState = null;
    boolean changedColumn = false;

    public RevertColumnToSavedStateOperation(String string, StringEditorPart stringEditorPart, ColumnInfo columnInfo) {
        super(string, stringEditorPart);
        this.actualState = columnInfo;
    }

    public IStatus execute(IProgressMonitor iProgressMonitor, IAdaptable iAdaptable) throws ExecutionException {
        try {
            this.getEditorInput().revert(this.actualState.getId());
        }
        catch (IOException iOException) {
            BasePlugin.logError((String)("Error reverting column: " + this.actualState.getId()), (Throwable)iOException);
        }
        this.savedState = new ColumnInfo(this.actualState.getId(), this.actualState.getTooltip(), this.getEditorInput().getValues(this.actualState.getId()), this.actualState.canRemove());
        return this.redo(iProgressMonitor, iAdaptable);
    }

    public IStatus redo(IProgressMonitor iProgressMonitor, IAdaptable iAdaptable) throws ExecutionException {
        this.getModel().removeColumnForRevertion(this.actualState.getId());
        this.getModel().addColumn(this.savedState);
        this.changedColumn = this.getEditor().unmarkColumnAsChanged(this.actualState.getId());
        this.getEditor().getEditorViewer().refresh();
        return Status.OK_STATUS;
    }

    public IStatus undo(IProgressMonitor iProgressMonitor, IAdaptable iAdaptable) throws ExecutionException {
        this.getModel().removeColumn(this.savedState.getId());
        this.getModel().addColumn(this.actualState);
        if (this.changedColumn) {
            this.getEditor().markColumnAsChanged(this.actualState.getId());
        }
        this.getEditor().getEditorViewer().refresh();
        return Status.OK_STATUS;
    }
}

