/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sequoyah.localization.editor.model;

import java.text.NumberFormat;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.sequoyah.localization.editor.datatype.CellInfo;
import org.eclipse.sequoyah.localization.editor.datatype.RowInfo;
import org.eclipse.sequoyah.localization.editor.datatype.RowInfoLeaf;
import org.eclipse.sequoyah.localization.editor.i18n.Messages;
import org.eclipse.sequoyah.localization.editor.model.StringEditorPart;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Display;

public class StringEditorColumnLabelProvider
extends ColumnLabelProvider {
    private final String column;
    private final StringEditorPart editor;
    private final Point tooltipShift;
    private final Color searchColor = new Color((Device)Display.getDefault(), 255, 200, 200);

    public StringEditorColumnLabelProvider(String string, StringEditorPart stringEditorPart) {
        this.column = string;
        this.editor = stringEditorPart;
        this.tooltipShift = Platform.getOS().equals("linux") ? new Point(-6, -10) : new Point(5, -5);
    }

    public String getText(Object object) {
        if (this.column.equalsIgnoreCase(Messages.StringEditorPart_KeyLabel)) {
            RowInfoLeaf rowInfoLeaf;
            if (object instanceof RowInfoLeaf && (rowInfoLeaf = (RowInfoLeaf)object).getParent() != null) {
                NumberFormat numberFormat = NumberFormat.getInstance();
                numberFormat.setMinimumIntegerDigits(3);
                return super.getText((Object)numberFormat.format(rowInfoLeaf.getPosition()));
            }
            return super.getText((Object)((RowInfo)object).getKey());
        }
        if (object instanceof RowInfoLeaf) {
            return super.getText((Object)((RowInfoLeaf)object).getCells().get(this.column));
        }
        return null;
    }

    public String getToolTipText(Object object) {
        RowInfoLeaf rowInfoLeaf;
        CellInfo cellInfo;
        String string = null;
        RowInfo rowInfo = (RowInfo)object;
        if (this.column.equalsIgnoreCase(Messages.StringEditorPart_KeyLabel)) {
            if (!rowInfo.getStatus().isOK()) {
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append(Messages.StringEditorColumnLabelProvider_0);
                IStatus[] iStatusArray = rowInfo.getStatus().getChildren();
                int n = iStatusArray.length;
                int n2 = 0;
                while (n2 < n) {
                    IStatus iStatus = iStatusArray[n2];
                    stringBuilder.append("\n - ");
                    stringBuilder.append(iStatus.getMessage());
                    ++n2;
                }
                string = stringBuilder.toString();
            }
        } else if (this.editor.getShowCellComments() && rowInfo instanceof RowInfoLeaf && (cellInfo = (rowInfoLeaf = (RowInfoLeaf)rowInfo).getCells().get(this.column)) != null && cellInfo.getValue() != null && cellInfo.getValue().trim().length() > 0) {
            string = cellInfo.getComment() != null ? cellInfo.getComment() : "";
        }
        return string;
    }

    public Color getBackground(Object object) {
        Color color = null;
        if (this.column.equals(Messages.StringEditorPart_KeyLabel)) {
            color = Display.getDefault().getSystemColor(19);
        } else if (object instanceof RowInfoLeaf) {
            RowInfoLeaf rowInfoLeaf = (RowInfoLeaf)object;
            CellInfo cellInfo = rowInfoLeaf.getCells().get(this.column);
            String string = this.editor.getSearchText();
            if (cellInfo != null) {
                if (string.length() > 0 && cellInfo.toString().toLowerCase().contains(string.toLowerCase())) {
                    color = this.searchColor;
                } else if (this.editor.getHighlightChanges() && cellInfo.isDirty()) {
                    color = Display.getDefault().getSystemColor(29);
                }
            }
        } else {
            color = Display.getDefault().getSystemColor(19);
        }
        return color;
    }

    public Image getImage(Object object) {
        Image image = null;
        if (this.column.equalsIgnoreCase(Messages.StringEditorPart_KeyLabel)) {
            RowInfo rowInfo = (RowInfo)object;
            switch (rowInfo.getStatus().getSeverity()) {
                case 4: {
                    image = this.editor.getErrorImage();
                    break;
                }
                case 2: {
                    image = this.editor.getWarningImage();
                    break;
                }
                default: {
                    image = this.editor.getOKImage();
                }
            }
        }
        return image;
    }

    public Font getFont(Object object) {
        if (this.column.equals(Messages.StringEditorPart_KeyLabel)) {
            RowInfoLeaf rowInfoLeaf;
            if (!(object instanceof RowInfoLeaf)) {
                Font font = Display.getDefault().getSystemFont();
                FontData[] fontDataArray = font.getFontData();
                Font font2 = new Font(font.getDevice(), fontDataArray[0].getName(), fontDataArray[0].getHeight(), 1);
                return font2;
            }
            if (object instanceof RowInfoLeaf && (rowInfoLeaf = (RowInfoLeaf)object).getParent() != null) {
                Font font = Display.getDefault().getSystemFont();
                FontData[] fontDataArray = font.getFontData();
                Font font3 = new Font(font.getDevice(), fontDataArray[0].getName(), fontDataArray[0].getHeight(), 2);
                return font3;
            }
        }
        return null;
    }

    public Point getToolTipShift(Object object) {
        return this.tooltipShift;
    }

    public int getToolTipDisplayDelayTime(Object object) {
        return 250;
    }
}

