/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sequoyah.device.framework.model;

import java.util.Properties;
import java.util.regex.Pattern;
import org.eclipse.sequoyah.device.framework.model.IInstance;
import org.eclipse.sequoyah.device.framework.statemachine.StateMachineHandler;

public abstract class AbstractMobileInstance
implements IInstance {
    private static final String VALID_INSTANCE_REGEXP = "([a-z]|[A-Z]|[0-9]|\\.|_|-)+";
    protected String id;
    private String name;
    private String separator = "\\";
    private String nameSuffix;
    private String deviceId;
    private Properties properties;
    protected int pid;
    private StateMachineHandler stateMachineHandler;

    public String getId() {
        return this.id;
    }

    public void setId(String string) {
        this.id = string;
    }

    public int getPID() {
        return this.pid;
    }

    public void setPID(int n) {
        this.pid = n;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        this.name = string;
    }

    public String getNameSuffix() {
        return this.nameSuffix;
    }

    public void setNameSuffix(String string) {
        this.nameSuffix = string;
    }

    public String getSeparator() {
        return this.separator;
    }

    public void setSeparator(String string) {
        this.separator = string;
    }

    public String getDeviceTypeId() {
        return this.deviceId;
    }

    public void setDeviceTypeId(String string) {
        this.deviceId = string;
    }

    public String getStatus() {
        return this.getStateMachineHandler() != null ? this.getStateMachineHandler().getState() : "unknown";
    }

    public void setStatus(String string) {
        this.stateMachineHandler.setState(string);
    }

    public Properties getProperties() {
        return this.properties;
    }

    public void setProperties(Properties properties) {
        this.properties = properties;
    }

    public String toString() {
        String string = this.getStatus();
        return "[Device Instance: id=" + (this.id == null ? "" : this.id) + ",name=" + (this.name == null ? "" : this.name) + ",device=" + (this.deviceId == null ? "" : this.deviceId) + ",status=" + (string == null ? "" : string) + "]";
    }

    public Object getAdapter(Class clazz) {
        if (clazz.equals(this.getClass())) {
            return this;
        }
        return null;
    }

    public StateMachineHandler getStateMachineHandler() {
        return this.stateMachineHandler;
    }

    public void setStateMachineHandler(StateMachineHandler stateMachineHandler) {
        this.stateMachineHandler = stateMachineHandler;
    }

    public static boolean validName(String string) {
        return Pattern.matches(VALID_INSTANCE_REGEXP, string);
    }
}

