/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sequoyah.localization.tools.managers;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.eclipse.sequoyah.localization.tools.extensions.classes.IGrammarChecker;
import org.eclipse.sequoyah.localization.tools.extensions.classes.ITranslator;
import org.eclipse.sequoyah.localization.tools.managers.ProjectPreferencesManager;
import org.eclipse.sequoyah.localization.tools.managers.TranslatorManager;
import org.eclipse.swt.graphics.RGB;

public class PreferencesManager {
    private ITranslator defaultTranslator;
    private IGrammarChecker defaultGrammarChecker;
    private RGB highlightColor;
    private boolean metadataEnabledByDefault;
    private Map<IProject, ProjectPreferencesManager> projectPreferencesManagers = new HashMap<IProject, ProjectPreferencesManager>();
    private static PreferencesManager instance;

    public static PreferencesManager getInstance() {
        if (instance == null) {
            instance = new PreferencesManager();
        }
        return instance;
    }

    public ProjectPreferencesManager getProjectPreferencesManager(IProject iProject) {
        ProjectPreferencesManager projectPreferencesManager = this.projectPreferencesManagers.get(iProject);
        if (projectPreferencesManager == null) {
            projectPreferencesManager = new ProjectPreferencesManager(iProject);
            this.projectPreferencesManagers.put(iProject, projectPreferencesManager);
        }
        return projectPreferencesManager;
    }

    public ITranslator getDefaultTranslator() {
        List<ITranslator> list;
        if (this.defaultTranslator == null && (list = TranslatorManager.getInstance().getTranslators()) != null && list.size() > 0) {
            this.defaultTranslator = list.get(0);
        }
        return this.defaultTranslator;
    }

    public void setDefaultTranslator(ITranslator iTranslator) {
        this.defaultTranslator = iTranslator;
    }

    public IGrammarChecker getDefaultGrammarChecker() {
        return this.defaultGrammarChecker;
    }

    public void setDefaultGrammarChecker(IGrammarChecker iGrammarChecker) {
        this.defaultGrammarChecker = iGrammarChecker;
    }

    public RGB getHighlightColor() {
        return this.highlightColor;
    }

    public void setHighlightColor(RGB rGB) {
        this.highlightColor = rGB;
    }

    public boolean isMetadataEnabledByDefault() {
        return this.metadataEnabledByDefault;
    }

    public void setMetadataEnabledByDefault(boolean bl) {
        this.metadataEnabledByDefault = bl;
    }
}

