/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sequoyah.localization.tools.datamodel;

import java.util.Collection;
import java.util.Map;
import org.eclipse.sequoyah.localization.tools.i18n.Messages;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LocaleAttribute {
    public static int STRING_TYPE = 0;
    public static int FIXED_TEXT_TYPE = 1;
    protected String displayName = "";
    protected int type = STRING_TYPE;
    protected int fixedSize = 0;
    protected int maximumSize = 0;
    protected Map<String, String> allowedValues = null;
    protected String displayValue = null;
    protected String folderValue = null;

    public LocaleAttribute(String string, int n, int n2, int n3, Map<String, String> map, String string2, String string3) {
        if (string == null) {
            throw new IllegalArgumentException(Messages.LocaleAttribute_Exception_NameCannotBeNull);
        }
        if (n == FIXED_TEXT_TYPE) {
            if (map == null) {
                throw new IllegalArgumentException(Messages.LocaleAttribute_Exception_AllowedTypesNeeded);
            }
            if (!map.containsKey(string2)) {
                throw new IllegalArgumentException(Messages.LocaleAttribute_Exception_ValueNotAllowed);
            }
        }
        this.displayName = string;
        this.setAllowedValues(map);
        this.type = n;
        this.displayValue = string2;
        this.folderValue = string3;
        this.fixedSize = n2;
        this.maximumSize = n3;
    }

    public boolean isValueAllowed(String string) {
        boolean bl = false;
        if (this.type != FIXED_TEXT_TYPE) {
            bl = true;
        }
        if (this.allowedValues != null) {
            bl = this.allowedValues.containsKey(string);
        }
        return bl;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public void setDisplayName(String string) {
        this.displayName = string;
    }

    public int getType() {
        return this.type;
    }

    public void setType(int n) {
        if (n < STRING_TYPE || n > FIXED_TEXT_TYPE) {
            throw new IllegalArgumentException(Messages.LocaleAttribute_Exception_TypeDontExist);
        }
        this.type = n;
    }

    public void setMaxSize(int n) {
        this.maximumSize = n;
    }

    public int getMaxSize() {
        return this.maximumSize;
    }

    public void setSize(int n) {
        this.fixedSize = n;
    }

    public int getSize() {
        return this.fixedSize;
    }

    public void setAllowedValues(Map<String, String> map) {
        this.allowedValues = map;
    }

    public Collection<String> getAllowedValues() {
        if (this.allowedValues == null) {
            return null;
        }
        return this.allowedValues.keySet();
    }

    public void setValues(String string, String string2) {
        if (string == null || string2 == null) {
            throw new IllegalAccessError(Messages.LocaleAttribute_Exception_ValueNotNull);
        }
        if (this.type == FIXED_TEXT_TYPE && !this.allowedValues.containsKey(string)) {
            throw new IllegalAccessError(Messages.LocaleAttribute_Exception_ValueNotAllowed2);
        }
        this.displayValue = string;
        this.folderValue = string2;
    }

    public void setValuesBasedOnDisplayValue(String string) {
        if (string == null) {
            throw new IllegalArgumentException(Messages.LocaleAttribute_Exception_ValueNotNull2);
        }
        if (this.type != FIXED_TEXT_TYPE) {
            throw new IllegalArgumentException(Messages.LocaleAttribute_Exception_NotAllowedMethod);
        }
        if (this.allowedValues != null) {
            this.allowedValues.containsKey(string);
        }
        this.displayValue = string;
        this.folderValue = string;
    }

    public String getDisplayValue() {
        return this.displayValue;
    }

    public String getFolderValue() {
        return this.folderValue;
    }

    public boolean equals(Object object) {
        boolean bl = false;
        if (object instanceof LocaleAttribute) {
            bl = this.displayName.equals(((LocaleAttribute)object).getDisplayName()) && this.folderValue.equals(((LocaleAttribute)object).getFolderValue());
        }
        return bl;
    }
}

