/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sequoyah.localization.tools.datamodel;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.sequoyah.localization.tools.datamodel.LocaleInfo;
import org.eclipse.sequoyah.localization.tools.datamodel.LocalizationProject;
import org.eclipse.sequoyah.localization.tools.datamodel.StringArray;
import org.eclipse.sequoyah.localization.tools.datamodel.StringNode;
import org.eclipse.sequoyah.localization.tools.persistence.IFilePersistentData;
import org.eclipse.sequoyah.localization.tools.persistence.IPersistentData;
import org.eclipse.sequoyah.localization.tools.persistence.PersistableAttributes;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LocalizationFile
implements IFilePersistentData {
    private LocalizationProject localizationProject;
    private IFile file;
    private LocaleInfo localeInfo;
    private List<StringNode> stringNodes;
    private List<StringArray> stringArrays;
    Map<String, StringNode> stringNodesMap = new HashMap<String, StringNode>();
    private boolean dirty = false;
    private boolean dirtyMetaExtraData = false;
    private boolean toBeDeleted = false;

    public LocalizationFile(IFile iFile, LocaleInfo localeInfo, List<StringNode> list, List<StringArray> list2) {
        this.file = iFile;
        this.localeInfo = localeInfo;
        this.stringNodes = new ArrayList<StringNode>();
        this.stringArrays = new ArrayList<StringArray>();
        this.setStringNodes(list);
        this.setStringArrays(list2);
    }

    public LocalizationProject getLocalizationProject() {
        return this.localizationProject;
    }

    public void setLocalizationProject(LocalizationProject localizationProject) {
        this.localizationProject = localizationProject;
    }

    public LocaleInfo getLocaleInfo() {
        return this.localeInfo;
    }

    public void setLocaleInfo(LocaleInfo localeInfo) {
        this.localeInfo = localeInfo;
    }

    public List<StringNode> getStringNodes() {
        return this.stringNodes;
    }

    public List<StringArray> getStringArrays() {
        return this.stringArrays;
    }

    public StringNode getStringNodeByKey(String string) {
        boolean bl = false;
        for (StringArray stringArray : this.getLocalizationProject().getAllStringArrays()) {
            if (!stringArray.isPartOfTheArray(string)) continue;
            bl = true;
            break;
        }
        return this.getStringNodeByKey(string, bl);
    }

    public StringNode getStringNodeByKey(String string, boolean bl) {
        StringNode stringNode = this.stringNodesMap.get(string);
        if (stringNode == null) {
            StringNode stringNode2 = new StringNode(string, "");
            stringNode2.setLocalizationFile(this);
            stringNode2.setArray(bl);
            stringNode = this.addStringNode(stringNode2);
        }
        return stringNode;
    }

    public void setStringNodes(List<StringNode> list) {
        this.stringNodes.clear();
        this.stringNodesMap.clear();
        for (StringNode stringNode : list) {
            this.stringNodesMap.put(stringNode.getKey(), stringNode);
            stringNode.setLocalizationFile(this);
        }
        this.stringNodes.addAll(list);
    }

    public void setStringArrays(List<StringArray> list) {
        if (list != null) {
            this.stringArrays.clear();
            this.stringArrays.clear();
            for (StringArray stringArray : list) {
                List<StringNode> list2 = stringArray.getValues();
                for (StringNode stringNode : list2) {
                    this.stringNodesMap.put(stringNode.getKey(), stringNode);
                    stringNode.setLocalizationFile(this);
                    stringNode.setArray(true);
                }
                this.stringNodes.addAll(list2);
            }
            this.stringArrays.addAll(list);
        }
    }

    public Map<String, StringNode> getStringNodesMap() {
        return this.stringNodesMap;
    }

    public boolean isDirty() {
        return this.dirty;
    }

    public void setDirty(boolean bl) {
        if (bl) {
            this.getLocalizationProject().setDirty(bl);
        }
        this.dirty = bl;
    }

    public boolean isDirtyMetaExtraData() {
        return this.dirtyMetaExtraData;
    }

    public void setDirtyMetaExtraData(boolean bl) {
        this.dirtyMetaExtraData = bl;
    }

    public void setFile(IFile iFile) {
        this.file = iFile;
    }

    public List<StringNode> getModifiedStringNodes() {
        ArrayList<StringNode> arrayList = new ArrayList<StringNode>();
        for (StringNode stringNode : this.stringNodes) {
            if (!stringNode.isDirty()) continue;
            arrayList.add(stringNode);
        }
        return arrayList;
    }

    public StringNode addStringNode(StringNode stringNode) {
        StringNode stringNode2 = stringNode;
        if (stringNode.isArray()) {
            StringArray stringArray = this.findStringArray(stringNode.getKey());
            int n = -1;
            if (StringArray.isArrayItem(stringNode.getKey())) {
                n = StringArray.findItemPosition(stringNode.getKey());
            }
            stringNode2 = stringArray.addValue(stringNode.getValue(), n != -1 ? Integer.valueOf(n) : null);
        }
        stringNode2.setLocalizationFile(this);
        this.stringNodes.add(stringNode2);
        this.stringNodesMap.put(stringNode2.getKey(), stringNode2);
        this.setDirty(true);
        return stringNode2;
    }

    public void removeStringNode(StringNode stringNode) {
        if (this.stringNodes.contains(stringNode)) {
            this.stringNodes.remove(stringNode);
            this.stringNodesMap.remove(stringNode.getKey());
            this.setDirty(true);
            if (stringNode.isArray()) {
                stringNode.getStringArray().removeValue(stringNode);
                if (stringNode.getStringArray().getValues().size() == 0) {
                    this.stringArrays.remove(stringNode.getStringArray());
                }
            }
        }
    }

    @Override
    public IFile getFile() {
        return this.file;
    }

    @Override
    public List<IPersistentData> getPersistentData() {
        ArrayList<IPersistentData> arrayList = new ArrayList<IPersistentData>();
        return arrayList;
    }

    @Override
    public PersistableAttributes getPersistableAttributes() {
        return null;
    }

    public boolean isToBeDeleted() {
        return this.toBeDeleted;
    }

    public void setToBeDeleted(boolean bl) {
        this.toBeDeleted = bl;
    }

    public boolean equals(Object object) {
        boolean bl = true;
        if (!this.getLocaleInfo().equals(((LocalizationFile)object).getLocaleInfo())) {
            bl = false;
        } else {
            LocalizationFile localizationFile = (LocalizationFile)object;
            List<StringNode> list = localizationFile.getStringNodes();
            List<StringNode> list2 = this.removeBlankArrayItems(this.stringNodes);
            List<StringNode> list3 = this.removeBlankArrayItems(list);
            Collections.sort(list2);
            Collections.sort(list3);
            if (list2.size() != list3.size()) {
                bl = false;
            } else {
                int n = 0;
                while (n < list2.size()) {
                    boolean bl2 = list2.get(n).getKey().equals(list3.get(n).getKey());
                    String string = System.getProperty("line.separator");
                    String string2 = list2.get(n).getValue().replaceAll(string, "\n");
                    boolean bl3 = string2.equals(list3.get(n).getValue());
                    if (!bl2 || !bl3) {
                        bl = false;
                        break;
                    }
                    ++n;
                }
            }
        }
        return bl;
    }

    private List<StringNode> removeBlankArrayItems(List<StringNode> list) {
        ArrayList<StringNode> arrayList = new ArrayList<StringNode>();
        for (StringNode stringNode : list) {
            if (stringNode.isArray()) {
                if (stringNode.getValue().equals("")) continue;
                arrayList.add(stringNode);
                continue;
            }
            arrayList.add(stringNode);
        }
        return arrayList;
    }

    private StringArray findStringArray(String string) {
        if (StringArray.isArrayItem(string)) {
            string = StringArray.getArrayKeyFromItemKey(string);
        }
        StringArray stringArray = null;
        for (StringArray stringArray2 : this.stringArrays) {
            if (!stringArray2.getKey().equals(string)) continue;
            stringArray = stringArray2;
            break;
        }
        if (stringArray == null) {
            stringArray = new StringArray(string);
            this.stringArrays.add(stringArray);
        }
        return stringArray;
    }
}

