/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.java.internal;

import java.util.SortedSet;
import org.eclipse.sapphire.Event;
import org.eclipse.sapphire.Listener;
import org.eclipse.sapphire.java.JavaType;
import org.eclipse.sapphire.java.JavaTypeConstraintBehavior;
import org.eclipse.sapphire.java.JavaTypeConstraintService;
import org.eclipse.sapphire.java.JavaTypeKind;
import org.eclipse.sapphire.java.JavaTypeName;
import org.eclipse.sapphire.modeling.CapitalizationType;
import org.eclipse.sapphire.modeling.IModelElement;
import org.eclipse.sapphire.modeling.ModelProperty;
import org.eclipse.sapphire.modeling.ReferenceValue;
import org.eclipse.sapphire.modeling.Status;
import org.eclipse.sapphire.modeling.ValueProperty;
import org.eclipse.sapphire.modeling.annotations.Reference;
import org.eclipse.sapphire.modeling.util.NLS;
import org.eclipse.sapphire.services.Service;
import org.eclipse.sapphire.services.ServiceContext;
import org.eclipse.sapphire.services.ServiceFactory;
import org.eclipse.sapphire.services.ValidationService;

public final class JavaTypeValidationService
extends ValidationService {
    protected void init() {
        super.init();
        final IModelElement element = (IModelElement)this.context(IModelElement.class);
        final ValueProperty property = (ValueProperty)this.context(ValueProperty.class);
        JavaTypeConstraintService javaTypeConstraintService = (JavaTypeConstraintService)element.service((ModelProperty)property, JavaTypeConstraintService.class);
        if (javaTypeConstraintService != null) {
            javaTypeConstraintService.attach(new Listener(){

                public void handle(Event event) {
                    element.refresh((ModelProperty)property);
                }
            });
        }
    }

    public Status validate() {
        ValueProperty property;
        IModelElement element = (IModelElement)this.context(IModelElement.class);
        JavaTypeConstraintService javaTypeConstraintService = (JavaTypeConstraintService)element.service((ModelProperty)(property = (ValueProperty)this.context(ValueProperty.class)), JavaTypeConstraintService.class);
        if (javaTypeConstraintService == null) {
            return Status.createOkStatus();
        }
        SortedSet<JavaTypeKind> kinds = javaTypeConstraintService.kinds();
        SortedSet<String> requiredBaseTypes = javaTypeConstraintService.types();
        JavaTypeConstraintBehavior behavior = javaTypeConstraintService.behavior();
        ReferenceValue value = (ReferenceValue)element.read(property);
        String val = value.getText(false);
        if (val != null) {
            JavaType type = (JavaType)value.resolve();
            if (type == null) {
                return Status.createOkStatus();
            }
            JavaTypeKind kind = type.kind();
            switch (kind) {
                case CLASS: {
                    if (kinds.contains((Object)JavaTypeKind.CLASS)) break;
                    String label = property.getLabel(true, CapitalizationType.NO_CAPS, false);
                    String msg = Resources.bind((String)Resources.classNotAllowed, (Object[])new Object[]{val, label});
                    return Status.createErrorStatus((String)msg);
                }
                case ABSTRACT_CLASS: {
                    if (kinds.contains((Object)JavaTypeKind.ABSTRACT_CLASS)) break;
                    String label = property.getLabel(true, CapitalizationType.NO_CAPS, false);
                    String msg = Resources.bind((String)Resources.abstractClassNotAllowed, (Object[])new Object[]{val, label});
                    return Status.createErrorStatus((String)msg);
                }
                case INTERFACE: {
                    if (kinds.contains((Object)JavaTypeKind.INTERFACE)) break;
                    String label = property.getLabel(true, CapitalizationType.NO_CAPS, false);
                    String msg = Resources.bind((String)Resources.interfaceNotAllowed, (Object[])new Object[]{val, label});
                    return Status.createErrorStatus((String)msg);
                }
                case ANNOTATION: {
                    if (kinds.contains((Object)JavaTypeKind.ANNOTATION)) break;
                    String label = property.getLabel(true, CapitalizationType.NO_CAPS, false);
                    String msg = Resources.bind((String)Resources.annotationNotAllowed, (Object[])new Object[]{val, label});
                    return Status.createErrorStatus((String)msg);
                }
                case ENUM: {
                    if (kinds.contains((Object)JavaTypeKind.ENUM)) break;
                    String label = property.getLabel(true, CapitalizationType.NO_CAPS, false);
                    String msg = Resources.bind((String)Resources.enumNotAllowed, (Object[])new Object[]{val, label});
                    return Status.createErrorStatus((String)msg);
                }
                default: {
                    throw new IllegalStateException();
                }
            }
            if (kind != JavaTypeKind.ENUM && kind != JavaTypeKind.ANNOTATION) {
                if (behavior == JavaTypeConstraintBehavior.ALL) {
                    for (String baseType : requiredBaseTypes) {
                        if (type.isOfType(baseType)) continue;
                        String template = type.kind() == JavaTypeKind.INTERFACE ? Resources.interfaceDoesNotExtend : Resources.classDoesNotImplementOrExtend;
                        String msg = Resources.bind((String)template, (Object[])new Object[]{val, baseType});
                        return Status.createErrorStatus((String)msg);
                    }
                } else {
                    boolean satisfied = false;
                    for (String baseType : requiredBaseTypes) {
                        if (!type.isOfType(baseType)) continue;
                        satisfied = true;
                        break;
                    }
                    if (!satisfied) {
                        StringBuilder list = new StringBuilder();
                        for (String baseType : requiredBaseTypes) {
                            if (list.length() > 0) {
                                list.append(", ");
                            }
                            list.append(baseType);
                        }
                        String template = type.kind() == JavaTypeKind.INTERFACE ? Resources.interfaceDoesNotExtendOneOf : Resources.classDoesNotImplementOrExtendOneOf;
                        String msg = Resources.bind((String)template, (Object[])new Object[]{val, list.toString()});
                        return Status.createErrorStatus((String)msg);
                    }
                }
            }
        }
        return Status.createOkStatus();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class Factory
    extends ServiceFactory {
        public boolean applicable(ServiceContext context, Class<? extends Service> service) {
            Reference referenceAnnotation;
            ValueProperty property = (ValueProperty)context.find(ValueProperty.class);
            IModelElement element = (IModelElement)context.find(IModelElement.class);
            if (property != null && element != null && property.getTypeClass() == JavaTypeName.class && (referenceAnnotation = (Reference)property.getAnnotation(Reference.class)) != null && referenceAnnotation.target() == JavaType.class) {
                return element.service((ModelProperty)property, JavaTypeConstraintService.class) != null;
            }
            return false;
        }

        public Service create(ServiceContext context, Class<? extends Service> service) {
            return new JavaTypeValidationService();
        }
    }

    private static final class Resources
    extends NLS {
        public static String classDoesNotImplementOrExtend;
        public static String interfaceDoesNotExtend;
        public static String classDoesNotImplementOrExtendOneOf;
        public static String interfaceDoesNotExtendOneOf;
        public static String abstractClassNotAllowed;
        public static String classNotAllowed;
        public static String interfaceNotAllowed;
        public static String annotationNotAllowed;
        public static String enumNotAllowed;

        static {
            Resources.initializeMessages((String)JavaTypeValidationService.class.getName(), Resources.class);
        }

        private Resources() {
        }
    }
}

