/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.java.internal;

import org.eclipse.sapphire.java.JavaType;
import org.eclipse.sapphire.java.JavaTypeConstraint;
import org.eclipse.sapphire.java.JavaTypeConstraintBehavior;
import org.eclipse.sapphire.java.JavaTypeKind;
import org.eclipse.sapphire.java.JavaTypeName;
import org.eclipse.sapphire.modeling.CapitalizationType;
import org.eclipse.sapphire.modeling.IModelElement;
import org.eclipse.sapphire.modeling.ModelProperty;
import org.eclipse.sapphire.modeling.ModelPropertyService;
import org.eclipse.sapphire.modeling.ModelPropertyServiceFactory;
import org.eclipse.sapphire.modeling.ModelPropertyValidationService;
import org.eclipse.sapphire.modeling.ReferenceValue;
import org.eclipse.sapphire.modeling.Status;
import org.eclipse.sapphire.modeling.ValueProperty;
import org.eclipse.sapphire.modeling.annotations.Reference;
import org.eclipse.sapphire.modeling.util.NLS;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class JavaTypeValidationService
extends ModelPropertyValidationService<ReferenceValue<JavaTypeName, JavaType>> {
    private ValueProperty property;
    private boolean isClassOk;
    private boolean isAbstractClassOk;
    private boolean isInterfaceOk;
    private boolean isAnnotationOk;
    private boolean isEnumOk;
    private String[] requiredBaseTypes;
    private JavaTypeConstraintBehavior behavior;

    public void init(IModelElement element, ModelProperty property, String[] params) {
        super.init(element, property, params);
        this.property = (ValueProperty)property;
        JavaTypeConstraint javaTypeConstraintAnnotation = (JavaTypeConstraint)this.property.getAnnotation(JavaTypeConstraint.class);
        if (javaTypeConstraintAnnotation == null) {
            throw new IllegalStateException();
        }
        this.requiredBaseTypes = javaTypeConstraintAnnotation.type();
        this.behavior = javaTypeConstraintAnnotation.behavior();
        boolean c = false;
        boolean d = false;
        boolean i = false;
        boolean a = false;
        boolean e = false;
        JavaTypeKind[] javaTypeKindArray = javaTypeConstraintAnnotation.kind();
        int n = javaTypeKindArray.length;
        int n2 = 0;
        while (n2 < n) {
            JavaTypeKind kind = javaTypeKindArray[n2];
            switch (kind) {
                case CLASS: {
                    c = true;
                    break;
                }
                case ABSTRACT_CLASS: {
                    d = true;
                    break;
                }
                case INTERFACE: {
                    i = true;
                    break;
                }
                case ANNOTATION: {
                    a = true;
                    break;
                }
                case ENUM: {
                    e = true;
                    break;
                }
                default: {
                    throw new IllegalStateException();
                }
            }
            ++n2;
        }
        this.isClassOk = c;
        this.isAbstractClassOk = d;
        this.isInterfaceOk = i;
        this.isAnnotationOk = a;
        this.isEnumOk = e;
    }

    public Status validate() {
        ReferenceValue value = (ReferenceValue)this.target();
        String val = value.getText(false);
        if (val != null) {
            JavaType type = (JavaType)value.resolve();
            if (type == null) {
                return Status.createOkStatus();
            }
            JavaTypeKind kind = type.kind();
            switch (kind) {
                case CLASS: {
                    if (this.isClassOk) break;
                    String label = this.property.getLabel(true, CapitalizationType.NO_CAPS, false);
                    String msg = Resources.bind((String)Resources.classNotAllowed, (Object[])new Object[]{val, label});
                    return Status.createErrorStatus((String)msg);
                }
                case ABSTRACT_CLASS: {
                    if (this.isAbstractClassOk) break;
                    String label = this.property.getLabel(true, CapitalizationType.NO_CAPS, false);
                    String msg = Resources.bind((String)Resources.abstractClassNotAllowed, (Object[])new Object[]{val, label});
                    return Status.createErrorStatus((String)msg);
                }
                case INTERFACE: {
                    if (this.isInterfaceOk) break;
                    String label = this.property.getLabel(true, CapitalizationType.NO_CAPS, false);
                    String msg = Resources.bind((String)Resources.interfaceNotAllowed, (Object[])new Object[]{val, label});
                    return Status.createErrorStatus((String)msg);
                }
                case ANNOTATION: {
                    if (this.isAnnotationOk) break;
                    String label = this.property.getLabel(true, CapitalizationType.NO_CAPS, false);
                    String msg = Resources.bind((String)Resources.annotationNotAllowed, (Object[])new Object[]{val, label});
                    return Status.createErrorStatus((String)msg);
                }
                case ENUM: {
                    if (this.isEnumOk) break;
                    String label = this.property.getLabel(true, CapitalizationType.NO_CAPS, false);
                    String msg = Resources.bind((String)Resources.enumNotAllowed, (Object[])new Object[]{val, label});
                    return Status.createErrorStatus((String)msg);
                }
                default: {
                    throw new IllegalStateException();
                }
            }
            if (kind != JavaTypeKind.ENUM && kind != JavaTypeKind.ANNOTATION) {
                if (this.behavior == JavaTypeConstraintBehavior.ALL) {
                    String[] stringArray = this.requiredBaseTypes;
                    int n = this.requiredBaseTypes.length;
                    int msg = 0;
                    while (msg < n) {
                        String baseType = stringArray[msg];
                        if (!type.isOfType(baseType)) {
                            String template = type.kind() == JavaTypeKind.INTERFACE ? Resources.interfaceDoesNotExtend : Resources.classDoesNotImplementOrExtend;
                            String msg2 = Resources.bind((String)template, (Object[])new Object[]{val, baseType});
                            return Status.createErrorStatus((String)msg2);
                        }
                        ++msg;
                    }
                } else {
                    boolean satisfied = false;
                    String[] stringArray = this.requiredBaseTypes;
                    int n = this.requiredBaseTypes.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String baseType = stringArray[n2];
                        if (type.isOfType(baseType)) {
                            satisfied = true;
                            break;
                        }
                        ++n2;
                    }
                    if (!satisfied) {
                        StringBuilder list = new StringBuilder();
                        String[] stringArray2 = this.requiredBaseTypes;
                        int n3 = this.requiredBaseTypes.length;
                        n = 0;
                        while (n < n3) {
                            String baseType = stringArray2[n];
                            if (list.length() > 0) {
                                list.append(", ");
                            }
                            list.append(baseType);
                            ++n;
                        }
                        String template = type.kind() == JavaTypeKind.INTERFACE ? Resources.interfaceDoesNotExtendOneOf : Resources.classDoesNotImplementOrExtendOneOf;
                        String msg = Resources.bind((String)template, (Object[])new Object[]{val, list.toString()});
                        return Status.createErrorStatus((String)msg);
                    }
                }
            }
        }
        return Status.createOkStatus();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class Factory
    extends ModelPropertyServiceFactory {
        public boolean applicable(IModelElement element, ModelProperty property, Class<? extends ModelPropertyService> service) {
            Reference referenceAnnotation;
            if (property instanceof ValueProperty && property.getTypeClass() == JavaTypeName.class && (referenceAnnotation = (Reference)property.getAnnotation(Reference.class)) != null && referenceAnnotation.target() == JavaType.class) {
                return property.hasAnnotation(JavaTypeConstraint.class);
            }
            return false;
        }

        public ModelPropertyService create(IModelElement element, ModelProperty property, Class<? extends ModelPropertyService> service) {
            return new JavaTypeValidationService();
        }
    }

    private static final class Resources
    extends NLS {
        public static String classDoesNotImplementOrExtend;
        public static String interfaceDoesNotExtend;
        public static String classDoesNotImplementOrExtendOneOf;
        public static String interfaceDoesNotExtendOneOf;
        public static String abstractClassNotAllowed;
        public static String classNotAllowed;
        public static String interfaceNotAllowed;
        public static String annotationNotAllowed;
        public static String enumNotAllowed;

        static {
            Resources.initializeMessages((String)JavaTypeValidationService.class.getName(), Resources.class);
        }

        private Resources() {
        }
    }
}

