/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ecf.provider.jms.container;

import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Dictionary;
import java.util.Iterator;
import java.util.List;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageListener;
import javax.jms.ObjectMessage;
import javax.jms.TemporaryQueue;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.ecf.core.identity.ID;
import org.eclipse.ecf.core.util.ECFException;
import org.eclipse.ecf.provider.jms.container.IJMSQueueContainer;
import org.eclipse.ecf.provider.jms.container.LBRegistrySharedObjectConfig;
import org.eclipse.ecf.provider.jms.container.LBRemoteServiceRegistrationImpl;
import org.eclipse.ecf.provider.remoteservice.generic.RegistrySharedObject;
import org.eclipse.ecf.provider.remoteservice.generic.RemoteCallImpl;
import org.eclipse.ecf.provider.remoteservice.generic.RemoteServiceRegistrationImpl;
import org.eclipse.ecf.provider.remoteservice.generic.RemoteServiceRegistryImpl;
import org.eclipse.ecf.provider.remoteservice.generic.Request;
import org.eclipse.ecf.provider.remoteservice.generic.Response;
import org.eclipse.ecf.remoteservice.IRemoteCall;
import org.eclipse.ecf.remoteservice.IRemoteServiceRegistration;
import org.eclipse.ecf.remoteservice.events.IRemoteServiceEvent;

public class LBRegistrySharedObject
extends RegistrySharedObject {
    private IJMSQueueContainer container;
    List<RequestHandlerJob> requestHandlerJobs = new ArrayList<RequestHandlerJob>();
    private MessageListener responseHandler = new MessageListener(){

        public void onMessage(Message arg0) {
            LBRegistrySharedObject.this.handleJMSResponse(arg0);
        }
    };

    public LBRegistrySharedObject() {
    }

    public LBRegistrySharedObject(ID soID, IJMSQueueContainer container) {
        this.container = container;
        try {
            this.init(new LBRegistrySharedObjectConfig(soID, container));
        }
        catch (Exception exception) {}
        this.localRegistry = new LoadBalancingRemoteServiceRegistryImpl(container.getID());
    }

    public LBRegistrySharedObject(IJMSQueueContainer container) {
        this.container = container;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private RemoteServiceRegistrationImpl getLocalRegistrationForJMSRequest(Request request) {
        RemoteServiceRegistryImpl remoteServiceRegistryImpl = this.localRegistry;
        synchronized (remoteServiceRegistryImpl) {
            return ((LoadBalancingRemoteServiceRegistryImpl)this.localRegistry).findRegistrationForJMSRequest(request);
        }
    }

    public void handleJMSMessage(Message jmsMessage) {
        if (jmsMessage == null) {
            return;
        }
        Request request = null;
        try {
            Serializable object;
            if (jmsMessage instanceof ObjectMessage && (object = ((ObjectMessage)jmsMessage).getObject()) instanceof Request) {
                request = (Request)object;
            }
            if (request == null) {
                throw new JMSException("Invalid message=" + jmsMessage);
            }
        }
        catch (JMSException e) {
            this.log("handleJMSMessage message=" + jmsMessage, e);
            return;
        }
        this.handleJMSRequestAsync(jmsMessage, request);
    }

    void handleJMSRequest(Message jmsMessage, Request request) {
        RemoteServiceRegistrationImpl localRegistration = this.getLocalRegistrationForJMSRequest(request);
        RemoteCallImpl call = request.getCall();
        Response response = null;
        Object result = null;
        try {
            result = localRegistration.callService(call);
            response = new Response(request.getRequestId(), result);
        }
        catch (Exception e) {
            response = new Response(request.getRequestId(), (Throwable)e);
            this.log(208, "Exception invoking service", e);
        }
        try {
            ObjectMessage responseMessage = this.container.getSession().createObjectMessage();
            responseMessage.setObject((Serializable)response);
            responseMessage.setJMSCorrelationID(jmsMessage.getJMSCorrelationID());
            this.container.getMessageProducer().send(jmsMessage.getJMSReplyTo(), (Message)responseMessage);
        }
        catch (JMSException e) {
            this.log("sendCallResponse jmsMessage=" + jmsMessage + ", response=" + response, e);
        }
    }

    protected void log(String method, Throwable e) {
        super.log(method, e);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean addRequestHandlerJob(RequestHandlerJob job) {
        List<RequestHandlerJob> list = this.requestHandlerJobs;
        synchronized (list) {
            return this.requestHandlerJobs.add(job);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean removeRequestHandlerJob(RequestHandlerJob job) {
        List<RequestHandlerJob> list = this.requestHandlerJobs;
        synchronized (list) {
            return this.requestHandlerJobs.remove((Object)job);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void cancelRequestHandlerJobs() {
        List<RequestHandlerJob> list = this.requestHandlerJobs;
        synchronized (list) {
            Iterator<RequestHandlerJob> i = this.requestHandlerJobs.iterator();
            while (i.hasNext()) {
                RequestHandlerJob job = i.next();
                if (!job.cancel()) continue;
                i.remove();
            }
        }
    }

    void handleJMSRequestAsync(Message jmsMessage, Request request) {
        new RequestHandlerJob(jmsMessage, request).schedule();
    }

    void handleJMSResponse(Message jmsMessage) {
        Response response = null;
        try {
            Serializable object;
            if (jmsMessage instanceof ObjectMessage && (object = ((ObjectMessage)jmsMessage).getObject()) instanceof Response) {
                response = (Response)object;
            }
            if (response == null) {
                throw new JMSException("handleJMSResponse invalid message=" + jmsMessage);
            }
        }
        catch (JMSException e) {
            this.log("handleJMSResponse exception for message=" + jmsMessage, e);
            return;
        }
        this.handleCallResponse(response);
    }

    protected Request sendCallRequest(RemoteServiceRegistrationImpl remoteRegistration, IRemoteCall call) throws IOException {
        Request request = new Request(this.getLocalContainerID(), remoteRegistration.getServiceId(), RemoteCallImpl.createRemoteCall(null, (String)call.getMethod(), (Object[])call.getParameters(), (long)call.getTimeout()), null);
        this.requests.add(request);
        try {
            TemporaryQueue tempDest = this.container.getResponseQueue();
            MessageConsumer responseConsumer = this.container.getSession().createConsumer((Destination)tempDest);
            responseConsumer.setMessageListener(this.responseHandler);
            ObjectMessage objMessage = this.container.getSession().createObjectMessage();
            objMessage.setObject((Serializable)request);
            objMessage.setJMSReplyTo((Destination)tempDest);
            objMessage.setJMSCorrelationID(String.valueOf(request.getRequestContainerID().getName()) + "-" + request.getRequestId());
            this.container.getMessageProducer().send((Message)objMessage);
        }
        catch (JMSException e) {
            this.log("sendCallRequest request=" + request, e);
        }
        return request;
    }

    public IRemoteServiceRegistration registerRemoteService(String[] clazzes, Object service, Dictionary properties) {
        if (properties != null && properties.get("ecf.rsvc.proxy") != null) {
            return this.registerLBRemoteService(clazzes, service, properties);
        }
        return super.registerRemoteService(clazzes, service, properties);
    }

    private IRemoteServiceRegistration registerLBRemoteService(String[] clazzes, Object service, Dictionary properties) {
        if (clazzes == null || clazzes.length == 0) {
            throw new IllegalArgumentException("Service classes length cannot be null or of length 0");
        }
        String[] copy = new String[clazzes.length];
        int i = 0;
        while (i < clazzes.length) {
            copy[i] = new String(clazzes[i].getBytes());
            ++i;
        }
        clazzes = copy;
        LBRemoteServiceRegistrationImpl reg = new LBRemoteServiceRegistrationImpl(this);
        reg.publish(this, this.localRegistry, service, clazzes, properties);
        ID[] targets = this.getTargetsFromProperties(properties);
        if (targets == null) {
            this.sendAddRegistration(null, reg);
        } else {
            int i2 = 0;
            while (i2 < targets.length) {
                this.sendAddRegistration(targets[i2], reg);
                ++i2;
            }
        }
        this.fireRemoteServiceListeners((IRemoteServiceEvent)this.createRegisteredEvent(reg));
        return reg;
    }

    protected Object callSynch(RemoteServiceRegistrationImpl registration, IRemoteCall call) throws ECFException {
        return super.callSynch(registration, call);
    }

    public class LoadBalancingRemoteServiceRegistryImpl
    extends RemoteServiceRegistryImpl {
        private static final long serialVersionUID = -2870359169249086805L;

        public LoadBalancingRemoteServiceRegistryImpl(ID id) {
            super(id);
        }

        public RemoteServiceRegistrationImpl findRegistrationForJMSRequest(Request request) {
            return this.findRegistrationForServiceId(request.getServiceId());
        }
    }

    class RequestHandlerJob
    extends Job {
        Message jmsMessage;
        Request request;

        public RequestHandlerJob(Message jmsMessage, Request request) {
            super("RequestHandlerJob[" + request + "]");
            this.jmsMessage = jmsMessage;
            this.request = request;
            LBRegistrySharedObject.this.addRequestHandlerJob(this);
        }

        protected IStatus run(IProgressMonitor monitor) {
            try {
                LBRegistrySharedObject.this.handleJMSRequest(this.jmsMessage, this.request);
            }
            catch (Exception e) {
                LBRegistrySharedObject.this.log("RequestHandlerJob Error", e);
            }
            LBRegistrySharedObject.this.removeRequestHandlerJob(this);
            return Status.OK_STATUS;
        }
    }
}

