/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ecf.provider.jms.container;

import java.util.Dictionary;
import javax.jms.Connection;
import javax.jms.ConnectionFactory;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageListener;
import javax.jms.MessageProducer;
import javax.jms.Queue;
import javax.jms.Session;
import javax.jms.TemporaryQueue;
import org.eclipse.ecf.core.AbstractContainer;
import org.eclipse.ecf.core.ContainerConnectException;
import org.eclipse.ecf.core.events.ContainerConnectedEvent;
import org.eclipse.ecf.core.events.ContainerConnectingEvent;
import org.eclipse.ecf.core.events.IContainerEvent;
import org.eclipse.ecf.core.identity.ID;
import org.eclipse.ecf.core.identity.IDFactory;
import org.eclipse.ecf.core.identity.Namespace;
import org.eclipse.ecf.core.security.IConnectContext;
import org.eclipse.ecf.core.util.ECFException;
import org.eclipse.ecf.provider.jms.container.IJMSQueueContainer;
import org.eclipse.ecf.provider.jms.container.LBRegistrySharedObject;
import org.eclipse.ecf.provider.jms.identity.JMSID;
import org.eclipse.ecf.remoteservice.IRemoteFilter;
import org.eclipse.ecf.remoteservice.IRemoteService;
import org.eclipse.ecf.remoteservice.IRemoteServiceCallPolicy;
import org.eclipse.ecf.remoteservice.IRemoteServiceContainerAdapter;
import org.eclipse.ecf.remoteservice.IRemoteServiceID;
import org.eclipse.ecf.remoteservice.IRemoteServiceListener;
import org.eclipse.ecf.remoteservice.IRemoteServiceReference;
import org.eclipse.ecf.remoteservice.IRemoteServiceRegistration;
import org.eclipse.equinox.concurrent.future.IFuture;
import org.osgi.framework.InvalidSyntaxException;

public abstract class AbstractJMSQueueConsumerContainer
extends AbstractContainer
implements MessageListener,
IRemoteServiceContainerAdapter,
IJMSQueueContainer {
    private JMSID id;
    private JMSID connectedID;
    private Object queueConnectLock = new Object();
    private Connection connection;
    private Session session;
    private Queue queue;
    private MessageProducer messageProducer;
    private TemporaryQueue responseQueue;
    private LBRegistrySharedObject registry;
    public JMSID queueID;

    public AbstractJMSQueueConsumerContainer(JMSID containerID, JMSID queueID) {
        this.id = containerID;
        this.queueID = queueID;
        this.registry = new LBRegistrySharedObject(IDFactory.getDefault().createStringID(LBRegistrySharedObject.class.getName()), this);
    }

    protected JMSID getQueueID() {
        return this.queueID;
    }

    protected void setQueueID(JMSID queueID) {
        this.queueID = queueID;
    }

    public abstract void start() throws ECFException;

    public Session getSession() {
        return this.session;
    }

    public MessageProducer getMessageProducer() {
        return this.messageProducer;
    }

    public TemporaryQueue getResponseQueue() {
        return this.responseQueue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void connect(ID targetID, IConnectContext connectContext) throws ContainerConnectException {
        if (targetID == null) {
            throw new ContainerConnectException("targetID cannot be null");
        }
        if (!(targetID instanceof JMSID)) {
            throw new ContainerConnectException("targetID not JMSID type");
        }
        JMSID jmsTargetID = (JMSID)targetID;
        Object object = this.getQueueConnectLock();
        synchronized (object) {
            this.fireContainerEvent((IContainerEvent)new ContainerConnectingEvent(this.getID(), (ID)jmsTargetID));
            try {
                this.setupJMSQueueConsumer(jmsTargetID);
            }
            catch (JMSException e) {
                throw new ContainerConnectException("Could not connect to targetID=" + targetID, (Throwable)e);
            }
            this.connectedID = jmsTargetID;
        }
        this.fireContainerEvent((IContainerEvent)new ContainerConnectedEvent(this.getID(), (ID)jmsTargetID));
    }

    protected Object getQueueConnectLock() {
        return this.queueConnectLock;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setupJMSQueueConsumer(JMSID jmsTargetID) throws JMSException {
        Object object = this.getQueueConnectLock();
        synchronized (object) {
            String jmsServerString = jmsTargetID.getBroker();
            String messageQueueName = jmsTargetID.getTopicOrQueueName();
            ConnectionFactory connectionFactory = this.getQueueConnectionFactory(jmsServerString, null);
            this.connection = connectionFactory.createConnection();
            this.connection.start();
            this.session = this.connection.createSession(false, 1);
            this.queue = this.session.createQueue(messageQueueName);
            this.messageProducer = this.session.createProducer(null);
            this.responseQueue = this.session.createTemporaryQueue();
            MessageConsumer consumer = this.session.createConsumer((Destination)this.queue);
            consumer.setMessageListener((MessageListener)this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void shutdownJMSQueueConsumer() {
        Object object = this.getQueueConnectLock();
        synchronized (object) {
            if (this.connection != null) {
                try {
                    this.messageProducer.close();
                }
                catch (JMSException e1) {
                    e1.printStackTrace();
                }
                this.messageProducer = null;
                this.queue = null;
                try {
                    this.session.close();
                }
                catch (JMSException e1) {
                    e1.printStackTrace();
                }
                this.session = null;
                try {
                    this.connection.close();
                }
                catch (JMSException e) {
                    e.printStackTrace();
                }
                this.connection = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void disconnect() {
        Object object = this.getQueueConnectLock();
        synchronized (object) {
            this.shutdownJMSQueueConsumer();
            this.connectedID = null;
        }
    }

    public void dispose() {
        this.disconnect();
        super.dispose();
        this.registry.dispose(this.getID());
        this.registry = null;
    }

    public Namespace getConnectNamespace() {
        return IDFactory.getDefault().getNamespaceByName("ecf.namespace.jmsid");
    }

    public ID getConnectedID() {
        return this.connectedID;
    }

    public ID getID() {
        return this.id;
    }

    public void onMessage(Message message) {
        this.registry.handleJMSMessage(message);
    }

    public void addRemoteServiceListener(IRemoteServiceListener listener) {
        this.registry.addRemoteServiceListener(listener);
    }

    public IFuture asyncGetRemoteServiceReferences(ID[] idFilter, String clazz, String filter) {
        return this.registry.asyncGetRemoteServiceReferences(idFilter, clazz, filter);
    }

    public IFuture asyncGetRemoteServiceReferences(ID target, String clazz, String filter) {
        return this.registry.asyncGetRemoteServiceReferences(target, clazz, filter);
    }

    public IFuture asyncGetRemoteServiceReferences(ID target, ID[] idFilter, String clazz, String filter) {
        return this.registry.asyncGetRemoteServiceReferences(target, idFilter, clazz, filter);
    }

    public IRemoteFilter createRemoteFilter(String filter) throws InvalidSyntaxException {
        return this.registry.createRemoteFilter(filter);
    }

    public IRemoteServiceReference[] getAllRemoteServiceReferences(String clazz, String filter) throws InvalidSyntaxException {
        return this.registry.getAllRemoteServiceReferences(clazz, filter);
    }

    public IRemoteService getRemoteService(IRemoteServiceReference reference) {
        return this.registry.getRemoteService(reference);
    }

    public IRemoteServiceID getRemoteServiceID(ID containerID, long containerRelativeID) {
        return this.registry.getRemoteServiceID(containerID, containerRelativeID);
    }

    public Namespace getRemoteServiceNamespace() {
        return this.registry.getRemoteServiceNamespace();
    }

    public IRemoteServiceReference getRemoteServiceReference(IRemoteServiceID serviceID) {
        return this.registry.getRemoteServiceReference(serviceID);
    }

    public IRemoteServiceReference[] getRemoteServiceReferences(ID[] idFilter, String clazz, String filter) throws InvalidSyntaxException {
        return this.registry.getRemoteServiceReferences(idFilter, clazz, filter);
    }

    public IRemoteServiceReference[] getRemoteServiceReferences(ID target, String clazz, String filter) throws InvalidSyntaxException, ContainerConnectException {
        return this.registry.getRemoteServiceReferences(target, clazz, filter);
    }

    public IRemoteServiceReference[] getRemoteServiceReferences(ID target, ID[] idFilter, String clazz, String filter) throws InvalidSyntaxException, ContainerConnectException {
        return this.registry.getRemoteServiceReferences(target, idFilter, clazz, filter);
    }

    public IRemoteServiceRegistration registerRemoteService(String[] clazzes, Object service, Dictionary properties) {
        return this.registry.registerRemoteService(clazzes, service, properties);
    }

    public void removeRemoteServiceListener(IRemoteServiceListener listener) {
        this.registry.removeRemoteServiceListener(listener);
    }

    public void setConnectContextForAuthentication(IConnectContext connectContext) {
        this.registry.setConnectContextForAuthentication(connectContext);
    }

    public boolean setRemoteServiceCallPolicy(IRemoteServiceCallPolicy policy) {
        return this.registry.setRemoteServiceCallPolicy(policy);
    }

    public boolean ungetRemoteService(IRemoteServiceReference reference) {
        return this.registry.ungetRemoteService(reference);
    }
}

