/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.reqcycle.traceability.storage.sesame.reachable;

import java.io.File;
import javax.inject.Inject;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.polarsys.reqcycle.traceability.storage.NoProjectStorageException;
import org.polarsys.reqcycle.traceability.storage.sesame.reachable.SesameVisitable;
import org.polarsys.reqcycle.uri.IReachableCreator;
import org.polarsys.reqcycle.uri.exceptions.VisitableException;
import org.polarsys.reqcycle.uri.model.Reachable;
import org.polarsys.reqcycle.uri.model.ReachableObject;
import org.polarsys.reqcycle.uri.visitors.IVisitable;
import org.polarsys.reqcycle.utils.inject.ZigguratInject;

public class SesameReachableObject
implements ReachableObject {
    private Reachable reachable;
    @Inject
    IReachableCreator creator;

    public SesameReachableObject(Reachable t) {
        this.reachable = t;
    }

    public Object getAdapter(Class adapter) {
        if (IFile.class.equals((Object)adapter)) {
            IWorkspace workspace = ResourcesPlugin.getWorkspace();
            IWorkspaceRoot workspaceRoot = workspace.getRoot();
            IFile file = workspaceRoot.getFile((IPath)new Path(this.reachable.getPath()));
            return file;
        }
        return null;
    }

    public IVisitable getVisitable() throws VisitableException {
        try {
            SesameVisitable sesameVisitable = new SesameVisitable(this.reachable);
            ZigguratInject.inject((Object[])new Object[]{sesameVisitable});
            return sesameVisitable;
        }
        catch (NoProjectStorageException e) {
            throw new VisitableException("Unable to create visitable for: " + this.reachable, (Throwable)e);
        }
    }

    public String getRevisionIdentification() {
        IFile f;
        String path = this.reachable.getPath();
        if ("file".equals(this.reachable.getScheme())) {
            File f2 = new File(path);
            if (f2.exists()) {
                return String.valueOf(f2.lastModified());
            }
        } else if ("platform".equals(this.reachable.getScheme()) && (f = ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)new Path(path))).exists()) {
            return String.valueOf(f.getModificationStamp());
        }
        return null;
    }

    public Reachable getReachable() {
        return this.reachable;
    }
}

